/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.AstExpression;
import build.buf.protovalidate.CompiledProgram;
import build.buf.protovalidate.Config;
import build.buf.protovalidate.DescriptorMappings;
import build.buf.protovalidate.Expression;
import build.buf.protovalidate.FieldPathUtils;
import build.buf.protovalidate.ObjectValue;
import build.buf.protovalidate.ProtoAdapter;
import build.buf.protovalidate.Variable;
import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldRules;
import build.buf.validate.PredefinedRules;
import build.buf.validate.ValidateProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TypeRegistry;
import dev.cel.bundle.Cel;
import dev.cel.common.types.StructTypeReference;
import dev.cel.runtime.CelEvaluationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;

final class RuleCache {
    private static final ExtensionRegistry EXTENSION_REGISTRY = ExtensionRegistry.newInstance();
    private static final Map<Descriptors.FieldDescriptor, List<CelRule>> descriptorMap;
    private final Cel cel;
    private final TypeRegistry typeRegistry;
    private final ExtensionRegistry extensionRegistry;
    private final boolean allowUnknownFields;

    RuleCache(Cel cel, Config config) {
        this.cel = cel;
        this.typeRegistry = config.getTypeRegistry();
        this.extensionRegistry = config.getExtensionRegistry();
        this.allowUnknownFields = config.isAllowingUnknownFields();
    }

    List<CompiledProgram> compile(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, boolean forItems) throws CompilationException {
        ResolvedRule resolved = this.resolveRules(fieldDescriptor, fieldRules, forItems);
        if (resolved == null) {
            return Collections.emptyList();
        }
        Message message = resolved.message;
        ArrayList<CelRule> completeProgramList = new ArrayList<CelRule>();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor ruleFieldDesc = entry.getKey();
            List<CelRule> programList = this.compileRule(fieldDescriptor, forItems, resolved.setOneof, ruleFieldDesc, message);
            if (programList == null) continue;
            completeProgramList.addAll(programList);
        }
        ArrayList<CompiledProgram> programs = new ArrayList<CompiledProgram>();
        for (CelRule rule : completeProgramList) {
            Cel ruleCel = this.getRuleCel(fieldDescriptor, message, rule.field, forItems);
            try {
                programs.add(new CompiledProgram(ruleCel.createProgram(rule.astExpression.ast), rule.astExpression.source, rule.rulePath, new ObjectValue(rule.field, message.getField(rule.field)), Variable.newRuleVariable(message, ProtoAdapter.toCel(rule.field, message.getField(rule.field)))));
            }
            catch (CelEvaluationException e) {
                throw new CompilationException("failed to evaluate rule " + rule.astExpression.source.id, e);
            }
        }
        return Collections.unmodifiableList(programs);
    }

    private @Nullable List<CelRule> compileRule(Descriptors.FieldDescriptor fieldDescriptor, boolean forItems, Descriptors.FieldDescriptor setOneof, Descriptors.FieldDescriptor ruleFieldDesc, Message message) throws CompilationException {
        List<CelRule> celRules = descriptorMap.get(fieldDescriptor);
        if (celRules != null) {
            return celRules;
        }
        PredefinedRules rules = this.getFieldRules(ruleFieldDesc);
        if (rules == null) {
            return null;
        }
        List<Expression> expressions = Expression.fromRules(rules.getCelList());
        celRules = new ArrayList<CelRule>(expressions.size());
        Cel ruleCel = this.getRuleCel(fieldDescriptor, message, ruleFieldDesc, forItems);
        for (Expression expression : expressions) {
            FieldPath rulePath = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(setOneof)).addElements(FieldPathUtils.fieldPathElement(ruleFieldDesc)).build();
            celRules.add(new CelRule(AstExpression.newAstExpression(ruleCel, expression), ruleFieldDesc, rulePath));
        }
        descriptorMap.put(ruleFieldDesc, celRules);
        return celRules;
    }

    private @Nullable PredefinedRules getFieldRules(Descriptors.FieldDescriptor ruleFieldDesc) throws CompilationException {
        PredefinedRules rules;
        DescriptorProtos.FieldOptions options = ruleFieldDesc.getOptions();
        if (options.getUnknownFields().hasField(ValidateProto.predefined.getNumber())) {
            try {
                options = DescriptorProtos.FieldOptions.parseFrom(options.toByteString(), (ExtensionRegistryLite)EXTENSION_REGISTRY);
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompilationException("Failed to parse field options", e);
            }
        }
        if (!options.hasExtension(ValidateProto.predefined)) {
            return null;
        }
        Object extensionValue = options.getField(ValidateProto.predefined.getDescriptor());
        if (extensionValue instanceof PredefinedRules) {
            rules = (PredefinedRules)extensionValue;
        } else if (extensionValue instanceof MessageLite) {
            try {
                rules = PredefinedRules.parseFrom(((MessageLite)extensionValue).toByteString());
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompilationException("Failed to parse field rules", e);
            }
        } else {
            return null;
        }
        return rules;
    }

    private Cel getRuleCel(Descriptors.FieldDescriptor fieldDescriptor, Message ruleMessage, Descriptors.FieldDescriptor ruleFieldDesc, boolean forItems) {
        return this.cel.toCelBuilder().addMessageTypes(ruleMessage.getDescriptorForType()).addVar("this", DescriptorMappings.getCELType(fieldDescriptor, forItems)).addVar("rules", StructTypeReference.create(ruleMessage.getDescriptorForType().getFullName())).addVar("rule", DescriptorMappings.getCELType(ruleFieldDesc, false)).build();
    }

    private @Nullable ResolvedRule resolveRules(Descriptors.FieldDescriptor fieldDescriptor, FieldRules fieldRules, boolean forItems) throws CompilationException {
        Descriptors.FieldDescriptor oneofFieldDescriptor = fieldRules.getOneofFieldDescriptor(DescriptorMappings.FIELD_RULES_ONEOF_DESC);
        if (oneofFieldDescriptor == null) {
            return null;
        }
        Descriptors.FieldDescriptor expectedRuleDescriptor = DescriptorMappings.getExpectedRuleDescriptor(fieldDescriptor, forItems);
        if (expectedRuleDescriptor != null && !oneofFieldDescriptor.getFullName().equals(expectedRuleDescriptor.getFullName())) {
            throw new CompilationException(String.format("expected rule %s, got %s on field %s", expectedRuleDescriptor.getName(), oneofFieldDescriptor.getName(), fieldDescriptor.getName()));
        }
        if (expectedRuleDescriptor == null || !fieldRules.hasField(oneofFieldDescriptor)) {
            if (expectedRuleDescriptor == null && fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new CompilationException(String.format("mismatched message rules, %s is not a valid rule for field %s", oneofFieldDescriptor.getName(), fieldDescriptor.getName()));
            }
            return null;
        }
        Message typeRules = (Message)fieldRules.getField(oneofFieldDescriptor);
        if (!typeRules.getUnknownFields().isEmpty()) {
            Descriptors.Descriptor expectedRuleMessageDescriptor = this.typeRegistry.find(expectedRuleDescriptor.getMessageType().getFullName());
            if (expectedRuleMessageDescriptor == null) {
                expectedRuleMessageDescriptor = expectedRuleDescriptor.getMessageType();
            }
            try {
                typeRules = DynamicMessage.parseFrom(expectedRuleMessageDescriptor, typeRules.toByteString(), this.extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.allowUnknownFields && !typeRules.getUnknownFields().isEmpty()) {
            throw new CompilationException("unrecognized field rules");
        }
        return new ResolvedRule(typeRules, oneofFieldDescriptor);
    }

    static {
        EXTENSION_REGISTRY.add(ValidateProto.predefined);
        descriptorMap = new ConcurrentHashMap<Descriptors.FieldDescriptor, List<CelRule>>();
    }

    private static class ResolvedRule {
        final Message message;
        final Descriptors.FieldDescriptor setOneof;

        ResolvedRule(Message message, Descriptors.FieldDescriptor setOneof) {
            this.message = message;
            this.setOneof = setOneof;
        }
    }

    private static class CelRule {
        final AstExpression astExpression;
        final Descriptors.FieldDescriptor field;
        final FieldPath rulePath;

        private CelRule(AstExpression astExpression, Descriptors.FieldDescriptor field, FieldPath rulePath) {
            this.astExpression = astExpression;
            this.field = field;
            this.rulePath = rulePath;
        }
    }
}

