/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.validate.FieldPath;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

final class ValueEvaluator
implements Evaluator {
    private final @Nullable Descriptors.FieldDescriptor descriptor;
    private final @Nullable FieldPath nestedRule;
    private @Nullable Object zero;
    private final List<Evaluator> evaluators = new ArrayList<Evaluator>();
    private boolean ignoreEmpty;

    ValueEvaluator(@Nullable Descriptors.FieldDescriptor descriptor, @Nullable FieldPath nestedRule) {
        this.descriptor = descriptor;
        this.nestedRule = nestedRule;
    }

    @Nullable Descriptors.FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Nullable FieldPath getNestedRule() {
        return this.nestedRule;
    }

    boolean hasNestedRule() {
        return this.nestedRule != null;
    }

    @Override
    public boolean tautology() {
        return this.evaluators.isEmpty();
    }

    @Override
    public List<RuleViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        if (this.shouldIgnore(val.value(Object.class))) {
            return RuleViolation.NO_VIOLATIONS;
        }
        ArrayList<RuleViolation.Builder> allViolations = new ArrayList<RuleViolation.Builder>();
        for (Evaluator evaluator : this.evaluators) {
            List<RuleViolation.Builder> violations = evaluator.evaluate(val, failFast);
            if (failFast && !violations.isEmpty()) {
                return violations;
            }
            allViolations.addAll(violations);
        }
        if (allViolations.isEmpty()) {
            return RuleViolation.NO_VIOLATIONS;
        }
        return allViolations;
    }

    void append(Evaluator eval) {
        if (!eval.tautology()) {
            this.evaluators.add(eval);
        }
    }

    void setIgnoreEmpty(Object zero) {
        this.ignoreEmpty = true;
        this.zero = zero;
    }

    private boolean shouldIgnore(Object value) {
        return this.ignoreEmpty && Objects.equals(value, this.zero);
    }
}

