/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ProtoType {
    public static final ProtoType BOOL = new ProtoType(true, "bool");
    public static final ProtoType BYTES = new ProtoType(true, "bytes");
    public static final ProtoType DOUBLE = new ProtoType(true, "double");
    public static final ProtoType FLOAT = new ProtoType(true, "float");
    public static final ProtoType FIXED32 = new ProtoType(true, "fixed32");
    public static final ProtoType FIXED64 = new ProtoType(true, "fixed64");
    public static final ProtoType INT32 = new ProtoType(true, "int32");
    public static final ProtoType INT64 = new ProtoType(true, "int64");
    public static final ProtoType SFIXED32 = new ProtoType(true, "sfixed32");
    public static final ProtoType SFIXED64 = new ProtoType(true, "sfixed64");
    public static final ProtoType SINT32 = new ProtoType(true, "sint32");
    public static final ProtoType SINT64 = new ProtoType(true, "sint64");
    public static final ProtoType STRING = new ProtoType(true, "string");
    public static final ProtoType UINT32 = new ProtoType(true, "uint32");
    public static final ProtoType UINT64 = new ProtoType(true, "uint64");
    private static final Map<String, ProtoType> SCALAR_TYPES;
    private final boolean isScalar;
    private final String typeName;
    private final boolean isMap;
    private final ProtoType keyType;
    private final ProtoType valueType;

    private ProtoType(boolean isScalar, String typeName) {
        Preconditions.checkNotNull(typeName, "typeName == null");
        this.isScalar = isScalar;
        this.typeName = typeName;
        this.isMap = false;
        this.keyType = null;
        this.valueType = null;
    }

    ProtoType(ProtoType keyType, ProtoType valueType, String typeName) {
        Preconditions.checkNotNull(keyType, "keyType == null");
        Preconditions.checkNotNull(valueType, "valueType == null");
        Preconditions.checkNotNull(typeName, "typeName == null");
        Preconditions.checkArgument(keyType.isScalar() && !keyType.equals(BYTES) && !keyType.equals(DOUBLE) && !keyType.equals(FLOAT), "map key must be non-byte, non-floating point scalar: %s", (Object)keyType);
        this.isScalar = false;
        this.typeName = typeName;
        this.isMap = true;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public String simpleName() {
        int dot = this.typeName.lastIndexOf(46);
        return this.typeName.substring(dot + 1);
    }

    public String enclosingTypeOrPackage() {
        int dot = this.typeName.lastIndexOf(46);
        return dot == -1 ? null : this.typeName.substring(0, dot);
    }

    public boolean isScalar() {
        return this.isScalar;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public ProtoType keyType() {
        return this.keyType;
    }

    public ProtoType valueType() {
        return this.valueType;
    }

    public static ProtoType get(String enclosingTypeOrPackage, String typeName) {
        return enclosingTypeOrPackage != null ? ProtoType.get(enclosingTypeOrPackage + "." + typeName) : ProtoType.get(typeName);
    }

    public static ProtoType get(String name) {
        ProtoType scalar = SCALAR_TYPES.get(name);
        if (scalar != null) {
            return scalar;
        }
        if (name == null || name.isEmpty() || name.contains("#")) {
            throw new IllegalArgumentException("unexpected name: " + name);
        }
        if (name.startsWith("map<") && name.endsWith(">")) {
            int comma = name.indexOf(44);
            if (comma == -1) {
                throw new IllegalArgumentException("expected ',' in map type: " + name);
            }
            ProtoType key = ProtoType.get(name.substring(4, comma).trim());
            ProtoType value = ProtoType.get(name.substring(comma + 1, name.length() - 1).trim());
            return new ProtoType(key, value, name);
        }
        return new ProtoType(false, name);
    }

    public ProtoType nestedType(String name) {
        if (this.isScalar) {
            throw new UnsupportedOperationException("scalar cannot have a nested type");
        }
        if (this.isMap) {
            throw new UnsupportedOperationException("map cannot have a nested type");
        }
        if (name == null || name.contains(".") || name.isEmpty()) {
            throw new IllegalArgumentException("unexpected name: " + name);
        }
        return new ProtoType(false, this.typeName + "." + name);
    }

    public boolean equals(Object o) {
        return o instanceof ProtoType && this.typeName.equals(((ProtoType)o).typeName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    public String toString() {
        return this.typeName;
    }

    static {
        LinkedHashMap<String, ProtoType> scalarTypes = new LinkedHashMap<String, ProtoType>();
        scalarTypes.put(ProtoType.BOOL.typeName, BOOL);
        scalarTypes.put(ProtoType.BYTES.typeName, BYTES);
        scalarTypes.put(ProtoType.DOUBLE.typeName, DOUBLE);
        scalarTypes.put(ProtoType.FLOAT.typeName, FLOAT);
        scalarTypes.put(ProtoType.FIXED32.typeName, FIXED32);
        scalarTypes.put(ProtoType.FIXED64.typeName, FIXED64);
        scalarTypes.put(ProtoType.INT32.typeName, INT32);
        scalarTypes.put(ProtoType.INT64.typeName, INT64);
        scalarTypes.put(ProtoType.SFIXED32.typeName, SFIXED32);
        scalarTypes.put(ProtoType.SFIXED64.typeName, SFIXED64);
        scalarTypes.put(ProtoType.SINT32.typeName, SINT32);
        scalarTypes.put(ProtoType.SINT64.typeName, SINT64);
        scalarTypes.put(ProtoType.STRING.typeName, STRING);
        scalarTypes.put(ProtoType.UINT32.typeName, UINT32);
        scalarTypes.put(ProtoType.UINT64.typeName, UINT64);
        SCALAR_TYPES = Collections.unmodifiableMap(scalarTypes);
    }
}

