/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public final class SchemaLoader {
    static final String DESCRIPTOR_PROTO = "google/protobuf/descriptor.proto";
    private final List<Path> sources = new ArrayList<Path>();
    private final List<String> protos = new ArrayList<String>();

    public SchemaLoader addSource(File file) {
        return this.addSource(file.toPath());
    }

    public SchemaLoader addSource(Path path) {
        this.sources.add(path);
        return this;
    }

    public List<Path> sources() {
        return this.sources;
    }

    public SchemaLoader addProto(String proto) {
        this.protos.add(proto);
        return this;
    }

    public List<String> protos() {
        return this.protos;
    }

    public Schema load() throws IOException {
        if (this.sources.isEmpty()) {
            throw new IllegalStateException("No sources added.");
        }
        try (Closer closer = Closer.create();){
            LinkedHashMap<Path, Path> directories = new LinkedHashMap<Path, Path>();
            for (Path source2 : this.sources) {
                if (Files.isRegularFile(source2, new LinkOption[0])) {
                    FileSystem sourceFs = FileSystems.newFileSystem(source2, this.getClass().getClassLoader());
                    closer.register(sourceFs);
                    directories.put(source2, Iterables.getOnlyElement(sourceFs.getRootDirectories()));
                    continue;
                }
                directories.put(source2, source2);
            }
            Schema schema = this.loadFromDirectories(directories);
            return schema;
        }
    }

    private Schema loadFromDirectories(Map<Path, Path> directories) throws IOException {
        final ArrayDeque<String> protos = new ArrayDeque<String>(this.protos);
        if (protos.isEmpty()) {
            for (final Map.Entry<Path, Path> entry : directories.entrySet()) {
                Files.walkFileTree(entry.getValue(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(".proto")) {
                            protos.add(((Path)entry.getValue()).relativize(file).toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        LinkedHashMap<String, ProtoFile> loaded = new LinkedHashMap<String, ProtoFile>();
        loaded.put(DESCRIPTOR_PROTO, this.loadDescriptorProto());
        while (!protos.isEmpty()) {
            String proto = (String)protos.removeFirst();
            if (loaded.containsKey(proto)) continue;
            ProtoFileElement element = null;
            for (Map.Entry<Path, Path> entry : directories.entrySet()) {
                Source source2 = SchemaLoader.source(entry.getValue(), proto);
                if (source2 == null) continue;
                Path base = entry.getKey();
                try {
                    Location location = Location.get(base.toString(), proto);
                    String data = Okio.buffer(source2).readUtf8();
                    element = ProtoParser.parse(location, data);
                    break;
                }
                catch (IOException e) {
                    throw new IOException("Failed to load " + proto + " from " + String.valueOf(base), e);
                }
                finally {
                    source2.close();
                }
            }
            if (element == null) {
                throw new FileNotFoundException("Failed to locate " + proto + " in " + String.valueOf(this.sources));
            }
            ProtoFile protoFile = ProtoFile.get(element);
            loaded.put(proto, protoFile);
            for (String importPath : element.getImports()) {
                protos.addLast(importPath);
            }
        }
        return new Linker(loaded.values()).link();
    }

    private ProtoFile loadDescriptorProto() throws IOException {
        InputStream resourceAsStream = SchemaLoader.class.getResourceAsStream("/google/protobuf/descriptor.proto");
        try (BufferedSource buffer = Okio.buffer(Okio.source(resourceAsStream));){
            String data = buffer.readUtf8();
            Location location = Location.get("", DESCRIPTOR_PROTO);
            ProtoFileElement element = ProtoParser.parse(location, data);
            ProtoFile protoFile = ProtoFile.get(element);
            return protoFile;
        }
    }

    private static Source source(Path base, String path) throws IOException {
        Path resolvedPath = base.resolve(path);
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            return Okio.source(resolvedPath, new OpenOption[0]);
        }
        return null;
    }
}

