/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.bundle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.bundle.CelEnvironment;
import dev.cel.bundle.CelEnvironmentException;
import dev.cel.bundle.RequiredFieldsChecker;
import dev.cel.common.CelIssue;
import dev.cel.common.formats.CelFileSource;
import dev.cel.common.formats.ParserContext;
import dev.cel.common.formats.YamlHelper;
import dev.cel.common.formats.YamlParserContextImpl;
import dev.cel.common.internal.CelCodePointArray;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public final class CelEnvironmentYamlParser {
    private static final CelEnvironment.TypeDecl ERROR_TYPE_DECL = CelEnvironment.TypeDecl.create("*error*");
    private static final CelEnvironment.VariableDecl ERROR_VARIABLE_DECL = CelEnvironment.VariableDecl.create("*error*", ERROR_TYPE_DECL);
    private static final CelEnvironment.FunctionDecl ERROR_FUNCTION_DECL = CelEnvironment.FunctionDecl.create("*error*", ImmutableSet.of());
    private static final CelEnvironment.ExtensionConfig ERROR_EXTENSION_DECL = CelEnvironment.ExtensionConfig.of("*error*");

    public static CelEnvironmentYamlParser newInstance() {
        return new CelEnvironmentYamlParser();
    }

    public CelEnvironment parse(String environmentYamlSource) throws CelEnvironmentException {
        return this.parse(environmentYamlSource, "<input>");
    }

    public CelEnvironment parse(String environmentYamlSource, String description) throws CelEnvironmentException {
        ParserImpl parser = new ParserImpl();
        return parser.parseYaml(environmentYamlSource, description);
    }

    private ImmutableSet<CelEnvironment.VariableDecl> parseVariables(ParserContext<Node> ctx, Node node) {
        long valueId = ctx.collectMetadata(node);
        ImmutableSet.Builder variableSetBuilder = ImmutableSet.builder();
        if (!YamlHelper.assertYamlType(ctx, valueId, node, YamlHelper.YamlNodeType.LIST)) {
            return variableSetBuilder.build();
        }
        SequenceNode variableListNode = (SequenceNode)node;
        for (Node elementNode : variableListNode.getValue()) {
            variableSetBuilder.add(this.parseVariable(ctx, elementNode));
        }
        return variableSetBuilder.build();
    }

    private CelEnvironment.VariableDecl parseVariable(ParserContext<Node> ctx, Node node) {
        long variableId = ctx.collectMetadata(node);
        if (!YamlHelper.assertYamlType(ctx, variableId, node, YamlHelper.YamlNodeType.MAP)) {
            return ERROR_VARIABLE_DECL;
        }
        MappingNode variableMap = (MappingNode)node;
        CelEnvironment.VariableDecl.Builder builder = CelEnvironment.VariableDecl.newBuilder();
        RequiredFieldsChecker typeDeclBuilder = null;
        block12: for (NodeTuple nodeTuple : variableMap.getValue()) {
            String keyName;
            Node keyNode = nodeTuple.getKeyNode();
            long keyId = ctx.collectMetadata(keyNode);
            Node valueNode = nodeTuple.getValueNode();
            switch (keyName = ((ScalarNode)keyNode).getValue()) {
                case "name": {
                    builder.setName(YamlHelper.newString(ctx, valueNode));
                    continue block12;
                }
                case "type": {
                    if (typeDeclBuilder != null) {
                        ctx.reportError(keyId, String.format("'type' tag cannot be used together with inlined 'type_name', 'is_type_param' or 'params': %s", keyName));
                        continue block12;
                    }
                    builder.setType(CelEnvironmentYamlParser.parseTypeDecl(ctx, valueNode));
                    continue block12;
                }
                case "type_name": 
                case "is_type_param": 
                case "params": {
                    if (typeDeclBuilder == null) {
                        typeDeclBuilder = CelEnvironment.TypeDecl.newBuilder();
                    }
                    typeDeclBuilder = CelEnvironmentYamlParser.parseInlinedTypeDecl(ctx, keyId, keyNode, valueNode, (CelEnvironment.TypeDecl.Builder)typeDeclBuilder);
                    continue block12;
                }
            }
            ctx.reportError(keyId, String.format("Unsupported variable tag: %s", keyName));
        }
        if (typeDeclBuilder != null) {
            if (!YamlHelper.assertRequiredFields(ctx, variableId, typeDeclBuilder.getMissingRequiredFieldNames())) {
                return ERROR_VARIABLE_DECL;
            }
            builder.setType(((CelEnvironment.TypeDecl.Builder)typeDeclBuilder).build());
        }
        if (!YamlHelper.assertRequiredFields(ctx, variableId, builder.getMissingRequiredFieldNames())) {
            return ERROR_VARIABLE_DECL;
        }
        return builder.build();
    }

    private ImmutableSet<CelEnvironment.FunctionDecl> parseFunctions(ParserContext<Node> ctx, Node node) {
        long valueId = ctx.collectMetadata(node);
        ImmutableSet.Builder functionSetBuilder = ImmutableSet.builder();
        if (!YamlHelper.assertYamlType(ctx, valueId, node, YamlHelper.YamlNodeType.LIST)) {
            return functionSetBuilder.build();
        }
        SequenceNode functionListNode = (SequenceNode)node;
        for (Node elementNode : functionListNode.getValue()) {
            functionSetBuilder.add(this.parseFunction(ctx, elementNode));
        }
        return functionSetBuilder.build();
    }

    private CelEnvironment.FunctionDecl parseFunction(ParserContext<Node> ctx, Node node) {
        long functionId = ctx.collectMetadata(node);
        if (!YamlHelper.assertYamlType(ctx, functionId, node, YamlHelper.YamlNodeType.MAP)) {
            return ERROR_FUNCTION_DECL;
        }
        MappingNode functionMap = (MappingNode)node;
        CelEnvironment.FunctionDecl.Builder builder = CelEnvironment.FunctionDecl.newBuilder();
        block8: for (NodeTuple nodeTuple : functionMap.getValue()) {
            String keyName;
            Node keyNode = nodeTuple.getKeyNode();
            long keyId = ctx.collectMetadata(keyNode);
            Node valueNode = nodeTuple.getValueNode();
            switch (keyName = ((ScalarNode)keyNode).getValue()) {
                case "name": {
                    builder.setName(YamlHelper.newString(ctx, valueNode));
                    continue block8;
                }
                case "overloads": {
                    builder.setOverloads(CelEnvironmentYamlParser.parseOverloads(ctx, valueNode));
                    continue block8;
                }
            }
            ctx.reportError(keyId, String.format("Unsupported function tag: %s", keyName));
        }
        if (!YamlHelper.assertRequiredFields(ctx, functionId, builder.getMissingRequiredFieldNames())) {
            return ERROR_FUNCTION_DECL;
        }
        return builder.build();
    }

    private static ImmutableSet<CelEnvironment.OverloadDecl> parseOverloads(ParserContext<Node> ctx, Node node) {
        long listId = ctx.collectMetadata(node);
        ImmutableSet.Builder overloadSetBuilder = ImmutableSet.builder();
        if (!YamlHelper.assertYamlType(ctx, listId, node, YamlHelper.YamlNodeType.LIST)) {
            return overloadSetBuilder.build();
        }
        SequenceNode overloadListNode = (SequenceNode)node;
        for (Node overloadMapNode : overloadListNode.getValue()) {
            long overloadMapId = ctx.collectMetadata(overloadMapNode);
            if (!YamlHelper.assertYamlType(ctx, overloadMapId, overloadMapNode, YamlHelper.YamlNodeType.MAP)) continue;
            MappingNode mapNode = (MappingNode)overloadMapNode;
            CelEnvironment.OverloadDecl.Builder overloadDeclBuilder = CelEnvironment.OverloadDecl.newBuilder();
            block13: for (NodeTuple nodeTuple : mapNode.getValue()) {
                String fieldName;
                Node keyNode = nodeTuple.getKeyNode();
                long keyId = ctx.collectMetadata(keyNode);
                if (!YamlHelper.assertYamlType(ctx, keyId, keyNode, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) continue;
                Node valueNode = nodeTuple.getValueNode();
                switch (fieldName = ((ScalarNode)keyNode).getValue()) {
                    case "id": {
                        overloadDeclBuilder.setId(YamlHelper.newString(ctx, valueNode));
                        continue block13;
                    }
                    case "args": {
                        overloadDeclBuilder.addArguments(CelEnvironmentYamlParser.parseOverloadArguments(ctx, valueNode));
                        continue block13;
                    }
                    case "return": {
                        overloadDeclBuilder.setReturnType(CelEnvironmentYamlParser.parseTypeDecl(ctx, valueNode));
                        continue block13;
                    }
                    case "target": {
                        overloadDeclBuilder.setTarget(CelEnvironmentYamlParser.parseTypeDecl(ctx, valueNode));
                        continue block13;
                    }
                }
                ctx.reportError(keyId, String.format("Unsupported overload tag: %s", fieldName));
            }
            if (!YamlHelper.assertRequiredFields(ctx, overloadMapId, overloadDeclBuilder.getMissingRequiredFieldNames())) continue;
            overloadSetBuilder.add(overloadDeclBuilder.build());
        }
        return overloadSetBuilder.build();
    }

    private static ImmutableList<CelEnvironment.TypeDecl> parseOverloadArguments(ParserContext<Node> ctx, Node node) {
        long listValueId = ctx.collectMetadata(node);
        if (!YamlHelper.assertYamlType(ctx, listValueId, node, YamlHelper.YamlNodeType.LIST)) {
            return ImmutableList.of();
        }
        SequenceNode paramsListNode = (SequenceNode)node;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Node elementNode : paramsListNode.getValue()) {
            builder.add(CelEnvironmentYamlParser.parseTypeDecl(ctx, elementNode));
        }
        return builder.build();
    }

    private static ImmutableSet<CelEnvironment.ExtensionConfig> parseExtensions(ParserContext<Node> ctx, Node node) {
        long valueId = ctx.collectMetadata(node);
        ImmutableSet.Builder extensionConfigBuilder = ImmutableSet.builder();
        if (!YamlHelper.assertYamlType(ctx, valueId, node, YamlHelper.YamlNodeType.LIST)) {
            return extensionConfigBuilder.build();
        }
        SequenceNode extensionListNode = (SequenceNode)node;
        for (Node elementNode : extensionListNode.getValue()) {
            extensionConfigBuilder.add(CelEnvironmentYamlParser.parseExtension(ctx, elementNode));
        }
        return extensionConfigBuilder.build();
    }

    private static CelEnvironment.ExtensionConfig parseExtension(ParserContext<Node> ctx, Node node) {
        long extensionId = ctx.collectMetadata(node);
        if (!YamlHelper.assertYamlType(ctx, extensionId, node, YamlHelper.YamlNodeType.MAP)) {
            return ERROR_EXTENSION_DECL;
        }
        MappingNode extensionMap = (MappingNode)node;
        CelEnvironment.ExtensionConfig.Builder builder = CelEnvironment.ExtensionConfig.newBuilder();
        block8: for (NodeTuple nodeTuple : extensionMap.getValue()) {
            String keyName;
            Node keyNode = nodeTuple.getKeyNode();
            long keyId = ctx.collectMetadata(keyNode);
            Node valueNode = nodeTuple.getValueNode();
            switch (keyName = ((ScalarNode)keyNode).getValue()) {
                case "name": {
                    builder.setName(YamlHelper.newString(ctx, valueNode));
                    continue block8;
                }
                case "version": {
                    if (YamlHelper.validateYamlType(valueNode, YamlHelper.YamlNodeType.INTEGER)) {
                        builder.setVersion(YamlHelper.newInteger(ctx, valueNode));
                        continue block8;
                    }
                    if (YamlHelper.validateYamlType(valueNode, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) {
                        String versionStr = YamlHelper.newString(ctx, valueNode);
                        if (versionStr.equals("latest")) {
                            builder.setVersion(Integer.MAX_VALUE);
                            continue block8;
                        }
                        Integer versionInt = CelEnvironmentYamlParser.tryParse(versionStr);
                        if (versionInt != null) {
                            builder.setVersion(versionInt);
                            continue block8;
                        }
                    }
                    ctx.reportError(keyId, String.format("Unsupported version tag: %s", keyName));
                    continue block8;
                }
            }
            ctx.reportError(keyId, String.format("Unsupported extension tag: %s", keyName));
        }
        if (!YamlHelper.assertRequiredFields(ctx, extensionId, builder.getMissingRequiredFieldNames())) {
            return ERROR_EXTENSION_DECL;
        }
        return builder.build();
    }

    private static @Nullable Integer tryParse(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @CanIgnoreReturnValue
    private static CelEnvironment.TypeDecl.Builder parseInlinedTypeDecl(ParserContext<Node> ctx, long keyId, Node keyNode, Node valueNode, CelEnvironment.TypeDecl.Builder builder) {
        if (!YamlHelper.assertYamlType(ctx, keyId, keyNode, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) {
            return builder;
        }
        MappingNode mapNode = new MappingNode(Tag.MAP, Collections.singletonList(new NodeTuple(keyNode, valueNode)), DumperOptions.FlowStyle.AUTO);
        return CelEnvironmentYamlParser.parseTypeDeclFields(ctx, mapNode, builder);
    }

    private static CelEnvironment.TypeDecl parseTypeDecl(ParserContext<Node> ctx, Node node) {
        CelEnvironment.TypeDecl.Builder builder = CelEnvironment.TypeDecl.newBuilder();
        long id = ctx.collectMetadata(node);
        if (!YamlHelper.assertYamlType(ctx, id, node, YamlHelper.YamlNodeType.MAP)) {
            return ERROR_TYPE_DECL;
        }
        MappingNode mapNode = (MappingNode)node;
        return CelEnvironmentYamlParser.parseTypeDeclFields(ctx, mapNode, builder).build();
    }

    @CanIgnoreReturnValue
    private static CelEnvironment.TypeDecl.Builder parseTypeDeclFields(ParserContext<Node> ctx, MappingNode mapNode, CelEnvironment.TypeDecl.Builder builder) {
        block10: for (NodeTuple nodeTuple : mapNode.getValue()) {
            String fieldName;
            Node keyNode = nodeTuple.getKeyNode();
            long keyId = ctx.collectMetadata(keyNode);
            if (!YamlHelper.assertYamlType(ctx, keyId, keyNode, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) continue;
            Node valueNode = nodeTuple.getValueNode();
            switch (fieldName = ((ScalarNode)keyNode).getValue()) {
                case "type_name": {
                    builder.setName(YamlHelper.newString(ctx, valueNode));
                    break;
                }
                case "is_type_param": {
                    builder.setIsTypeParam(YamlHelper.newBoolean(ctx, valueNode));
                    break;
                }
                case "params": {
                    long listValueId = ctx.collectMetadata(valueNode);
                    if (!YamlHelper.assertYamlType(ctx, listValueId, valueNode, YamlHelper.YamlNodeType.LIST)) break;
                    SequenceNode paramsListNode = (SequenceNode)valueNode;
                    for (Node elementNode : paramsListNode.getValue()) {
                        builder.addParams(CelEnvironmentYamlParser.parseTypeDecl(ctx, elementNode));
                    }
                    continue block10;
                }
                default: {
                    ctx.reportError(keyId, String.format("Unsupported type decl tag: %s", fieldName));
                }
            }
        }
        return builder;
    }

    private CelEnvironmentYamlParser() {
    }

    private class ParserImpl {
        private ParserImpl() {
        }

        private CelEnvironment parseYaml(String source2, String description) throws CelEnvironmentException {
            Node node;
            try {
                node = YamlHelper.parseYamlSource(source2).orElseThrow(() -> new CelEnvironmentException(String.format("YAML document empty or malformed: %s", source2)));
            }
            catch (RuntimeException e) {
                throw new CelEnvironmentException("YAML document is malformed: " + e.getMessage(), e);
            }
            CelFileSource environmentSource = CelFileSource.newBuilder(CelCodePointArray.fromString(source2)).setDescription(description).build();
            ParserContext<Node> ctx = YamlParserContextImpl.newInstance(environmentSource);
            CelEnvironment.Builder builder = this.parseConfig(ctx, node);
            environmentSource = environmentSource.toBuilder().setPositionsMap(ctx.getIdToOffsetMap()).build();
            if (!ctx.getIssues().isEmpty()) {
                throw new CelEnvironmentException(CelIssue.toDisplayString(ctx.getIssues(), environmentSource));
            }
            return builder.setSource(environmentSource).build();
        }

        private CelEnvironment.Builder parseConfig(ParserContext<Node> ctx, Node node) {
            CelEnvironment.Builder builder = CelEnvironment.newBuilder();
            long id = ctx.collectMetadata(node);
            if (!YamlHelper.assertYamlType(ctx, id, node, YamlHelper.YamlNodeType.MAP)) {
                return builder;
            }
            MappingNode rootNode = (MappingNode)node;
            block16: for (NodeTuple nodeTuple : rootNode.getValue()) {
                String fieldName;
                Node keyNode = nodeTuple.getKeyNode();
                long keyId = ctx.collectMetadata(keyNode);
                if (!YamlHelper.assertYamlType(ctx, keyId, keyNode, YamlHelper.YamlNodeType.STRING, YamlHelper.YamlNodeType.TEXT)) continue;
                Node valueNode = nodeTuple.getValueNode();
                switch (fieldName = ((ScalarNode)keyNode).getValue()) {
                    case "name": {
                        builder.setName(YamlHelper.newString(ctx, valueNode));
                        continue block16;
                    }
                    case "description": {
                        builder.setDescription(YamlHelper.newString(ctx, valueNode));
                        continue block16;
                    }
                    case "container": {
                        builder.setContainer(YamlHelper.newString(ctx, valueNode));
                        continue block16;
                    }
                    case "variables": {
                        builder.setVariables(CelEnvironmentYamlParser.this.parseVariables(ctx, valueNode));
                        continue block16;
                    }
                    case "functions": {
                        builder.setFunctions(CelEnvironmentYamlParser.this.parseFunctions(ctx, valueNode));
                        continue block16;
                    }
                    case "extensions": {
                        builder.addExtensions(CelEnvironmentYamlParser.parseExtensions(ctx, valueNode));
                        continue block16;
                    }
                }
                ctx.reportError(id, "Unknown config tag: " + fieldName);
            }
            return builder;
        }
    }
}

