/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.FieldMask;
import dev.cel.checker.AutoValue_ProtoTypeMask;
import dev.cel.checker.AutoValue_ProtoTypeMask_FieldPath;

@Immutable
@AutoValue
public abstract class ProtoTypeMask {
    private static final Splitter PATH_SPLITTER = Splitter.on('.');
    static final String WILDCARD_FIELD = "*";
    static final String HIDDEN_FIELD = "!";
    private static final FieldMask HIDDEN_FIELD_MASK = FieldMask.newBuilder().addPaths("!").build();
    private static final FieldPath HIDDEN_FIELD_PATH = FieldPath.of("!");
    private static final FieldMask WILDCARD_FIELD_MASK = FieldMask.newBuilder().addPaths("*").build();
    private static final FieldPath WILDCARD_FIELD_PATH = FieldPath.of("*");

    abstract String getTypeName();

    abstract ImmutableSet<FieldPath> getFieldPathsExposed();

    abstract boolean fieldsAreVariableDeclarations();

    boolean areAllFieldPathsExposed() {
        return this.getFieldPathsExposed().stream().allMatch(fp -> fp.equals(WILDCARD_FIELD_PATH));
    }

    boolean areAllFieldPathsHidden() {
        return this.getFieldPathsExposed().stream().allMatch(fp -> fp.equals(HIDDEN_FIELD_PATH));
    }

    public ProtoTypeMask withFieldsAsVariableDeclarations() {
        return new AutoValue_ProtoTypeMask(this.getTypeName(), this.getFieldPathsExposed(), true);
    }

    public static ProtoTypeMask of(String typeName, FieldMask fieldMask) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(typeName));
        if (fieldMask == null || fieldMask.getPathsCount() == 0) {
            fieldMask = WILDCARD_FIELD_MASK;
        }
        ImmutableSet.Builder fieldPaths = ImmutableSet.builder();
        fieldMask.getPathsList().forEach(path -> fieldPaths.add(FieldPath.of(path)));
        return new AutoValue_ProtoTypeMask(typeName, (ImmutableSet<FieldPath>)fieldPaths.build(), false);
    }

    public static ProtoTypeMask ofAllFields(String fullyQualifiedTypeName) {
        return ProtoTypeMask.of(fullyQualifiedTypeName, WILDCARD_FIELD_MASK);
    }

    public static ProtoTypeMask ofAllFieldsHidden(String fullyQualifiedTypeName) {
        return ProtoTypeMask.of(fullyQualifiedTypeName, HIDDEN_FIELD_MASK);
    }

    @Immutable
    @AutoValue
    static abstract class FieldPath {
        FieldPath() {
        }

        abstract ImmutableList<String> getFieldSelection();

        static FieldPath of(String path) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(path), "path must be non-null and not empty");
            return new AutoValue_ProtoTypeMask_FieldPath(ImmutableList.copyOf(PATH_SPLITTER.split(path)));
        }
    }
}

