/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import dev.cel.common.internal.ProtoTimeUtils;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

@Immutable
public final class CelProtoJsonAdapter {
    private static final long JSON_MAX_INT_VALUE = 0x1FFFFFFFFFFFFFL;
    private static final long JSON_MIN_INT_VALUE = -9007199254740991L;
    private static final UnsignedLong JSON_MAX_UINT_VALUE = UnsignedLong.fromLongBits(0x1FFFFFFFFFFFFFL);

    public static <K extends String, V> Struct adaptToJsonStructValue(Map<K, V> map) {
        Struct.Builder struct = Struct.newBuilder();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            String key = (String)entry.getKey();
            V keyValue = entry.getValue();
            struct.putFields(key, CelProtoJsonAdapter.adaptValueToJsonValue(keyValue));
        }
        return struct.build();
    }

    public static Value adaptValueToJsonValue(Object value) {
        Value.Builder json = Value.newBuilder();
        if (value == null || value instanceof NullValue) {
            return json.setNullValue(NullValue.NULL_VALUE).build();
        }
        if (value instanceof Boolean) {
            return json.setBoolValue((Boolean)value).build();
        }
        if (value instanceof Integer || value instanceof Long) {
            long longValue = ((Number)value).longValue();
            if (longValue < -9007199254740991L || longValue > 0x1FFFFFFFFFFFFFL) {
                return json.setStringValue(Long.toString(longValue)).build();
            }
            return json.setNumberValue(longValue).build();
        }
        if (value instanceof UnsignedLong) {
            if (((UnsignedLong)value).compareTo(JSON_MAX_UINT_VALUE) > 0) {
                return json.setStringValue(((UnsignedLong)value).toString()).build();
            }
            return json.setNumberValue(((UnsignedLong)value).longValue()).build();
        }
        if (value instanceof Float || value instanceof Double) {
            return json.setNumberValue(((Number)value).doubleValue()).build();
        }
        if (value instanceof ByteString) {
            return json.setStringValue(Base64.getEncoder().encodeToString(((ByteString)value).toByteArray())).build();
        }
        if (value instanceof String) {
            return json.setStringValue((String)value).build();
        }
        if (value instanceof Map) {
            Struct struct = CelProtoJsonAdapter.adaptToJsonStructValue((Map)value);
            return json.setStructValue(struct).build();
        }
        if (value instanceof Iterable) {
            ListValue listValue = CelProtoJsonAdapter.adaptToJsonListValue((Iterable)value);
            return json.setListValue(listValue).build();
        }
        if (value instanceof Timestamp) {
            String ts = ProtoTimeUtils.toString((Timestamp)value);
            return json.setStringValue(ts).build();
        }
        if (value instanceof Duration) {
            String duration = ProtoTimeUtils.toString((Duration)value);
            return json.setStringValue(duration).build();
        }
        if (value instanceof FieldMask) {
            String fieldMaskStr = CelProtoJsonAdapter.toJsonString((FieldMask)value);
            return json.setStringValue(fieldMaskStr).build();
        }
        if (value instanceof Empty) {
            return json.setStructValue(Struct.getDefaultInstance()).build();
        }
        throw new IllegalArgumentException(String.format("Value %s cannot be adapted to a JSON Value.", value));
    }

    private static String toJsonString(FieldMask fieldMask) {
        ArrayList<String> paths = new ArrayList<String>(fieldMask.getPathsCount());
        for (String path : fieldMask.getPathsList()) {
            if (path.isEmpty()) continue;
            paths.add(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, path));
        }
        return Joiner.on(",").join(paths);
    }

    public static <T> ListValue adaptToJsonListValue(Iterable<T> value) {
        ListValue.Builder jsonList = ListValue.newBuilder();
        for (T elem : value) {
            jsonList.addValues(CelProtoJsonAdapter.adaptValueToJsonValue(elem));
        }
        return jsonList.build();
    }

    private CelProtoJsonAdapter() {
    }
}

