/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.api.expr.v1alpha1.CheckedExpr;
import com.google.api.expr.v1alpha1.Expr;
import com.google.api.expr.v1alpha1.ParsedExpr;
import com.google.api.expr.v1alpha1.Reference;
import com.google.api.expr.v1alpha1.SourceInfo;
import com.google.api.expr.v1alpha1.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelSource;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelExprV1Alpha1Converter;
import dev.cel.common.ast.CelReference;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelV1AlphaTypes;
import java.util.Map;

public final class CelProtoV1Alpha1AbstractSyntaxTree {
    private final CheckedExpr checkedExpr;
    private final CelAbstractSyntaxTree ast;

    private CelProtoV1Alpha1AbstractSyntaxTree(CheckedExpr checkedExpr) {
        this.checkedExpr = checkedExpr;
        this.ast = CelAbstractSyntaxTree.newCheckedAst(CelExprV1Alpha1Converter.fromExpr(checkedExpr.getExpr()), CelSource.newBuilder().addAllLineOffsets(checkedExpr.getSourceInfo().getLineOffsetsList()).addPositionsMap(checkedExpr.getSourceInfo().getPositionsMap()).addAllMacroCalls(CelExprV1Alpha1Converter.exprMacroCallsToCelExprMacroCalls(checkedExpr.getSourceInfo().getMacroCallsMap())).setDescription(checkedExpr.getSourceInfo().getLocation()).build(), (Map<Long, CelReference>)checkedExpr.getReferenceMapMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelExprV1Alpha1Converter.exprReferenceToCelReference((Reference)v.getValue()))), (Map<Long, CelType>)checkedExpr.getTypeMapMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelV1AlphaTypes.typeToCelType((Type)v.getValue()))));
    }

    private CelProtoV1Alpha1AbstractSyntaxTree(CelAbstractSyntaxTree ast) {
        this.ast = ast;
        CheckedExpr.Builder checkedExprBuilder = CheckedExpr.newBuilder().setSourceInfo(SourceInfo.newBuilder().setLocation(ast.getSource().getDescription()).addAllLineOffsets(ast.getSource().getLineOffsets()).putAllMacroCalls((Map)ast.getSource().getMacroCalls().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelExprV1Alpha1Converter.fromCelExpr((CelExpr)v.getValue())))).putAllPositions(ast.getSource().getPositionsMap())).setExpr(CelExprV1Alpha1Converter.fromCelExpr(ast.getExpr()));
        if (ast.isChecked()) {
            checkedExprBuilder.putAllReferenceMap((Map)ast.getReferenceMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelExprV1Alpha1Converter.celReferenceToExprReference((CelReference)v.getValue()))));
            checkedExprBuilder.putAllTypeMap((Map)ast.getTypeMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelV1AlphaTypes.celTypeToType((CelType)v.getValue()))));
        }
        this.checkedExpr = checkedExprBuilder.build();
    }

    public static CelProtoV1Alpha1AbstractSyntaxTree fromCheckedExpr(CheckedExpr checkedExpr) {
        return new CelProtoV1Alpha1AbstractSyntaxTree(checkedExpr);
    }

    public static CelProtoV1Alpha1AbstractSyntaxTree fromParsedExpr(ParsedExpr parsedExpr) {
        return new CelProtoV1Alpha1AbstractSyntaxTree(CheckedExpr.newBuilder().setExpr(parsedExpr.getExpr()).setSourceInfo(parsedExpr.getSourceInfo()).build());
    }

    public static CelProtoV1Alpha1AbstractSyntaxTree fromCelAst(CelAbstractSyntaxTree ast) {
        return new CelProtoV1Alpha1AbstractSyntaxTree(ast);
    }

    public boolean isChecked() {
        return this.ast.isChecked();
    }

    @CheckReturnValue
    public CelAbstractSyntaxTree getAst() {
        return this.ast;
    }

    @CheckReturnValue
    public Expr getExpr() {
        return this.checkedExpr.getExpr();
    }

    @CheckReturnValue
    public CheckedExpr toCheckedExpr() {
        Preconditions.checkState(this.isChecked(), "CelAbstractSyntaxTree must be checked before it can be converted to CheckedExpr");
        return this.checkedExpr;
    }

    @CheckReturnValue
    public SourceInfo getSourceInfo() {
        return this.checkedExpr.getSourceInfo();
    }

    @CheckReturnValue
    public ParsedExpr toParsedExpr() {
        return ParsedExpr.newBuilder().setExpr(this.getExpr()).setSourceInfo(this.getSourceInfo()).build();
    }

    @CheckReturnValue
    public Type getProtoResultType() {
        return CelV1AlphaTypes.celTypeToType(this.ast.getResultType());
    }
}

