/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import dev.cel.common.CelException;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSource;
import java.util.List;

public final class CelValidationException
extends CelException {
    private static final int MAX_ERRORS_TO_REPORT = 100;
    private final CelSource source;
    private final ImmutableList<CelIssue> errors;

    @VisibleForTesting
    public CelValidationException(CelSource source2, List<CelIssue> errors) {
        super(CelValidationException.safeJoinErrorMessage(source2, errors));
        this.source = source2;
        this.errors = ImmutableList.copyOf(errors);
    }

    CelValidationException(CelSource source2, Iterable<CelIssue> errors, String message, Throwable cause) {
        super(message, cause);
        this.source = source2;
        this.errors = ImmutableList.copyOf(errors);
    }

    private static String safeJoinErrorMessage(CelSource source2, List<CelIssue> errors) {
        if (errors.size() <= 100) {
            return CelIssue.toDisplayString(errors, source2);
        }
        List<CelIssue> truncatedErrors = errors.subList(0, 100);
        return CelIssue.toDisplayString(truncatedErrors, source2) + String.format("%n...and %d more errors (truncated)", errors.size() - 100);
    }

    public CelSource getSource() {
        return this.source;
    }

    public ImmutableList<CelIssue> getErrors() {
        return this.errors;
    }
}

