/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.common.base.Preconditions;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelMutableExprConverter;
import dev.cel.common.ast.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public final class CelMutableExpr
implements Expression {
    private long id;
    private CelExpr.ExprKind.Kind exprKind;
    private Object exprValue;

    @Override
    public long id() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public CelExpr.ExprKind.Kind getKind() {
        return this.exprKind;
    }

    public CelExpr.CelNotSet notSet() {
        this.checkExprKind(CelExpr.ExprKind.Kind.NOT_SET);
        return (CelExpr.CelNotSet)this.exprValue;
    }

    @Override
    public CelConstant constant() {
        this.checkExprKind(CelExpr.ExprKind.Kind.CONSTANT);
        return (CelConstant)this.exprValue;
    }

    @Override
    public CelMutableIdent ident() {
        this.checkExprKind(CelExpr.ExprKind.Kind.IDENT);
        return (CelMutableIdent)this.exprValue;
    }

    public CelMutableSelect select() {
        this.checkExprKind(CelExpr.ExprKind.Kind.SELECT);
        return (CelMutableSelect)this.exprValue;
    }

    public CelMutableCall call() {
        this.checkExprKind(CelExpr.ExprKind.Kind.CALL);
        return (CelMutableCall)this.exprValue;
    }

    public CelMutableList list() {
        this.checkExprKind(CelExpr.ExprKind.Kind.LIST);
        return (CelMutableList)this.exprValue;
    }

    public CelMutableStruct struct() {
        this.checkExprKind(CelExpr.ExprKind.Kind.STRUCT);
        return (CelMutableStruct)this.exprValue;
    }

    public CelMutableMap map() {
        this.checkExprKind(CelExpr.ExprKind.Kind.MAP);
        return (CelMutableMap)this.exprValue;
    }

    public CelMutableComprehension comprehension() {
        this.checkExprKind(CelExpr.ExprKind.Kind.COMPREHENSION);
        return (CelMutableComprehension)this.exprValue;
    }

    public void setConstant(CelConstant constant) {
        this.exprKind = CelExpr.ExprKind.Kind.CONSTANT;
        this.exprValue = Preconditions.checkNotNull(constant);
    }

    public void setIdent(CelMutableIdent ident) {
        this.exprKind = CelExpr.ExprKind.Kind.IDENT;
        this.exprValue = Preconditions.checkNotNull(ident);
    }

    public void setSelect(CelMutableSelect select) {
        this.exprKind = CelExpr.ExprKind.Kind.SELECT;
        this.exprValue = Preconditions.checkNotNull(select);
    }

    public void setCall(CelMutableCall call) {
        this.exprKind = CelExpr.ExprKind.Kind.CALL;
        this.exprValue = Preconditions.checkNotNull(call);
    }

    public void setList(CelMutableList list) {
        this.exprKind = CelExpr.ExprKind.Kind.LIST;
        this.exprValue = Preconditions.checkNotNull(list);
    }

    public void setStruct(CelMutableStruct struct) {
        this.exprKind = CelExpr.ExprKind.Kind.STRUCT;
        this.exprValue = Preconditions.checkNotNull(struct);
    }

    public void setMap(CelMutableMap map) {
        this.exprKind = CelExpr.ExprKind.Kind.MAP;
        this.exprValue = Preconditions.checkNotNull(map);
    }

    public void setComprehension(CelMutableComprehension comprehension) {
        this.exprKind = CelExpr.ExprKind.Kind.COMPREHENSION;
        this.exprValue = Preconditions.checkNotNull(comprehension);
    }

    public static CelMutableExpr ofNotSet() {
        return CelMutableExpr.ofNotSet(0L);
    }

    public static CelMutableExpr ofNotSet(long id) {
        return new CelMutableExpr(id);
    }

    public static CelMutableExpr ofConstant(CelConstant constant) {
        return CelMutableExpr.ofConstant(0L, constant);
    }

    public static CelMutableExpr ofConstant(long id, CelConstant constant) {
        return new CelMutableExpr(id, constant);
    }

    public static CelMutableExpr ofIdent(String name) {
        return CelMutableExpr.ofIdent(0L, name);
    }

    public static CelMutableExpr ofIdent(long id, String name) {
        return new CelMutableExpr(id, CelMutableIdent.create(name));
    }

    public static CelMutableExpr ofSelect(CelMutableSelect mutableSelect) {
        return CelMutableExpr.ofSelect(0L, mutableSelect);
    }

    public static CelMutableExpr ofSelect(long id, CelMutableSelect mutableSelect) {
        return new CelMutableExpr(id, mutableSelect);
    }

    public static CelMutableExpr ofCall(CelMutableCall mutableCall) {
        return CelMutableExpr.ofCall(0L, mutableCall);
    }

    public static CelMutableExpr ofCall(long id, CelMutableCall mutableCall) {
        return new CelMutableExpr(id, mutableCall);
    }

    public static CelMutableExpr ofList(CelMutableList mutableList) {
        return CelMutableExpr.ofList(0L, mutableList);
    }

    public static CelMutableExpr ofList(long id, CelMutableList mutableList) {
        return new CelMutableExpr(id, mutableList);
    }

    public static CelMutableExpr ofStruct(CelMutableStruct mutableStruct) {
        return CelMutableExpr.ofStruct(0L, mutableStruct);
    }

    public static CelMutableExpr ofStruct(long id, CelMutableStruct mutableStruct) {
        return new CelMutableExpr(id, mutableStruct);
    }

    public static CelMutableExpr ofMap(CelMutableMap mutableMap) {
        return CelMutableExpr.ofMap(0L, mutableMap);
    }

    public static CelMutableExpr ofMap(long id, CelMutableMap mutableMap) {
        return new CelMutableExpr(id, mutableMap);
    }

    public static CelMutableExpr ofComprehension(long id, CelMutableComprehension mutableComprehension) {
        return new CelMutableExpr(id, mutableComprehension);
    }

    public static CelMutableExpr newInstance(CelMutableExpr other) {
        return new CelMutableExpr(other);
    }

    private CelMutableExpr(long id, CelConstant mutableConstant) {
        this.id = id;
        this.setConstant(mutableConstant);
    }

    private CelMutableExpr(long id, CelMutableIdent mutableIdent) {
        this.id = id;
        this.setIdent(mutableIdent);
    }

    private CelMutableExpr(long id, CelMutableSelect mutableSelect) {
        this.id = id;
        this.setSelect(mutableSelect);
    }

    private CelMutableExpr(long id, CelMutableCall mutableCall) {
        this.id = id;
        this.setCall(mutableCall);
    }

    private CelMutableExpr(long id, CelMutableList mutableList) {
        this.id = id;
        this.setList(mutableList);
    }

    private CelMutableExpr(long id, CelMutableStruct mutableStruct) {
        this.id = id;
        this.setStruct(mutableStruct);
    }

    private CelMutableExpr(long id, CelMutableMap mutableMap) {
        this.id = id;
        this.setMap(mutableMap);
    }

    private CelMutableExpr(long id, CelMutableComprehension mutableComprehension) {
        this.id = id;
        this.setComprehension(mutableComprehension);
    }

    private CelMutableExpr(long id) {
        this();
        this.id = id;
    }

    private CelMutableExpr() {
        this.exprValue = CelExpr.newBuilder().build().exprKind().notSet();
        this.exprKind = CelExpr.ExprKind.Kind.NOT_SET;
    }

    private CelMutableExpr(CelMutableExpr other) {
        Preconditions.checkNotNull(other);
        this.id = other.id;
        this.exprKind = other.exprKind;
        switch (other.getKind()) {
            case NOT_SET: {
                this.exprValue = CelExpr.newBuilder().build().exprKind().notSet();
                break;
            }
            case CONSTANT: {
                this.exprValue = other.exprValue;
                break;
            }
            case IDENT: {
                this.exprValue = other.ident().deepCopy();
                break;
            }
            case SELECT: {
                this.exprValue = other.select().deepCopy();
                break;
            }
            case CALL: {
                this.exprValue = other.call().deepCopy();
                break;
            }
            case LIST: {
                this.exprValue = other.list().deepCopy();
                break;
            }
            case STRUCT: {
                this.exprValue = other.struct().deepCopy();
                break;
            }
            case MAP: {
                this.exprValue = other.map().deepCopy();
                break;
            }
            case COMPREHENSION: {
                this.exprValue = other.comprehension().deepCopy();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected expr kind: " + (Object)((Object)this.exprKind));
            }
        }
    }

    private Object exprValue() {
        switch (this.exprKind) {
            case NOT_SET: {
                return this.notSet();
            }
            case CONSTANT: {
                return this.constant();
            }
            case IDENT: {
                return this.ident();
            }
            case SELECT: {
                return this.select();
            }
            case CALL: {
                return this.call();
            }
            case LIST: {
                return this.list();
            }
            case STRUCT: {
                return this.struct();
            }
            case MAP: {
                return this.map();
            }
            case COMPREHENSION: {
                return this.comprehension();
            }
        }
        throw new IllegalStateException("Unexpected expr kind: " + (Object)((Object)this.exprKind));
    }

    private static List<CelMutableExpr> deepCopyList(List<CelMutableExpr> elements) {
        ArrayList<CelMutableExpr> copiedArgs = new ArrayList<CelMutableExpr>();
        for (CelMutableExpr arg : elements) {
            copiedArgs.add(CelMutableExpr.newInstance(arg));
        }
        return copiedArgs;
    }

    private void checkExprKind(CelExpr.ExprKind.Kind exprKind) {
        Preconditions.checkArgument(this.exprKind.equals((Object)exprKind), "Invalid ExprKind: %s", (Object)exprKind);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CelMutableExpr) {
            CelMutableExpr that = (CelMutableExpr)obj;
            if (this.id != that.id() || !this.exprKind.equals((Object)that.getKind())) {
                return false;
            }
            return this.exprValue().equals(that.exprValue());
        }
        return false;
    }

    public String toString() {
        return CelMutableExprConverter.fromMutableExpr(this).toString();
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= (int)(this.id >>> 32 ^ this.id);
        h2 *= 1000003;
        return h2 ^= this.exprValue().hashCode();
    }

    public static final class CelMutableIdent
    implements Expression.Ident {
        private String name = "";

        @Override
        public String name() {
            return this.name;
        }

        public void setName(String name) {
            this.name = Preconditions.checkNotNull(name);
        }

        public static CelMutableIdent create(String name) {
            return new CelMutableIdent(name);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CelMutableIdent) {
                CelMutableIdent that = (CelMutableIdent)obj;
                return this.name.equals(that.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        private CelMutableIdent deepCopy() {
            return new CelMutableIdent(this.name);
        }

        private CelMutableIdent(String name) {
            this.name = Preconditions.checkNotNull(name);
        }
    }

    public static final class CelMutableSelect
    implements Expression.Select<CelMutableExpr> {
        private CelMutableExpr operand;
        private String field = "";
        private boolean testOnly;

        @Override
        public CelMutableExpr operand() {
            return this.operand;
        }

        public void setOperand(CelMutableExpr operand) {
            this.operand = Preconditions.checkNotNull(operand);
        }

        @Override
        public String field() {
            return this.field;
        }

        public void setField(String field) {
            this.field = Preconditions.checkNotNull(field);
        }

        @Override
        public boolean testOnly() {
            return this.testOnly;
        }

        public void setTestOnly(boolean testOnly) {
            this.testOnly = testOnly;
        }

        private CelMutableSelect deepCopy() {
            return CelMutableSelect.create(CelMutableExpr.newInstance(this.operand()), this.field, this.testOnly);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CelMutableSelect) {
                CelMutableSelect that = (CelMutableSelect)obj;
                return this.operand.equals(that.operand()) && this.field.equals(that.field()) && this.testOnly == that.testOnly();
            }
            return false;
        }

        public int hashCode() {
            int h2 = 1;
            h2 *= 1000003;
            h2 ^= this.operand.hashCode();
            h2 *= 1000003;
            h2 ^= this.field.hashCode();
            h2 *= 1000003;
            return h2 ^= this.testOnly ? 1231 : 1237;
        }

        public static CelMutableSelect create(CelMutableExpr operand, String field) {
            return new CelMutableSelect(operand, field, false);
        }

        public static CelMutableSelect create(CelMutableExpr operand, String field, boolean testOnly) {
            return new CelMutableSelect(operand, field, testOnly);
        }

        private CelMutableSelect(CelMutableExpr operand, String field, boolean testOnly) {
            this.operand = Preconditions.checkNotNull(operand);
            this.field = Preconditions.checkNotNull(field);
            this.testOnly = testOnly;
        }
    }

    public static final class CelMutableCall
    implements Expression.Call<CelMutableExpr> {
        private Optional<CelMutableExpr> target = Optional.empty();
        private String function;
        private List<CelMutableExpr> args;

        @Override
        public Optional<CelMutableExpr> target() {
            return this.target;
        }

        public void setTarget(CelMutableExpr target) {
            this.target = Optional.of(target);
        }

        @Override
        public String function() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public List<CelMutableExpr> args() {
            return this.args;
        }

        public void clearArgs() {
            this.args.clear();
        }

        public void addArgs(CelMutableExpr ... exprs) {
            this.addArgs(Arrays.asList(Preconditions.checkNotNull(exprs)));
        }

        public void addArgs(Iterable<CelMutableExpr> exprs) {
            exprs.forEach(e -> this.args.add(Preconditions.checkNotNull(e)));
        }

        public void setArgs(Collection<CelMutableExpr> exprs) {
            this.args = new ArrayList<CelMutableExpr>(Preconditions.checkNotNull(exprs));
        }

        public void setArg(int index, CelMutableExpr arg) {
            Preconditions.checkArgument(index >= 0 && index < this.args.size());
            this.args.set(index, Preconditions.checkNotNull(arg));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CelMutableCall) {
                CelMutableCall that = (CelMutableCall)obj;
                return this.target.equals(that.target()) && this.function.equals(that.function()) && this.args.equals(that.args());
            }
            return false;
        }

        public int hashCode() {
            int h2 = 1;
            h2 *= 1000003;
            h2 ^= this.target.hashCode();
            h2 *= 1000003;
            h2 ^= this.function.hashCode();
            h2 *= 1000003;
            return h2 ^= this.args.hashCode();
        }

        private CelMutableCall deepCopy() {
            List copiedArgs = CelMutableExpr.deepCopyList(this.args);
            return this.target().isPresent() ? CelMutableCall.create(CelMutableExpr.newInstance(this.target.get()), this.function, copiedArgs) : CelMutableCall.create(this.function, copiedArgs);
        }

        public static CelMutableCall create(String function, CelMutableExpr ... args) {
            return CelMutableCall.create(function, Arrays.asList(Preconditions.checkNotNull(args)));
        }

        public static CelMutableCall create(String function, List<CelMutableExpr> args) {
            return new CelMutableCall(function, args);
        }

        public static CelMutableCall create(CelMutableExpr target, String function, CelMutableExpr ... args) {
            return CelMutableCall.create(target, function, Arrays.asList(Preconditions.checkNotNull(args)));
        }

        public static CelMutableCall create(CelMutableExpr target, String function, List<CelMutableExpr> args) {
            return new CelMutableCall(target, function, args);
        }

        private CelMutableCall(String function, List<CelMutableExpr> args) {
            this.function = Preconditions.checkNotNull(function);
            this.args = new ArrayList<CelMutableExpr>((Collection)Preconditions.checkNotNull(args));
        }

        private CelMutableCall(CelMutableExpr target, String function, List<CelMutableExpr> args) {
            this(function, args);
            this.target = Optional.of(target);
        }
    }

    public static final class CelMutableList
    implements Expression.List<CelMutableExpr> {
        private final List<CelMutableExpr> elements;
        private final List<Integer> optionalIndices;

        @Override
        public List<CelMutableExpr> elements() {
            return this.elements;
        }

        public void setElement(int index, CelMutableExpr element) {
            Preconditions.checkArgument(index >= 0 && index < this.elements().size());
            this.elements.set(index, Preconditions.checkNotNull(element));
        }

        @Override
        public List<Integer> optionalIndices() {
            return this.optionalIndices;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CelMutableList) {
                CelMutableList that = (CelMutableList)obj;
                return this.elements.equals(that.elements()) && this.optionalIndices.equals(that.optionalIndices());
            }
            return false;
        }

        public int hashCode() {
            int h2 = 1;
            h2 *= 1000003;
            h2 ^= this.elements.hashCode();
            h2 *= 1000003;
            return h2 ^= this.optionalIndices.hashCode();
        }

        private CelMutableList deepCopy() {
            return CelMutableList.create(CelMutableExpr.deepCopyList(this.elements), this.optionalIndices);
        }

        public static CelMutableList create(CelMutableExpr ... elements) {
            return CelMutableList.create(Arrays.asList(Preconditions.checkNotNull(elements)));
        }

        public static CelMutableList create(List<CelMutableExpr> elements) {
            return CelMutableList.create(elements, new ArrayList<Integer>());
        }

        public static CelMutableList create(List<CelMutableExpr> mutableExprList, List<Integer> optionalIndices) {
            return new CelMutableList(mutableExprList, optionalIndices);
        }

        private CelMutableList(List<CelMutableExpr> mutableExprList, List<Integer> optionalIndices) {
            this.elements = new ArrayList<CelMutableExpr>((Collection)Preconditions.checkNotNull(mutableExprList));
            this.optionalIndices = new ArrayList<Integer>((Collection)Preconditions.checkNotNull(optionalIndices));
        }
    }

    public static final class CelMutableStruct
    implements Expression.Struct<Entry> {
        private String messageName = "";
        private List<Entry> entries;

        @Override
        public String messageName() {
            return this.messageName;
        }

        public void setMessageName(String messageName) {
            this.messageName = Preconditions.checkNotNull(messageName);
        }

        @Override
        public List<Entry> entries() {
            return this.entries;
        }

        public void setEntries(List<Entry> entries) {
            this.entries = Preconditions.checkNotNull(entries);
        }

        public void setEntry(int index, Entry entry) {
            Preconditions.checkArgument(index >= 0 && index < this.entries().size());
            this.entries.set(index, Preconditions.checkNotNull(entry));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CelMutableStruct) {
                CelMutableStruct that = (CelMutableStruct)obj;
                return this.messageName.equals(that.messageName()) && this.entries.equals(that.entries());
            }
            return false;
        }

        public int hashCode() {
            int h2 = 1;
            h2 *= 1000003;
            h2 ^= this.messageName.hashCode();
            h2 *= 1000003;
            return h2 ^= this.entries.hashCode();
        }

        private CelMutableStruct deepCopy() {
            ArrayList<Entry> copiedEntries = new ArrayList<Entry>();
            for (Entry entry : this.entries) {
                copiedEntries.add(entry.deepCopy());
            }
            return CelMutableStruct.create(this.messageName, copiedEntries);
        }

        public static CelMutableStruct create(String messageName, List<Entry> entries) {
            return new CelMutableStruct(messageName, entries);
        }

        private CelMutableStruct(String messageName, List<Entry> entries) {
            this.messageName = Preconditions.checkNotNull(messageName);
            this.entries = new ArrayList<Entry>((Collection)Preconditions.checkNotNull(entries));
        }

        public static final class Entry
        implements Expression.Struct.Entry<CelMutableExpr> {
            private long id;
            private String fieldKey = "";
            private CelMutableExpr value;
            private boolean optionalEntry;

            @Override
            public long id() {
                return this.id;
            }

            public void setId(long id) {
                this.id = id;
            }

            @Override
            public String fieldKey() {
                return this.fieldKey;
            }

            public void setFieldKey(String fieldKey) {
                this.fieldKey = Preconditions.checkNotNull(fieldKey);
            }

            @Override
            public CelMutableExpr value() {
                return this.value;
            }

            public void setValue(CelMutableExpr value) {
                this.value = Preconditions.checkNotNull(value);
            }

            @Override
            public boolean optionalEntry() {
                return this.optionalEntry;
            }

            public void setOptionalEntry(boolean optionalEntry) {
                this.optionalEntry = optionalEntry;
            }

            private Entry deepCopy() {
                return Entry.create(this.id, this.fieldKey, CelMutableExpr.newInstance(this.value), this.optionalEntry);
            }

            public static Entry create(long id, String fieldKey, CelMutableExpr value) {
                return Entry.create(id, fieldKey, value, false);
            }

            public static Entry create(long id, String fieldKey, CelMutableExpr value, boolean optionalEntry) {
                return new Entry(id, fieldKey, value, optionalEntry);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Entry) {
                    Entry that = (Entry)obj;
                    return this.id == that.id() && this.fieldKey.equals(that.fieldKey()) && this.value.equals(that.value()) && this.optionalEntry == that.optionalEntry();
                }
                return false;
            }

            public int hashCode() {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= (int)(this.id >>> 32 ^ this.id);
                h2 *= 1000003;
                h2 ^= this.fieldKey.hashCode();
                h2 *= 1000003;
                h2 ^= this.value.hashCode();
                h2 *= 1000003;
                return h2 ^= this.optionalEntry ? 1231 : 1237;
            }

            private Entry(long id, String fieldKey, CelMutableExpr value, boolean optionalEntry) {
                this.id = id;
                this.fieldKey = Preconditions.checkNotNull(fieldKey);
                this.value = Preconditions.checkNotNull(value);
                this.optionalEntry = optionalEntry;
            }
        }
    }

    public static final class CelMutableMap
    implements Expression.Map<Entry> {
        private List<Entry> entries;

        @Override
        public List<Entry> entries() {
            return this.entries;
        }

        public void setEntries(List<Entry> entries) {
            this.entries = Preconditions.checkNotNull(entries);
        }

        public void setEntry(int index, Entry entry) {
            Preconditions.checkArgument(index >= 0 && index < this.entries().size());
            this.entries.set(index, Preconditions.checkNotNull(entry));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CelMutableMap) {
                CelMutableMap that = (CelMutableMap)obj;
                return this.entries.equals(that.entries());
            }
            return false;
        }

        public int hashCode() {
            int h2 = 1;
            h2 *= 1000003;
            return h2 ^= this.entries.hashCode();
        }

        private CelMutableMap deepCopy() {
            ArrayList<Entry> copiedEntries = new ArrayList<Entry>();
            for (Entry entry : this.entries) {
                copiedEntries.add(entry.deepCopy());
            }
            return CelMutableMap.create(copiedEntries);
        }

        public static CelMutableMap create(List<Entry> entries) {
            return new CelMutableMap(new ArrayList<Entry>(entries));
        }

        private CelMutableMap(List<Entry> entries) {
            this.entries = Preconditions.checkNotNull(entries);
        }

        public static final class Entry
        implements Expression.Map.Entry<CelMutableExpr> {
            private long id;
            private CelMutableExpr key;
            private CelMutableExpr value;
            private boolean optionalEntry;

            @Override
            public long id() {
                return this.id;
            }

            public void setId(long id) {
                this.id = id;
            }

            @Override
            public CelMutableExpr key() {
                return this.key;
            }

            public void setKey(CelMutableExpr key) {
                this.key = Preconditions.checkNotNull(key);
            }

            @Override
            public CelMutableExpr value() {
                return this.value;
            }

            public void setValue(CelMutableExpr value) {
                this.value = Preconditions.checkNotNull(value);
            }

            @Override
            public boolean optionalEntry() {
                return this.optionalEntry;
            }

            public void setOptionalEntry(boolean optionalEntry) {
                this.optionalEntry = optionalEntry;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Entry) {
                    Entry that = (Entry)obj;
                    return this.id == that.id() && this.key.equals(that.key()) && this.value.equals(that.value()) && this.optionalEntry == that.optionalEntry();
                }
                return false;
            }

            public int hashCode() {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= (int)(this.id >>> 32 ^ this.id);
                h2 *= 1000003;
                h2 ^= this.key.hashCode();
                h2 *= 1000003;
                h2 ^= this.value.hashCode();
                h2 *= 1000003;
                return h2 ^= this.optionalEntry ? 1231 : 1237;
            }

            private Entry deepCopy() {
                return Entry.create(this.id, CelMutableExpr.newInstance(this.key), CelMutableExpr.newInstance(this.value), this.optionalEntry);
            }

            public static Entry create(CelMutableExpr key, CelMutableExpr value) {
                return Entry.create(0L, key, value, false);
            }

            public static Entry create(long id, CelMutableExpr key, CelMutableExpr value) {
                return Entry.create(id, key, value, false);
            }

            public static Entry create(long id, CelMutableExpr key, CelMutableExpr value, boolean optionalEntry) {
                return new Entry(id, key, value, optionalEntry);
            }

            private Entry(long id, CelMutableExpr key, CelMutableExpr value, boolean optionalEntry) {
                this.id = id;
                this.key = Preconditions.checkNotNull(key);
                this.value = Preconditions.checkNotNull(value);
                this.optionalEntry = optionalEntry;
            }
        }
    }

    public static final class CelMutableComprehension
    implements Expression.Comprehension<CelMutableExpr> {
        private String iterVar;
        private CelMutableExpr iterRange;
        private String accuVar;
        private CelMutableExpr accuInit;
        private CelMutableExpr loopCondition;
        private CelMutableExpr loopStep;
        private CelMutableExpr result;

        @Override
        public String iterVar() {
            return this.iterVar;
        }

        public void setIterVar(String iterVar) {
            this.iterVar = Preconditions.checkNotNull(iterVar);
        }

        @Override
        public CelMutableExpr iterRange() {
            return this.iterRange;
        }

        public void setIterRange(CelMutableExpr iterRange) {
            this.iterRange = Preconditions.checkNotNull(iterRange);
        }

        @Override
        public String accuVar() {
            return this.accuVar;
        }

        public void setAccuVar(String accuVar) {
            this.accuVar = Preconditions.checkNotNull(accuVar);
        }

        @Override
        public CelMutableExpr accuInit() {
            return this.accuInit;
        }

        public void setAccuInit(CelMutableExpr accuInit) {
            this.accuInit = Preconditions.checkNotNull(accuInit);
        }

        @Override
        public CelMutableExpr loopCondition() {
            return this.loopCondition;
        }

        public void setLoopCondition(CelMutableExpr loopCondition) {
            this.loopCondition = Preconditions.checkNotNull(loopCondition);
        }

        @Override
        public CelMutableExpr loopStep() {
            return this.loopStep;
        }

        public void setLoopStep(CelMutableExpr loopStep) {
            this.loopStep = Preconditions.checkNotNull(loopStep);
        }

        @Override
        public CelMutableExpr result() {
            return this.result;
        }

        public void setResult(CelMutableExpr result) {
            this.result = Preconditions.checkNotNull(result);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CelMutableComprehension) {
                CelMutableComprehension that = (CelMutableComprehension)obj;
                return this.iterVar.equals(that.iterVar()) && this.accuVar.equals(that.accuVar()) && this.iterRange.equals(that.iterRange()) && this.accuInit.equals(that.accuInit()) && this.loopCondition.equals(that.loopCondition()) && this.loopStep.equals(that.loopStep()) && this.result.equals(that.result());
            }
            return false;
        }

        public int hashCode() {
            int h2 = 1;
            h2 *= 1000003;
            h2 ^= this.iterVar.hashCode();
            h2 *= 1000003;
            h2 ^= this.iterRange.hashCode();
            h2 *= 1000003;
            h2 ^= this.accuVar.hashCode();
            h2 *= 1000003;
            h2 ^= this.accuInit.hashCode();
            h2 *= 1000003;
            h2 ^= this.loopCondition.hashCode();
            h2 *= 1000003;
            h2 ^= this.loopStep.hashCode();
            h2 *= 1000003;
            return h2 ^= this.result.hashCode();
        }

        private CelMutableComprehension deepCopy() {
            return CelMutableComprehension.create(this.iterVar, CelMutableExpr.newInstance(this.iterRange), this.accuVar, CelMutableExpr.newInstance(this.accuInit), CelMutableExpr.newInstance(this.loopCondition), CelMutableExpr.newInstance(this.loopStep), CelMutableExpr.newInstance(this.result));
        }

        public static CelMutableComprehension create(String iterVar, CelMutableExpr iterRange, String accuVar, CelMutableExpr accuInit, CelMutableExpr loopCondition, CelMutableExpr loopStep, CelMutableExpr result) {
            return new CelMutableComprehension(iterVar, iterRange, accuVar, accuInit, loopCondition, loopStep, result);
        }

        private CelMutableComprehension(String iterVar, CelMutableExpr iterRange, String accuVar, CelMutableExpr accuInit, CelMutableExpr loopCondition, CelMutableExpr loopStep, CelMutableExpr result) {
            this.iterVar = Preconditions.checkNotNull(iterVar);
            this.iterRange = Preconditions.checkNotNull(iterRange);
            this.accuVar = Preconditions.checkNotNull(accuVar);
            this.accuInit = Preconditions.checkNotNull(accuInit);
            this.loopCondition = Preconditions.checkNotNull(loopCondition);
            this.loopStep = Preconditions.checkNotNull(loopStep);
            this.result = Preconditions.checkNotNull(result);
        }
    }
}

