/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.BidiConverter;
import dev.cel.common.internal.Converter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@CheckReturnValue
@Internal
public final class AdaptingTypes {
    private AdaptingTypes() {
    }

    public static <A, B> List<B> adaptingList(List<A> list, BidiConverter<A, B> bidiConverter) {
        return new AdaptingList<A, B>(list, bidiConverter);
    }

    public static <A, B, C, D> Map<C, D> adaptingMap(Map<A, B> map, BidiConverter<A, C> keyConverter, BidiConverter<B, D> valueConverter) {
        return new AdaptingMap<A, B, C, D>(map, keyConverter, valueConverter);
    }

    private static RuntimeException readonly() {
        throw new UnsupportedOperationException("collection is unmodifiable");
    }

    private static class AdaptingList<A, B>
    extends AdaptingCollection<A, B>
    implements List<B> {
        public AdaptingList(List<A> delegate, BidiConverter<A, B> bidiConverter) {
            super(delegate, bidiConverter);
        }

        @Override
        public boolean addAll(int i, Collection<? extends B> collection) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public B get(int i) {
            return this.converter().convert(((List)this.delegate).get(i));
        }

        @Override
        public B set(int i, B a) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public void add(int i, B a) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public B remove(int i) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public int indexOf(Object o) {
            List list = (List)this.delegate;
            return list.indexOf(this.backwardConverter().convert(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            List list = (List)this.delegate;
            return list.lastIndexOf(this.backwardConverter().convert(o));
        }

        @Override
        public ListIterator<B> listIterator() {
            throw new UnsupportedOperationException("listIterator not supported");
        }

        @Override
        public ListIterator<B> listIterator(int i) {
            throw new UnsupportedOperationException("listIterator not supported");
        }

        @Override
        public List<B> subList(int i, int i1) {
            return new AdaptingList(((List)this.delegate).subList(i, i1), this.bidiConverter);
        }
    }

    private static class AdaptingMap<A, B, C, D>
    implements Map<C, D> {
        private final Map<A, B> delegate;
        private final BidiConverter<A, C> keyBidiConverter;
        private final BidiConverter<B, D> valueBidiConverter;

        public AdaptingMap(Map<A, B> delegate, BidiConverter<A, C> keyBidiConverter, BidiConverter<B, D> valueBidiConverter) {
            this.delegate = delegate;
            this.keyBidiConverter = keyBidiConverter;
            this.valueBidiConverter = valueBidiConverter;
        }

        protected Converter<A, C> keyConverter() {
            return this.keyBidiConverter.forwardConverter();
        }

        protected Converter<C, A> keyBackwardConverter() {
            return this.keyBidiConverter.backwardConverter();
        }

        protected Converter<B, D> valueConverter() {
            return this.valueBidiConverter.forwardConverter();
        }

        protected Converter<D, B> valueBackwardConverter() {
            return this.valueBidiConverter.backwardConverter();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.delegate.containsKey(this.keyBackwardConverter().convert(o));
        }

        @Override
        public boolean containsValue(Object o) {
            return this.delegate.containsValue(this.valueBackwardConverter().convert(o));
        }

        @Override
        public @Nullable D get(Object o) {
            return this.valueConverter().convert(this.delegate.get(this.keyBackwardConverter().convert(o)));
        }

        @Override
        public @Nullable D put(C a, D b) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public @Nullable D remove(Object o) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public void putAll(Map<? extends C, ? extends D> map) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public void clear() {
            throw AdaptingTypes.readonly();
        }

        @Override
        public Set<C> keySet() {
            return new AdaptingSet(this.delegate.keySet(), this.keyBidiConverter);
        }

        @Override
        public Collection<D> values() {
            return new AdaptingCollection<B, D>(this.delegate.values(), this.valueBidiConverter);
        }

        @Override
        public Set<Map.Entry<C, D>> entrySet() {
            Converter<Map.Entry, Map.Entry> entryConverter = entry -> new AdaptingEntry<A, B, C, D>(entry, this.keyConverter(), this.valueConverter());
            Converter<Map.Entry, Map.Entry> entryBackwardConverter = entry -> new AdaptingEntry<C, D, A, B>(entry, this.keyBackwardConverter(), this.valueBackwardConverter());
            return new AdaptingSet(this.delegate.entrySet(), BidiConverter.of(entryConverter, entryBackwardConverter));
        }
    }

    private static class AdaptingEntry<A, B, C, D>
    implements Map.Entry<C, D> {
        private final Map.Entry<A, B> delegate;
        private final Converter<A, C> keyConverter;
        private final Converter<B, D> valueConverter;

        public AdaptingEntry(Map.Entry<A, B> delegate, Converter<A, C> keyConverter, Converter<B, D> valueConverter) {
            this.delegate = delegate;
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        @Override
        public C getKey() {
            return this.keyConverter.convert(this.delegate.getKey());
        }

        @Override
        public D getValue() {
            return this.valueConverter.convert(this.delegate.getValue());
        }

        @Override
        public D setValue(D y) {
            throw AdaptingTypes.readonly();
        }
    }

    private static class AdaptingSet<A, B>
    extends AdaptingCollection<A, B>
    implements Set<B> {
        private AdaptingSet(Set<A> delegate, BidiConverter<A, B> bidiConverter) {
            super(delegate, bidiConverter);
        }
    }

    private static class AdaptingCollection<A, B>
    implements Collection<B> {
        protected final Collection<A> delegate;
        protected final BidiConverter<A, B> bidiConverter;

        public AdaptingCollection(Collection<A> delegate, BidiConverter<A, B> bidiConverter) {
            this.delegate = delegate;
            this.bidiConverter = bidiConverter;
        }

        protected Converter<A, B> converter() {
            return this.bidiConverter.forwardConverter();
        }

        protected Converter<B, A> backwardConverter() {
            return this.bidiConverter.backwardConverter();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(this.backwardConverter().convert(o));
        }

        @Override
        public Iterator<B> iterator() {
            return new AdaptingIterator(this.delegate.iterator(), this.bidiConverter);
        }

        @Override
        public Object[] toArray() {
            return this.delegate.stream().map(baseEl -> this.converter().convert(baseEl)).toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            if (ts.length < this.size()) {
                return this.toArray();
            }
            Object[] base = this.delegate.toArray(new Object[ts.length]);
            Arrays.setAll(ts, i -> this.converter().convert(base[i]));
            return ts;
        }

        @Override
        public boolean add(B a) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public boolean remove(Object o) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object o : collection) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends B> collection) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw AdaptingTypes.readonly();
        }

        @Override
        public void clear() {
            throw AdaptingTypes.readonly();
        }
    }

    private static class AdaptingIterator<A, B>
    implements Iterator<B> {
        private final Iterator<A> delegate;
        private final BidiConverter<A, B> bidiConverter;

        private AdaptingIterator(Iterator<A> delegate, BidiConverter<A, B> bidiConverter) {
            this.delegate = delegate;
            this.bidiConverter = bidiConverter;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public B next() {
            return this.bidiConverter.forwardConverter().convert(this.delegate.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

