/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.MessageLite;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public final class DefaultInstanceMessageLiteFactory {
    private static final DefaultInstanceMessageLiteFactory INSTANCE = new DefaultInstanceMessageLiteFactory();
    private final Map<String, LazyGeneratedMessageDefaultInstance> messageByTypeName = new ConcurrentHashMap<String, LazyGeneratedMessageDefaultInstance>();

    public static DefaultInstanceMessageLiteFactory getInstance() {
        return INSTANCE;
    }

    public Optional<MessageLite> getPrototype(String protoFqn, String protoJavaClassFqn) {
        LazyGeneratedMessageDefaultInstance lazyDefaultInstance = this.messageByTypeName.computeIfAbsent(protoFqn, unused -> new LazyGeneratedMessageDefaultInstance(protoJavaClassFqn));
        MessageLite defaultInstance = lazyDefaultInstance.getDefaultInstance();
        return Optional.ofNullable(defaultInstance);
    }

    @VisibleForTesting
    void resetTypeMap() {
        this.messageByTypeName.clear();
    }

    private DefaultInstanceMessageLiteFactory() {
    }

    private static final class LazyGeneratedMessageDefaultInstance {
        private final String fullClassName;
        private volatile MessageLite defaultInstance = null;
        private volatile boolean loaded = false;

        public LazyGeneratedMessageDefaultInstance(String fullClassName) {
            this.fullClassName = fullClassName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageLite getDefaultInstance() {
            if (!this.loaded) {
                LazyGeneratedMessageDefaultInstance lazyGeneratedMessageDefaultInstance = this;
                synchronized (lazyGeneratedMessageDefaultInstance) {
                    if (!this.loaded) {
                        this.loadDefaultInstance();
                        this.loaded = true;
                    }
                }
            }
            return this.defaultInstance;
        }

        private void loadDefaultInstance() {
            Class<?> clazz;
            try {
                clazz = Class.forName(this.fullClassName);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            Method method = ReflectionUtil.getMethod(clazz, "getDefaultInstance", new Class[0]);
            this.defaultInstance = (MessageLite)ReflectionUtil.invoke(method, null, new Object[0]);
        }
    }
}

