/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.ProtoMessageFactory;
import java.util.Optional;

@Immutable
@CheckReturnValue
@Internal
public final class DynamicProto {
    private final ProtoMessageFactory protoMessageFactory;

    public static DynamicProto create(ProtoMessageFactory protoMessageFactory) {
        return new DynamicProto(protoMessageFactory);
    }

    DynamicProto(ProtoMessageFactory protoMessageFactory) {
        this.protoMessageFactory = Preconditions.checkNotNull(protoMessageFactory);
    }

    public ProtoMessageFactory getProtoMessageFactory() {
        return this.protoMessageFactory;
    }

    public Optional<Message> maybeUnpackAny(Message msg) {
        try {
            Any any = msg instanceof Any ? (Any)msg : Any.parseFrom(msg.toByteString(), (ExtensionRegistryLite)this.protoMessageFactory.getDescriptorPool().getExtensionRegistry());
            return Optional.of(this.unpack(any));
        }
        catch (InvalidProtocolBufferException e) {
            return Optional.empty();
        }
    }

    public Message unpack(Any any) throws InvalidProtocolBufferException {
        String messageTypeName = DynamicProto.getTypeNameFromTypeUrl(any.getTypeUrl()).orElseThrow(() -> new InvalidProtocolBufferException(String.format("malformed type URL: %s", any.getTypeUrl())));
        Message.Builder builder = this.protoMessageFactory.newBuilder(messageTypeName).orElseThrow(() -> new InvalidProtocolBufferException(String.format("no such descriptor for type: %s", messageTypeName)));
        return this.merge(builder, any.getValue());
    }

    public Message maybeAdaptDynamicMessage(DynamicMessage input) {
        Optional<Message.Builder> maybeBuilder = this.protoMessageFactory.newBuilder(input.getDescriptorForType().getFullName());
        if (!maybeBuilder.isPresent() || maybeBuilder.get() instanceof DynamicMessage.Builder) {
            return input;
        }
        return this.merge(maybeBuilder.get(), input.toByteString());
    }

    private Message merge(Message.Builder builder, ByteString inputBytes) {
        try {
            return builder.mergeFrom(inputBytes, (ExtensionRegistryLite)this.protoMessageFactory.getDescriptorPool().getExtensionRegistry()).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new AssertionError("Failed to merge input message into the message builder", e);
        }
    }

    private static Optional<String> getTypeNameFromTypeUrl(String typeUrl) {
        int pos = typeUrl.lastIndexOf(47);
        if (pos != -1) {
            return Optional.of(typeUrl.substring(pos + 1));
        }
        return Optional.empty();
    }
}

