/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.AutoValue_Latin1CodePointArray;
import dev.cel.common.internal.CelCodePointArray;
import java.nio.charset.StandardCharsets;

@Immutable
@Internal
@AutoValue
@AutoValue.CopyAnnotations
public abstract class Latin1CodePointArray
extends CelCodePointArray {
    abstract byte[] codePoints();

    abstract int offset();

    static Latin1CodePointArray create(byte[] codePoints, int size, ImmutableList<Integer> lineOffsets) {
        return Latin1CodePointArray.create(codePoints, 0, lineOffsets, size);
    }

    static Latin1CodePointArray create(byte[] codePoints, int offset, ImmutableList<Integer> lineOffsets, int size) {
        return new AutoValue_Latin1CodePointArray(size, Preconditions.checkNotNull(lineOffsets), codePoints, offset);
    }

    @Override
    public Latin1CodePointArray slice(int i, int j) {
        Preconditions.checkPositionIndexes(i, j, this.size());
        return Latin1CodePointArray.create(this.codePoints(), this.offset() + i, this.lineOffsets(), j - i);
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex(index, this.size());
        return Byte.toUnsignedInt(this.codePoints()[this.offset() + index]);
    }

    @Override
    public final String toString() {
        return new String(this.codePoints(), this.offset(), this.size(), StandardCharsets.ISO_8859_1);
    }
}

