/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.AdaptingTypes;
import dev.cel.common.internal.BidiConverter;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoLiteAdapter;
import dev.cel.common.internal.WellKnownProto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Immutable
@CheckReturnValue
@Internal
public final class ProtoAdapter {
    public static final BidiConverter<Number, Number> INT_CONVERTER = BidiConverter.of(Number::longValue, value -> ProtoAdapter.intCheckedCast(value.longValue()));
    public static final BidiConverter<Number, Number> SIGNED_UINT32_CONVERTER = BidiConverter.of(value -> UnsignedInts.toLong(value.intValue()), value -> ProtoAdapter.unsignedIntCheckedCast(value.longValue()));
    public static final BidiConverter<Number, Number> UNSIGNED_UINT32_CONVERTER = BidiConverter.of(value -> UnsignedLong.fromLongBits(Integer.toUnsignedLong(value.intValue())), value -> ProtoAdapter.unsignedIntCheckedCast(value.longValue()));
    public static final BidiConverter<Number, Number> UNSIGNED_UINT64_CONVERTER = BidiConverter.of(value -> UnsignedLong.fromLongBits(value.longValue()), Number::longValue);
    public static final BidiConverter<Number, Number> DOUBLE_CONVERTER = BidiConverter.of(Number::doubleValue, Number::floatValue);
    private final ProtoLiteAdapter protoLiteAdapter;
    private final DynamicProto dynamicProto;
    private final boolean enableUnsignedLongs;

    public ProtoAdapter(DynamicProto dynamicProto, boolean enableUnsignedLongs) {
        this.dynamicProto = Preconditions.checkNotNull(dynamicProto);
        this.enableUnsignedLongs = enableUnsignedLongs;
        this.protoLiteAdapter = new ProtoLiteAdapter(enableUnsignedLongs);
    }

    public Object adaptProtoToValue(MessageOrBuilder proto) {
        WellKnownProto wellKnownProto;
        if (proto instanceof DynamicMessage) {
            proto = this.dynamicProto.maybeAdaptDynamicMessage((DynamicMessage)proto);
        }
        if ((wellKnownProto = (WellKnownProto)WellKnownProto.getByTypeName(ProtoAdapter.typeName(proto.getDescriptorForType())).orElse(null)) == null) {
            return proto;
        }
        switch (wellKnownProto) {
            case ANY_VALUE: {
                return this.unpackAnyProto((Any)proto);
            }
        }
        return this.protoLiteAdapter.adaptWellKnownProtoToValue(proto, wellKnownProto);
    }

    public Optional<Object> adaptFieldToValue(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue) {
        if (fieldDescriptor.isMapField()) {
            Descriptors.Descriptor entryDescriptor = fieldDescriptor.getMessageType();
            Descriptors.FieldDescriptor keyFieldDescriptor = entryDescriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor valueFieldDescriptor = entryDescriptor.findFieldByNumber(2);
            BidiConverter keyConverter = this.fieldToValueConverter(keyFieldDescriptor);
            BidiConverter valueConverter = this.fieldToValueConverter(valueFieldDescriptor);
            HashMap map = new HashMap();
            for (Object entry : (List)fieldValue) {
                Object mapValue;
                Object mapKey;
                if (entry instanceof MapEntry) {
                    MapEntry mapEntry = (MapEntry)entry;
                    mapKey = mapEntry.getKey();
                    mapValue = mapEntry.getValue();
                } else if (entry instanceof DynamicMessage) {
                    DynamicMessage dynamicMessage = (DynamicMessage)entry;
                    mapKey = dynamicMessage.getField(keyFieldDescriptor);
                    mapValue = dynamicMessage.getField(valueFieldDescriptor);
                } else {
                    throw new IllegalStateException("Unexpected map field type: " + entry);
                }
                map.put(keyConverter.forwardConverter().convert(mapKey), valueConverter.forwardConverter().convert(mapValue));
            }
            return Optional.of(map);
        }
        if (fieldDescriptor.isRepeated()) {
            BidiConverter bidiConverter = this.fieldToValueConverter(fieldDescriptor);
            if (bidiConverter == BidiConverter.IDENTITY) {
                return Optional.of(fieldValue);
            }
            return Optional.of(AdaptingTypes.adaptingList((List)fieldValue, bidiConverter));
        }
        return Optional.of(this.fieldToValueConverter(fieldDescriptor).forwardConverter().convert(fieldValue));
    }

    public Optional<Object> adaptValueToFieldType(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue) {
        if (ProtoAdapter.isWrapperType(fieldDescriptor) && fieldValue.equals(NullValue.NULL_VALUE)) {
            return Optional.empty();
        }
        if (fieldDescriptor.isMapField()) {
            Descriptors.Descriptor entryDescriptor = fieldDescriptor.getMessageType();
            Descriptors.FieldDescriptor keyDescriptor = entryDescriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor valueDescriptor = entryDescriptor.findFieldByNumber(2);
            BidiConverter keyConverter = this.fieldToValueConverter(keyDescriptor);
            BidiConverter valueConverter = this.fieldToValueConverter(valueDescriptor);
            ArrayList<Message> mapEntries = new ArrayList<Message>();
            MapEntry<Object, Object> protoMapEntry = MapEntry.newDefaultInstance(entryDescriptor, keyDescriptor.getLiteType(), ProtoAdapter.getDefaultValueForMaybeMessage(keyDescriptor), valueDescriptor.getLiteType(), ProtoAdapter.getDefaultValueForMaybeMessage(valueDescriptor));
            for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                mapEntries.add(((MapEntry.Builder)protoMapEntry.toBuilder()).setKey(keyConverter.backwardConverter().convert(entry.getKey())).setValue(valueConverter.backwardConverter().convert(entry.getValue())).build());
            }
            return Optional.of(mapEntries);
        }
        if (fieldDescriptor.isRepeated()) {
            return Optional.of(AdaptingTypes.adaptingList((List)fieldValue, this.fieldToValueConverter(fieldDescriptor).reverse()));
        }
        return Optional.of(this.fieldToValueConverter(fieldDescriptor).backwardConverter().convert(fieldValue));
    }

    private BidiConverter fieldToValueConverter(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case SFIXED32: 
            case SINT32: 
            case INT32: {
                return INT_CONVERTER;
            }
            case FIXED32: 
            case UINT32: {
                if (this.enableUnsignedLongs) {
                    return UNSIGNED_UINT32_CONVERTER;
                }
                return SIGNED_UINT32_CONVERTER;
            }
            case FIXED64: 
            case UINT64: {
                if (this.enableUnsignedLongs) {
                    return UNSIGNED_UINT64_CONVERTER;
                }
                return BidiConverter.IDENTITY;
            }
            case FLOAT: {
                return DOUBLE_CONVERTER;
            }
            case ENUM: {
                return BidiConverter.of(value -> ((Descriptors.EnumValueDescriptor)value).getNumber(), number -> fieldDescriptor.getEnumType().findValueByNumberCreatingIfUnknown(number.intValue()));
            }
            case MESSAGE: {
                return BidiConverter.of(this::adaptProtoToValue, value -> this.adaptValueToProto(value, fieldDescriptor.getMessageType().getFullName()));
            }
        }
        return BidiConverter.IDENTITY;
    }

    public Message adaptValueToProto(Object value, String protoTypeName) {
        WellKnownProto wellKnownProto = WellKnownProto.getByTypeName(protoTypeName).orElse(null);
        if (wellKnownProto == null) {
            if (value instanceof Message) {
                return (Message)value;
            }
            throw new IllegalStateException(String.format("value not convertible to proto: %s", value));
        }
        switch (wellKnownProto) {
            case ANY_VALUE: {
                if (value instanceof Message) {
                    protoTypeName = ((Message)value).getDescriptorForType().getFullName();
                }
                return this.protoLiteAdapter.adaptValueToAny(value, protoTypeName);
            }
        }
        return (Message)this.protoLiteAdapter.adaptValueToWellKnownProto(value, wellKnownProto);
    }

    private Object unpackAnyProto(Any anyProto) {
        try {
            return this.adaptProtoToValue(this.dynamicProto.unpack(anyProto));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Object getDefaultValueForMaybeMessage(Descriptors.FieldDescriptor descriptor) {
        if (descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return DynamicMessage.getDefaultInstance(descriptor.getMessageType());
        }
        return descriptor.getDefaultValue();
    }

    private static String typeName(Descriptors.Descriptor protoType) {
        return protoType.getFullName();
    }

    private static boolean isWrapperType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return false;
        }
        String fieldTypeName = fieldDescriptor.getMessageType().getFullName();
        return WellKnownProto.isWrapperType(fieldTypeName);
    }

    private static int intCheckedCast(long value) {
        try {
            return Ints.checkedCast(value);
        }
        catch (IllegalArgumentException e) {
            throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
        }
    }

    private static int unsignedIntCheckedCast(long value) {
        try {
            return UnsignedInts.checkedCast(value);
        }
        catch (IllegalArgumentException e) {
            throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
        }
    }
}

