/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.NullValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelProtoJsonAdapter;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.WellKnownProto;
import java.util.Map;

@Immutable
@Internal
public final class ProtoLiteAdapter {
    private final boolean enableUnsignedLongs;

    public MessageLite adaptValueToWellKnownProto(Object value, WellKnownProto wellKnownProto) {
        switch (wellKnownProto) {
            case JSON_VALUE: {
                return CelProtoJsonAdapter.adaptValueToJsonValue(value);
            }
            case JSON_STRUCT_VALUE: {
                return CelProtoJsonAdapter.adaptToJsonStructValue((Map)value);
            }
            case JSON_LIST_VALUE: {
                return CelProtoJsonAdapter.adaptToJsonListValue((Iterable)value);
            }
            case BOOL_VALUE: {
                return BoolValue.of((Boolean)value);
            }
            case BYTES_VALUE: {
                return BytesValue.of((ByteString)value);
            }
            case DOUBLE_VALUE: {
                return this.adaptValueToDouble(value);
            }
            case FLOAT_VALUE: {
                return this.adaptValueToFloat(value);
            }
            case INT32_VALUE: {
                return this.adaptValueToInt32(value);
            }
            case INT64_VALUE: {
                return this.adaptValueToInt64(value);
            }
            case STRING_VALUE: {
                return StringValue.of((String)value);
            }
            case UINT32_VALUE: {
                return this.adaptValueToUint32(value);
            }
            case UINT64_VALUE: {
                return this.adaptValueToUint64(value);
            }
            case DURATION: {
                return (Duration)value;
            }
            case TIMESTAMP: {
                return (Timestamp)value;
            }
            case EMPTY: 
            case FIELD_MASK: {
                return (MessageLite)value;
            }
        }
        throw new IllegalArgumentException("Unexpected wellKnownProto kind: " + (Object)((Object)wellKnownProto) + " for value: " + value);
    }

    public Any adaptValueToAny(Object value, String typeName) {
        WellKnownProto wellKnownProto;
        if (value instanceof MessageLite) {
            return ProtoLiteAdapter.packAnyMessage((MessageLite)value, typeName);
        }
        if (value instanceof NullValue) {
            return ProtoLiteAdapter.packAnyMessage((MessageLite)Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build(), WellKnownProto.JSON_VALUE);
        }
        if (value instanceof Boolean) {
            wellKnownProto = WellKnownProto.BOOL_VALUE;
        } else if (value instanceof ByteString) {
            wellKnownProto = WellKnownProto.BYTES_VALUE;
        } else if (value instanceof String) {
            wellKnownProto = WellKnownProto.STRING_VALUE;
        } else if (value instanceof Float) {
            wellKnownProto = WellKnownProto.FLOAT_VALUE;
        } else if (value instanceof Double) {
            wellKnownProto = WellKnownProto.DOUBLE_VALUE;
        } else if (value instanceof Long) {
            wellKnownProto = WellKnownProto.INT64_VALUE;
        } else if (value instanceof UnsignedLong) {
            wellKnownProto = WellKnownProto.UINT64_VALUE;
        } else if (value instanceof Iterable) {
            wellKnownProto = WellKnownProto.JSON_LIST_VALUE;
        } else if (value instanceof Map) {
            wellKnownProto = WellKnownProto.JSON_STRUCT_VALUE;
        } else {
            throw new IllegalArgumentException("Unsupported value conversion to any: " + value);
        }
        MessageLite wellKnownProtoMsg = this.adaptValueToWellKnownProto(value, wellKnownProto);
        return ProtoLiteAdapter.packAnyMessage(wellKnownProtoMsg, wellKnownProto);
    }

    public Object adaptWellKnownProtoToValue(MessageLiteOrBuilder proto, WellKnownProto wellKnownProto) {
        switch (wellKnownProto) {
            case JSON_VALUE: {
                return this.adaptJsonToValue((Value)proto);
            }
            case JSON_STRUCT_VALUE: {
                return this.adaptJsonStructToValue((Struct)proto);
            }
            case JSON_LIST_VALUE: {
                return this.adaptJsonListToValue((ListValue)proto);
            }
            case BOOL_VALUE: {
                return ((BoolValue)proto).getValue();
            }
            case BYTES_VALUE: {
                return ((BytesValue)proto).getValue();
            }
            case DOUBLE_VALUE: {
                return ((DoubleValue)proto).getValue();
            }
            case FLOAT_VALUE: {
                return (double)((FloatValue)proto).getValue();
            }
            case INT32_VALUE: {
                return (long)((Int32Value)proto).getValue();
            }
            case INT64_VALUE: {
                return ((Int64Value)proto).getValue();
            }
            case STRING_VALUE: {
                return ((StringValue)proto).getValue();
            }
            case UINT32_VALUE: {
                if (this.enableUnsignedLongs) {
                    return UnsignedLong.fromLongBits(Integer.toUnsignedLong(((UInt32Value)proto).getValue()));
                }
                return (long)((UInt32Value)proto).getValue();
            }
            case UINT64_VALUE: {
                if (this.enableUnsignedLongs) {
                    return UnsignedLong.fromLongBits(((UInt64Value)proto).getValue());
                }
                return ((UInt64Value)proto).getValue();
            }
        }
        return proto;
    }

    private Object adaptJsonToValue(Value value) {
        switch (value.getKindCase()) {
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case NULL_VALUE: {
                return value.getNullValue();
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case LIST_VALUE: {
                return this.adaptJsonListToValue(value.getListValue());
            }
            case STRUCT_VALUE: {
                return this.adaptJsonStructToValue(value.getStructValue());
            }
            case KIND_NOT_SET: {
                return NullValue.NULL_VALUE;
            }
        }
        throw new IllegalArgumentException("unexpected value kind: " + value.getKindCase());
    }

    private ImmutableList<Object> adaptJsonListToValue(ListValue listValue) {
        return listValue.getValuesList().stream().map(this::adaptJsonToValue).collect(ImmutableList.toImmutableList());
    }

    private ImmutableMap<String, Object> adaptJsonStructToValue(Struct struct) {
        return struct.getFieldsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> this.adaptJsonToValue((Value)e.getValue())));
    }

    private Message adaptValueToDouble(Object value) {
        if (value instanceof Double) {
            return DoubleValue.of((Double)value);
        }
        if (value instanceof Float) {
            return DoubleValue.of(((Float)value).doubleValue());
        }
        throw new IllegalArgumentException("Unexpected value type: " + value);
    }

    private Message adaptValueToFloat(Object value) {
        if (value instanceof Double) {
            return FloatValue.of(((Double)value).floatValue());
        }
        if (value instanceof Float) {
            return FloatValue.of(((Float)value).floatValue());
        }
        throw new IllegalArgumentException("Unexpected value type: " + value);
    }

    private Message adaptValueToInt32(Object value) {
        if (value instanceof Integer) {
            return Int32Value.of((Integer)value);
        }
        if (value instanceof Long) {
            return Int32Value.of(ProtoLiteAdapter.intCheckedCast((Long)value));
        }
        throw new IllegalArgumentException("Unexpected value type: " + value);
    }

    private Message adaptValueToInt64(Object value) {
        if (value instanceof Integer) {
            return Int64Value.of(((Integer)value).longValue());
        }
        if (value instanceof Long) {
            return Int64Value.of((Long)value);
        }
        throw new IllegalArgumentException("Unexpected value type: " + value);
    }

    private Message adaptValueToUint32(Object value) {
        if (value instanceof Integer) {
            return UInt32Value.of((Integer)value);
        }
        if (value instanceof Long) {
            try {
                return UInt32Value.of(ProtoLiteAdapter.unsignedIntCheckedCast((Long)value));
            }
            catch (IllegalArgumentException e) {
                throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
            }
        }
        if (value instanceof UnsignedLong) {
            try {
                return UInt32Value.of(ProtoLiteAdapter.unsignedIntCheckedCast(((UnsignedLong)value).longValue()));
            }
            catch (IllegalArgumentException e) {
                throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
            }
        }
        throw new IllegalArgumentException("Unexpected value type: " + value);
    }

    private Message adaptValueToUint64(Object value) {
        if (value instanceof Integer) {
            return UInt64Value.of(UnsignedInts.toLong((Integer)value));
        }
        if (value instanceof Long) {
            return UInt64Value.of((Long)value);
        }
        if (value instanceof UnsignedLong) {
            return UInt64Value.of(((UnsignedLong)value).longValue());
        }
        throw new IllegalArgumentException("Unexpected value type: " + value);
    }

    private static int intCheckedCast(long value) {
        try {
            return Ints.checkedCast(value);
        }
        catch (IllegalArgumentException e) {
            throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
        }
    }

    private static int unsignedIntCheckedCast(long value) {
        try {
            return UnsignedInts.checkedCast(value);
        }
        catch (IllegalArgumentException e) {
            throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
        }
    }

    private static Any packAnyMessage(MessageLite msg, WellKnownProto wellKnownProto) {
        return ProtoLiteAdapter.packAnyMessage(msg, wellKnownProto.typeName());
    }

    private static Any packAnyMessage(MessageLite msg, String typeUrl) {
        return Any.newBuilder().setValue(msg.toByteString()).setTypeUrl("type.googleapis.com/" + typeUrl).build();
    }

    public ProtoLiteAdapter(boolean enableUnsignedLongs) {
        this.enableUnsignedLongs = enableUnsignedLongs;
    }
}

