/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.ListValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import dev.cel.common.annotations.Internal;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

@Internal
public enum WellKnownProto {
    ANY_VALUE("google.protobuf.Any", Any.class),
    DURATION("google.protobuf.Duration", Duration.class),
    JSON_LIST_VALUE("google.protobuf.ListValue", ListValue.class),
    JSON_STRUCT_VALUE("google.protobuf.Struct", Struct.class),
    JSON_VALUE("google.protobuf.Value", Value.class),
    TIMESTAMP("google.protobuf.Timestamp", Timestamp.class),
    FLOAT_VALUE("google.protobuf.FloatValue", FloatValue.class, true),
    INT32_VALUE("google.protobuf.Int32Value", Int32Value.class, true),
    INT64_VALUE("google.protobuf.Int64Value", Int64Value.class, true),
    STRING_VALUE("google.protobuf.StringValue", StringValue.class, true),
    BOOL_VALUE("google.protobuf.BoolValue", BoolValue.class, true),
    BYTES_VALUE("google.protobuf.BytesValue", BytesValue.class, true),
    DOUBLE_VALUE("google.protobuf.DoubleValue", DoubleValue.class, true),
    UINT32_VALUE("google.protobuf.UInt32Value", UInt32Value.class, true),
    UINT64_VALUE("google.protobuf.UInt64Value", UInt64Value.class, true),
    EMPTY("google.protobuf.Empty", Empty.class, true),
    FIELD_MASK("google.protobuf.FieldMask", FieldMask.class, true);

    private static final ImmutableMap<String, WellKnownProto> TYPE_NAME_TO_WELL_KNOWN_PROTO_MAP;
    private static final ImmutableMap<Class<?>, WellKnownProto> CLASS_TO_NAME_TO_WELL_KNOWN_PROTO_MAP;
    private final String wellKnownProtoTypeName;
    private final Class<?> clazz;
    private final boolean isWrapperType;

    public String typeName() {
        return this.wellKnownProtoTypeName;
    }

    public Class<?> messageClass() {
        return this.clazz;
    }

    public static Optional<WellKnownProto> getByTypeName(String typeName) {
        return Optional.ofNullable(TYPE_NAME_TO_WELL_KNOWN_PROTO_MAP.get(typeName));
    }

    public static Optional<WellKnownProto> getByClass(Class<?> clazz) {
        return Optional.ofNullable(CLASS_TO_NAME_TO_WELL_KNOWN_PROTO_MAP.get(clazz));
    }

    public static boolean isWrapperType(String typeName) {
        return WellKnownProto.getByTypeName(typeName).map(WellKnownProto::isWrapperType).orElse(false);
    }

    public boolean isWrapperType() {
        return this.isWrapperType;
    }

    private WellKnownProto(String wellKnownProtoTypeName, Class<?> clazz) {
        this(wellKnownProtoTypeName, clazz, false);
    }

    private WellKnownProto(String wellKnownProtoFullName, Class<?> clazz, boolean isWrapperType) {
        this.wellKnownProtoTypeName = wellKnownProtoFullName;
        this.clazz = clazz;
        this.isWrapperType = isWrapperType;
    }

    static {
        TYPE_NAME_TO_WELL_KNOWN_PROTO_MAP = Arrays.stream(WellKnownProto.values()).collect(ImmutableMap.toImmutableMap(WellKnownProto::typeName, Function.identity()));
        CLASS_TO_NAME_TO_WELL_KNOWN_PROTO_MAP = Arrays.stream(WellKnownProto.values()).collect(ImmutableMap.toImmutableMap(WellKnownProto::messageClass, Function.identity()));
    }
}

