/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.navigation;

import dev.cel.common.ast.Expression;
import dev.cel.common.navigation.BaseNavigableExpr;
import dev.cel.common.navigation.ExprPropertyCalculator;
import dev.cel.common.navigation.TraversalOrder;
import java.util.List;
import java.util.stream.Stream;

final class CelNavigableExprVisitor<E extends Expression, T extends BaseNavigableExpr<E>> {
    private static final int MAX_DESCENDANTS_RECURSION_DEPTH = 500;
    private final Stream.Builder<T> streamBuilder;
    private final ExprPropertyCalculator<E> exprPropertyCalculator;
    private final TraversalOrder traversalOrder;
    private final int maxDepth;

    private CelNavigableExprVisitor(int maxDepth, ExprPropertyCalculator<E> exprPropertyCalculator, TraversalOrder traversalOrder) {
        this.maxDepth = maxDepth;
        this.exprPropertyCalculator = exprPropertyCalculator;
        this.traversalOrder = traversalOrder;
        this.streamBuilder = Stream.builder();
    }

    static <E extends Expression, T extends BaseNavigableExpr<E>> Stream<T> collect(T navigableExpr, TraversalOrder traversalOrder) {
        return CelNavigableExprVisitor.collect(navigableExpr, 500, traversalOrder);
    }

    static <E extends Expression, T extends BaseNavigableExpr<E>> Stream<T> collect(T navigableExpr, int maxDepth, TraversalOrder traversalOrder) {
        ExprPropertyCalculator<E> exprHeightCalculator = new ExprPropertyCalculator<E>(navigableExpr.expr());
        CelNavigableExprVisitor<E, T> visitor = new CelNavigableExprVisitor<E, T>(maxDepth, exprHeightCalculator, traversalOrder);
        super.visit(navigableExpr);
        return visitor.streamBuilder.build();
    }

    private void visit(T navigableExpr) {
        boolean addToStream;
        if (((BaseNavigableExpr)navigableExpr).depth() > 499) {
            throw new IllegalStateException("Max recursion depth reached.");
        }
        boolean bl = addToStream = ((BaseNavigableExpr)navigableExpr).depth() <= this.maxDepth;
        if (addToStream && this.traversalOrder.equals((Object)TraversalOrder.PRE_ORDER)) {
            this.streamBuilder.add(navigableExpr);
        }
        switch (((BaseNavigableExpr)navigableExpr).getKind()) {
            case CALL: {
                this.visit(navigableExpr, ((BaseNavigableExpr)navigableExpr).expr().call());
                break;
            }
            case LIST: {
                this.visit(navigableExpr, ((BaseNavigableExpr)navigableExpr).expr().list());
                break;
            }
            case SELECT: {
                this.visit(navigableExpr, ((BaseNavigableExpr)navigableExpr).expr().select());
                break;
            }
            case STRUCT: {
                this.visitStruct(navigableExpr, ((BaseNavigableExpr)navigableExpr).expr().struct());
                break;
            }
            case MAP: {
                this.visitMap(navigableExpr, ((BaseNavigableExpr)navigableExpr).expr().map());
                break;
            }
            case COMPREHENSION: {
                this.visit(navigableExpr, ((BaseNavigableExpr)navigableExpr).expr().comprehension());
                break;
            }
        }
        if (addToStream && this.traversalOrder.equals((Object)TraversalOrder.POST_ORDER)) {
            this.streamBuilder.add(navigableExpr);
        }
    }

    private void visit(T navigableExpr, Expression.Call<E> call) {
        if (call.target().isPresent()) {
            this.visit(this.newNavigableChild(navigableExpr, (Expression)call.target().get()));
        }
        this.visitExprList(call.args(), navigableExpr);
    }

    private void visit(T navigableExpr, Expression.List<E> list) {
        this.visitExprList(list.elements(), navigableExpr);
    }

    private void visit(T navigableExpr, Expression.Select<E> selectExpr) {
        T operand = this.newNavigableChild(navigableExpr, selectExpr.operand());
        this.visit(operand);
    }

    private void visit(T navigableExpr, Expression.Comprehension<E> comprehension) {
        this.visit(this.newNavigableChild(navigableExpr, comprehension.iterRange()));
        this.visit(this.newNavigableChild(navigableExpr, comprehension.accuInit()));
        this.visit(this.newNavigableChild(navigableExpr, comprehension.loopCondition()));
        this.visit(this.newNavigableChild(navigableExpr, comprehension.loopStep()));
        this.visit(this.newNavigableChild(navigableExpr, comprehension.result()));
    }

    private void visitStruct(T navigableExpr, Expression.Struct<Expression.Struct.Entry<E>> struct) {
        for (Expression.Struct.Entry<E> entry : struct.entries()) {
            this.visit(this.newNavigableChild(navigableExpr, entry.value()));
        }
    }

    private void visitMap(T navigableExpr, Expression.Map<Expression.Map.Entry<E>> map) {
        for (Expression.Map.Entry<E> entry : map.entries()) {
            T key = this.newNavigableChild(navigableExpr, entry.key());
            this.visit(key);
            T value = this.newNavigableChild(navigableExpr, entry.value());
            this.visit(value);
        }
    }

    private void visitExprList(List<E> list, T parent) {
        for (Expression expr : list) {
            this.visit(this.newNavigableChild(parent, expr));
        }
    }

    private T newNavigableChild(T parent, E expr) {
        ExprPropertyCalculator.ExprProperty exprProperty = this.exprPropertyCalculator.getProperty(expr.id());
        return ((BaseNavigableExpr)parent).builderFromInstance().setExpr(expr).setDepth(((BaseNavigableExpr)parent).depth() + 1).setHeight(exprProperty.height()).setMaxId(exprProperty.maxId()).setParent(parent).build();
    }
}

