/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.api.expr.v1alpha1.Type;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Empty;
import com.google.protobuf.NullValue;
import dev.cel.common.annotations.Internal;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.NullableType;
import dev.cel.common.types.OpaqueType;
import dev.cel.common.types.ProtoMessageType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.TypeParamType;
import dev.cel.common.types.TypeType;
import java.util.Optional;

public final class CelV1AlphaTypes {
    public static final String ANY_MESSAGE = "google.protobuf.Any";
    public static final String DURATION_MESSAGE = "google.protobuf.Duration";
    public static final String LIST_VALUE_MESSAGE = "google.protobuf.ListValue";
    public static final String STRUCT_MESSAGE = "google.protobuf.Struct";
    public static final String TIMESTAMP_MESSAGE = "google.protobuf.Timestamp";
    public static final String VALUE_MESSAGE = "google.protobuf.Value";
    public static final String BOOL_WRAPPER_MESSAGE = "google.protobuf.BoolValue";
    public static final String BYTES_WRAPPER_MESSAGE = "google.protobuf.BytesValue";
    public static final String DOUBLE_WRAPPER_MESSAGE = "google.protobuf.DoubleValue";
    public static final String FLOAT_WRAPPER_MESSAGE = "google.protobuf.FloatValue";
    public static final String INT32_WRAPPER_MESSAGE = "google.protobuf.Int32Value";
    public static final String INT64_WRAPPER_MESSAGE = "google.protobuf.Int64Value";
    public static final String STRING_WRAPPER_MESSAGE = "google.protobuf.StringValue";
    public static final String UINT32_WRAPPER_MESSAGE = "google.protobuf.UInt32Value";
    public static final String UINT64_WRAPPER_MESSAGE = "google.protobuf.UInt64Value";
    public static final Type ERROR = Type.newBuilder().setError(Empty.getDefaultInstance()).build();
    public static final Type DYN = Type.newBuilder().setDyn(Empty.getDefaultInstance()).build();
    public static final Type NULL_TYPE = Type.newBuilder().setNull(NullValue.NULL_VALUE).build();
    public static final Type BOOL = CelV1AlphaTypes.create(Type.PrimitiveType.BOOL);
    public static final Type BYTES = CelV1AlphaTypes.create(Type.PrimitiveType.BYTES);
    public static final Type STRING = CelV1AlphaTypes.create(Type.PrimitiveType.STRING);
    public static final Type DOUBLE = CelV1AlphaTypes.create(Type.PrimitiveType.DOUBLE);
    public static final Type UINT64 = CelV1AlphaTypes.create(Type.PrimitiveType.UINT64);
    public static final Type INT64 = CelV1AlphaTypes.create(Type.PrimitiveType.INT64);
    public static final Type ANY = CelV1AlphaTypes.create(Type.WellKnownType.ANY);
    public static final Type TIMESTAMP = CelV1AlphaTypes.create(Type.WellKnownType.TIMESTAMP);
    public static final Type DURATION = CelV1AlphaTypes.create(Type.WellKnownType.DURATION);
    static final ImmutableMap<String, Type> WELL_KNOWN_TYPE_MAP = ImmutableMap.builder().put("google.protobuf.DoubleValue", CelV1AlphaTypes.createWrapper(DOUBLE)).put("google.protobuf.FloatValue", CelV1AlphaTypes.createWrapper(DOUBLE)).put("google.protobuf.Int64Value", CelV1AlphaTypes.createWrapper(INT64)).put("google.protobuf.Int32Value", CelV1AlphaTypes.createWrapper(INT64)).put("google.protobuf.UInt64Value", CelV1AlphaTypes.createWrapper(UINT64)).put("google.protobuf.UInt32Value", CelV1AlphaTypes.createWrapper(UINT64)).put("google.protobuf.BoolValue", CelV1AlphaTypes.createWrapper(BOOL)).put("google.protobuf.StringValue", CelV1AlphaTypes.createWrapper(STRING)).put("google.protobuf.BytesValue", CelV1AlphaTypes.createWrapper(BYTES)).put("google.protobuf.Timestamp", TIMESTAMP).put("google.protobuf.Duration", DURATION).put("google.protobuf.Struct", CelV1AlphaTypes.createMap(STRING, DYN)).put("google.protobuf.Value", DYN).put("google.protobuf.ListValue", CelV1AlphaTypes.createList(DYN)).put("google.protobuf.Any", ANY).buildOrThrow();
    static final ImmutableMap<CelKind, Type> SIMPLE_CEL_KIND_TO_TYPE = ImmutableMap.builder().put(CelKind.ERROR, ERROR).put(CelKind.DYN, DYN).put(CelKind.ANY, ANY).put(CelKind.BOOL, BOOL).put(CelKind.BYTES, BYTES).put(CelKind.DOUBLE, DOUBLE).put(CelKind.DURATION, DURATION).put(CelKind.INT, INT64).put(CelKind.NULL_TYPE, NULL_TYPE).put(CelKind.STRING, STRING).put(CelKind.TIMESTAMP, TIMESTAMP).put(CelKind.UINT, UINT64).buildOrThrow();
    private static final ImmutableMap<String, CelType> WELL_KNOWN_CEL_TYPE_MAP = ImmutableMap.builder().put("google.protobuf.BoolValue", NullableType.create(SimpleType.BOOL)).put("google.protobuf.BytesValue", NullableType.create(SimpleType.BYTES)).put("google.protobuf.FloatValue", NullableType.create(SimpleType.DOUBLE)).put("google.protobuf.DoubleValue", NullableType.create(SimpleType.DOUBLE)).put("google.protobuf.Int32Value", NullableType.create(SimpleType.INT)).put("google.protobuf.Int64Value", NullableType.create(SimpleType.INT)).put("google.protobuf.StringValue", NullableType.create(SimpleType.STRING)).put("google.protobuf.UInt32Value", NullableType.create(SimpleType.UINT)).put("google.protobuf.UInt64Value", NullableType.create(SimpleType.UINT)).put("google.protobuf.Any", (NullableType)SimpleType.ANY).put("google.protobuf.Duration", (NullableType)SimpleType.DURATION).put("google.protobuf.Timestamp", (NullableType)SimpleType.TIMESTAMP).put("google.protobuf.ListValue", (NullableType)((Object)ListType.create(SimpleType.DYN))).put("google.protobuf.Struct", (NullableType)((Object)MapType.create(SimpleType.STRING, SimpleType.DYN))).put("google.protobuf.Value", (NullableType)SimpleType.DYN).buildOrThrow();
    private static final ImmutableMap<Type, CelType> PROTOBUF_TYPE_TO_CEL_TYPE_MAP = ImmutableMap.builder().put(BOOL, SimpleType.BOOL).put(BYTES, SimpleType.BYTES).put(DOUBLE, SimpleType.DOUBLE).put(INT64, SimpleType.INT).put(STRING, SimpleType.STRING).put(UINT64, SimpleType.UINT).put(ANY, SimpleType.ANY).put(DURATION, SimpleType.DURATION).put(TIMESTAMP, SimpleType.TIMESTAMP).put(DYN, SimpleType.DYN).put(NULL_TYPE, SimpleType.NULL_TYPE).put(ERROR, SimpleType.ERROR).buildOrThrow();

    private CelV1AlphaTypes() {
    }

    public static Type create(Type.PrimitiveType type) {
        return Type.newBuilder().setPrimitive(type).build();
    }

    public static Type create(Type.WellKnownType type) {
        return Type.newBuilder().setWellKnown(type).build();
    }

    public static Type create(Type target) {
        return Type.newBuilder().setType(target).build();
    }

    public static Type createList(Type elemType) {
        return Type.newBuilder().setListType(Type.ListType.newBuilder().setElemType(elemType)).build();
    }

    public static Type createMap(Type keyType, Type valueType) {
        return Type.newBuilder().setMapType(Type.MapType.newBuilder().setKeyType(keyType).setValueType(valueType)).build();
    }

    public static Type createMessage(String messageName) {
        return Type.newBuilder().setMessageType(messageName).build();
    }

    public static Type createMessage(Descriptors.Descriptor descriptor) {
        return CelV1AlphaTypes.createMessage(descriptor.getFullName());
    }

    public static Type createTypeParam(String name) {
        return Type.newBuilder().setTypeParam(name).build();
    }

    public static Type createWrapper(Type.PrimitiveType primitive) {
        return Type.newBuilder().setWrapper(primitive).build();
    }

    public static Type createWrapper(Type type) {
        Preconditions.checkArgument(type.getTypeKindCase() == Type.TypeKindCase.PRIMITIVE);
        return CelV1AlphaTypes.createWrapper(type.getPrimitive());
    }

    public static String format(Type type) {
        return CelV1AlphaTypes.format(type, false);
    }

    private static String format(Type type, boolean typeParamToDyn) {
        switch (type.getTypeKindCase()) {
            case DYN: {
                return "dyn";
            }
            case NULL: {
                return "null";
            }
            case PRIMITIVE: {
                switch (type.getPrimitive()) {
                    case BOOL: {
                        return "bool";
                    }
                    case INT64: {
                        return "int";
                    }
                    case UINT64: {
                        return "uint";
                    }
                    case DOUBLE: {
                        return "double";
                    }
                    case STRING: {
                        return "string";
                    }
                    case BYTES: {
                        return "bytes";
                    }
                }
                break;
            }
            case WELL_KNOWN: {
                switch (type.getWellKnown()) {
                    case TIMESTAMP: {
                        return TIMESTAMP_MESSAGE;
                    }
                    case DURATION: {
                        return DURATION_MESSAGE;
                    }
                    case ANY: {
                        return "any";
                    }
                }
                break;
            }
            case LIST_TYPE: {
                return String.format("list(%s)", CelV1AlphaTypes.format(type.getListType().getElemType(), typeParamToDyn));
            }
            case MAP_TYPE: {
                return String.format("map(%s, %s)", CelV1AlphaTypes.format(type.getMapType().getKeyType(), typeParamToDyn), CelV1AlphaTypes.format(type.getMapType().getValueType(), typeParamToDyn));
            }
            case TYPE: {
                return String.format("type(%s)", CelV1AlphaTypes.format(type.getType(), typeParamToDyn));
            }
            case WRAPPER: {
                return String.format("wrapper(%s)", CelV1AlphaTypes.format(CelV1AlphaTypes.create(type.getWrapper()), typeParamToDyn));
            }
            case ERROR: {
                return "*error*";
            }
            case MESSAGE_TYPE: {
                return type.getMessageType();
            }
            case TYPE_PARAM: {
                return typeParamToDyn ? "dyn" : type.getTypeParam();
            }
            case FUNCTION: {
                return CelV1AlphaTypes.formatFunction(type.getFunction().getResultType(), type.getFunction().getArgTypesList(), false, typeParamToDyn);
            }
            case ABSTRACT_TYPE: {
                String result = type.getAbstractType().getName();
                if (type.getAbstractType().getParameterTypesCount() > 0) {
                    result = result + CelV1AlphaTypes.formatTypeArgs(type.getAbstractType().getParameterTypesList(), typeParamToDyn);
                }
                return result;
            }
        }
        return "<unknown type>";
    }

    public static String formatFunction(Type resultType, Iterable<Type> argTypes, boolean isInstance, boolean typeParamToDyn) {
        String argString = isInstance ? CelV1AlphaTypes.format(Iterables.get(argTypes, 0), typeParamToDyn) + "." + CelV1AlphaTypes.formatTypeArgs(Iterables.skip(argTypes, 1), typeParamToDyn) : CelV1AlphaTypes.formatTypeArgs(argTypes, typeParamToDyn);
        if (resultType == null) {
            return argString;
        }
        return argString + " -> " + CelV1AlphaTypes.format(resultType, typeParamToDyn);
    }

    public static boolean isWellKnownType(String typeName) {
        return WELL_KNOWN_TYPE_MAP.containsKey(typeName);
    }

    public static Optional<CelType> getWellKnownCelType(String typeName) {
        return Optional.ofNullable(WELL_KNOWN_CEL_TYPE_MAP.getOrDefault(typeName, null));
    }

    @Internal
    public static Type celTypeToType(CelType celType) {
        Type type = SIMPLE_CEL_KIND_TO_TYPE.get((Object)celType.kind());
        if (type != null) {
            if (celType instanceof NullableType) {
                return CelV1AlphaTypes.createWrapper(type);
            }
            return type;
        }
        switch (celType.kind()) {
            case LIST: {
                ListType listType = (ListType)celType;
                return CelV1AlphaTypes.createList(CelV1AlphaTypes.celTypeToType(listType.elemType()));
            }
            case MAP: {
                MapType mapType = (MapType)celType;
                return CelV1AlphaTypes.createMap(CelV1AlphaTypes.celTypeToType(mapType.keyType()), CelV1AlphaTypes.celTypeToType(mapType.valueType()));
            }
            case OPAQUE: {
                return Type.newBuilder().setAbstractType(Type.AbstractType.newBuilder().setName(celType.name()).addAllParameterTypes((Iterable)celType.parameters().stream().map(CelV1AlphaTypes::celTypeToType).collect(ImmutableList.toImmutableList()))).build();
            }
            case STRUCT: {
                return CelV1AlphaTypes.createMessage(celType.name());
            }
            case TYPE: {
                TypeType typeType = (TypeType)celType;
                return CelV1AlphaTypes.create(CelV1AlphaTypes.celTypeToType(typeType.type()));
            }
            case TYPE_PARAM: {
                return CelV1AlphaTypes.createTypeParam(celType.name());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s", celType));
    }

    @Internal
    public static CelType typeToCelType(Type type) {
        CelType celType = PROTOBUF_TYPE_TO_CEL_TYPE_MAP.get(type);
        if (celType != null) {
            return celType;
        }
        switch (type.getTypeKindCase()) {
            case WRAPPER: {
                return NullableType.create(CelV1AlphaTypes.typeToCelType(CelV1AlphaTypes.create(type.getWrapper())));
            }
            case MESSAGE_TYPE: {
                return ProtoMessageType.create(type.getMessageType(), ImmutableSet.of(), fieldName -> Optional.empty());
            }
            case LIST_TYPE: {
                Type.ListType listType = type.getListType();
                return ListType.create(CelV1AlphaTypes.typeToCelType(listType.getElemType()));
            }
            case MAP_TYPE: {
                Type.MapType mapType = type.getMapType();
                return MapType.create(CelV1AlphaTypes.typeToCelType(mapType.getKeyType()), CelV1AlphaTypes.typeToCelType(mapType.getValueType()));
            }
            case TYPE_PARAM: {
                return TypeParamType.create(type.getTypeParam());
            }
            case ABSTRACT_TYPE: {
                Type.AbstractType abstractType = type.getAbstractType();
                ImmutableList<CelType> params = abstractType.getParameterTypesList().stream().map(CelV1AlphaTypes::typeToCelType).collect(ImmutableList.toImmutableList());
                return OpaqueType.create(abstractType.getName(), params);
            }
            case TYPE: {
                return TypeType.create(CelV1AlphaTypes.typeToCelType(type.getType()));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s", type));
    }

    private static String formatTypeArgs(Iterable<Type> types, boolean typeParamToDyn) {
        return String.format("(%s)", Joiner.on(", ").join(Iterables.transform(types, type -> CelV1AlphaTypes.format(type, typeParamToDyn))));
    }
}

