/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import dev.cel.common.CelDescriptorUtil;
import dev.cel.common.CelDescriptors;
import dev.cel.common.internal.FileDescriptorSetConverter;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypeProvider;
import dev.cel.common.types.CelTypes;
import dev.cel.common.types.EnumType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.ProtoMessageType;
import dev.cel.common.types.SimpleType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;

@CheckReturnValue
@Immutable
public final class ProtoMessageTypeProvider
implements CelTypeProvider {
    private static final ImmutableMap<Descriptors.FieldDescriptor.Type, CelType> PROTO_TYPE_TO_CEL_TYPE = ImmutableMap.builder().put(Descriptors.FieldDescriptor.Type.BOOL, SimpleType.BOOL).put(Descriptors.FieldDescriptor.Type.BYTES, SimpleType.BYTES).put(Descriptors.FieldDescriptor.Type.DOUBLE, SimpleType.DOUBLE).put(Descriptors.FieldDescriptor.Type.FLOAT, SimpleType.DOUBLE).put(Descriptors.FieldDescriptor.Type.FIXED32, SimpleType.UINT).put(Descriptors.FieldDescriptor.Type.FIXED64, SimpleType.UINT).put(Descriptors.FieldDescriptor.Type.INT32, SimpleType.INT).put(Descriptors.FieldDescriptor.Type.INT64, SimpleType.INT).put(Descriptors.FieldDescriptor.Type.SFIXED32, SimpleType.INT).put(Descriptors.FieldDescriptor.Type.SFIXED64, SimpleType.INT).put(Descriptors.FieldDescriptor.Type.SINT32, SimpleType.INT).put(Descriptors.FieldDescriptor.Type.SINT64, SimpleType.INT).put(Descriptors.FieldDescriptor.Type.STRING, SimpleType.STRING).put(Descriptors.FieldDescriptor.Type.UINT32, SimpleType.UINT).put(Descriptors.FieldDescriptor.Type.UINT64, SimpleType.UINT).buildOrThrow();
    private final ImmutableMap<String, CelType> allTypes;

    public ProtoMessageTypeProvider() {
        this(CelDescriptors.builder().build());
    }

    public ProtoMessageTypeProvider(DescriptorProtos.FileDescriptorSet descriptorSet) {
        this(CelDescriptorUtil.getAllDescriptorsFromFileDescriptor(FileDescriptorSetConverter.convert(descriptorSet)));
    }

    public ProtoMessageTypeProvider(Iterable<Descriptors.Descriptor> descriptors) {
        this(CelDescriptorUtil.getAllDescriptorsFromFileDescriptor(ImmutableSet.copyOf(Iterables.transform(descriptors, Descriptors.Descriptor::getFile))));
    }

    public ProtoMessageTypeProvider(ImmutableSet<Descriptors.FileDescriptor> fileDescriptors) {
        this(CelDescriptorUtil.getAllDescriptorsFromFileDescriptor(fileDescriptors));
    }

    public ProtoMessageTypeProvider(CelDescriptors celDescriptors) {
        this.allTypes = ImmutableMap.builder().putAll(this.createEnumTypes(celDescriptors.enumDescriptors())).putAll(this.createProtoMessageTypes(celDescriptors.messageTypeDescriptors(), celDescriptors.extensionDescriptors())).buildOrThrow();
    }

    @Override
    public ImmutableCollection<CelType> types() {
        return this.allTypes.values();
    }

    @Override
    public Optional<CelType> findType(String typeName) {
        return Optional.ofNullable(this.allTypes.get(typeName));
    }

    private ImmutableMap<String, CelType> createProtoMessageTypes(Collection<Descriptors.Descriptor> descriptors, ImmutableMultimap<String, Descriptors.FieldDescriptor> extensionMap) {
        HashMap<String, ProtoMessageType> protoMessageTypes = new HashMap<String, ProtoMessageType>();
        for (Descriptors.Descriptor descriptor : descriptors) {
            if (protoMessageTypes.containsKey(descriptor.getFullName())) continue;
            ImmutableList fieldNames = descriptor.getFields().stream().map(Descriptors.FieldDescriptor::getName).collect(ImmutableList.toImmutableList());
            HashMap<String, Descriptors.FieldDescriptor> extensionFields = new HashMap<String, Descriptors.FieldDescriptor>();
            for (Descriptors.FieldDescriptor extension : extensionMap.get((Object)descriptor.getFullName())) {
                extensionFields.putIfAbsent(extension.getFullName(), extension);
            }
            ImmutableMap extensions = ImmutableMap.copyOf(extensionFields);
            protoMessageTypes.put(descriptor.getFullName(), ProtoMessageType.create(descriptor.getFullName(), ImmutableSet.copyOf(fieldNames), arg_0 -> ProtoMessageTypeProvider.lambda$createProtoMessageTypes$0(new FieldResolver((CelTypeProvider)this, descriptor), arg_0), arg_0 -> ProtoMessageTypeProvider.lambda$createProtoMessageTypes$1(new FieldResolver((CelTypeProvider)this, extensions), arg_0)));
        }
        return ImmutableMap.copyOf(protoMessageTypes);
    }

    private ImmutableMap<String, CelType> createEnumTypes(Collection<Descriptors.EnumDescriptor> enumDescriptors) {
        HashMap<String, EnumType> enumTypes = new HashMap<String, EnumType>();
        for (Descriptors.EnumDescriptor enumDescriptor : enumDescriptors) {
            if (enumTypes.containsKey(enumDescriptor.getFullName())) continue;
            ImmutableMap<String, Integer> values2 = enumDescriptor.getValues().stream().collect(ImmutableMap.toImmutableMap(Descriptors.EnumValueDescriptor::getName, Descriptors.EnumValueDescriptor::getNumber));
            enumTypes.put(enumDescriptor.getFullName(), EnumType.create(enumDescriptor.getFullName(), values2));
        }
        return ImmutableMap.copyOf(enumTypes);
    }

    private static /* synthetic */ Optional lambda$createProtoMessageTypes$1(FieldResolver rec$, String x$0) {
        return rec$.findField(x$0);
    }

    private static /* synthetic */ Optional lambda$createProtoMessageTypes$0(FieldResolver rec$, String x$0) {
        return rec$.findField(x$0);
    }

    private static class FieldResolver {
        private final CelTypeProvider celTypeProvider;
        private final ImmutableMap<String, Descriptors.FieldDescriptor> fields;

        private FieldResolver(CelTypeProvider celTypeProvider, Descriptors.Descriptor descriptor) {
            this(celTypeProvider, descriptor.getFields().stream().collect(ImmutableMap.toImmutableMap(Descriptors.FieldDescriptor::getName, Function.identity())));
        }

        private FieldResolver(CelTypeProvider celTypeProvider, ImmutableMap<String, Descriptors.FieldDescriptor> fields) {
            this.celTypeProvider = celTypeProvider;
            this.fields = fields;
        }

        private Optional<CelType> findField(String fieldName) {
            Descriptors.FieldDescriptor fieldDescriptor = this.fields.get(fieldName);
            if (fieldDescriptor == null) {
                return Optional.empty();
            }
            return this.findFieldInternal(fieldDescriptor);
        }

        private Optional<CelType> findFieldInternal(Descriptors.FieldDescriptor fieldDescriptor) {
            CelType fieldType;
            boolean isRepeated = fieldDescriptor.isRepeated();
            switch (fieldDescriptor.getType()) {
                case GROUP: 
                case MESSAGE: {
                    Descriptors.Descriptor descriptor = fieldDescriptor.getMessageType();
                    if (fieldDescriptor.isMapField()) {
                        Descriptors.FieldDescriptor keyField = descriptor.getFields().get(0);
                        Descriptors.FieldDescriptor valueField = descriptor.getFields().get(1);
                        Optional<CelType> key = this.findFieldInternal(keyField);
                        Optional<CelType> value = this.findFieldInternal(valueField);
                        if (key.isPresent() && value.isPresent()) {
                            return Optional.of(MapType.create(key.get(), value.get()));
                        }
                        return Optional.empty();
                    }
                    String messageName = descriptor.getFullName();
                    fieldType = CelTypes.getWellKnownCelType(messageName).orElse(this.celTypeProvider.findType(descriptor.getFullName()).orElse(null));
                    break;
                }
                case ENUM: {
                    Descriptors.EnumDescriptor enumDescriptor = fieldDescriptor.getEnumType();
                    fieldType = this.celTypeProvider.findType(enumDescriptor.getFullName()).orElse(null);
                    break;
                }
                default: {
                    fieldType = (CelType)PROTO_TYPE_TO_CEL_TYPE.get((Object)fieldDescriptor.getType());
                }
            }
            if (fieldType == null) {
                return Optional.empty();
            }
            if (isRepeated) {
                return Optional.of(ListType.create(fieldType));
            }
            return Optional.of(fieldType);
        }
    }
}

