/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.common.internal.WellKnownProto;
import dev.cel.common.values.BytesValue;
import dev.cel.common.values.CelByteString;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.CelValueConverter;
import dev.cel.common.values.DurationValue;
import dev.cel.common.values.ImmutableListValue;
import dev.cel.common.values.ImmutableMapValue;
import dev.cel.common.values.ListValue;
import dev.cel.common.values.MapValue;
import dev.cel.common.values.NullValue;
import dev.cel.common.values.StringValue;
import dev.cel.common.values.TimestampValue;
import dev.cel.common.values.UintValue;
import java.util.Optional;

@Immutable
@Internal
public abstract class BaseProtoCelValueConverter
extends CelValueConverter {
    public abstract CelValue fromProtoMessageToCelValue(MessageLite var1);

    @Override
    public Object fromCelValueToJavaObject(CelValue celValue) {
        Preconditions.checkNotNull(celValue);
        if (celValue instanceof TimestampValue) {
            return ProtoTimeUtils.toProtoTimestamp(((TimestampValue)celValue).value());
        }
        if (celValue instanceof DurationValue) {
            return ProtoTimeUtils.toProtoDuration(((DurationValue)celValue).value());
        }
        if (celValue instanceof BytesValue) {
            return ByteString.copyFrom(((BytesValue)celValue).value().toByteArray());
        }
        if (celValue.equals(NullValue.NULL_VALUE)) {
            return com.google.protobuf.NullValue.NULL_VALUE;
        }
        return super.fromCelValueToJavaObject(celValue);
    }

    @Override
    public CelValue fromJavaObjectToCelValue(Object value) {
        Preconditions.checkNotNull(value);
        Optional<WellKnownProto> wellKnownProto = WellKnownProto.getByClass(value.getClass());
        if (wellKnownProto.isPresent()) {
            return this.fromWellKnownProtoToCelValue((MessageLiteOrBuilder)value, wellKnownProto.get());
        }
        if (value instanceof ByteString) {
            return BytesValue.create(CelByteString.of(((ByteString)value).toByteArray()));
        }
        if (value instanceof com.google.protobuf.NullValue) {
            return NullValue.NULL_VALUE;
        }
        return super.fromJavaObjectToCelValue(value);
    }

    protected CelValue fromWellKnownProtoToCelValue(MessageLiteOrBuilder message, WellKnownProto wellKnownProto) {
        switch (wellKnownProto) {
            case JSON_VALUE: {
                return this.adaptJsonValueToCelValue((Value)message);
            }
            case JSON_STRUCT_VALUE: {
                return this.adaptJsonStructToCelValue((Struct)message);
            }
            case JSON_LIST_VALUE: {
                return this.adaptJsonListToCelValue((com.google.protobuf.ListValue)message);
            }
            case DURATION: {
                return DurationValue.create(ProtoTimeUtils.toJavaDuration((Duration)message));
            }
            case TIMESTAMP: {
                return TimestampValue.create(ProtoTimeUtils.toJavaInstant((Timestamp)message));
            }
            case BOOL_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((BoolValue)message).getValue());
            }
            case BYTES_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((com.google.protobuf.BytesValue)message).getValue().toByteArray());
            }
            case DOUBLE_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((DoubleValue)message).getValue());
            }
            case FLOAT_VALUE: {
                return this.fromJavaPrimitiveToCelValue(Float.valueOf(((FloatValue)message).getValue()));
            }
            case INT32_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((Int32Value)message).getValue());
            }
            case INT64_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((Int64Value)message).getValue());
            }
            case STRING_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((com.google.protobuf.StringValue)message).getValue());
            }
            case UINT32_VALUE: {
                return UintValue.create(((UInt32Value)message).getValue());
            }
            case UINT64_VALUE: {
                return UintValue.create(((UInt64Value)message).getValue());
            }
        }
        throw new UnsupportedOperationException("Unsupported message to CelValue conversion - " + message);
    }

    private CelValue adaptJsonValueToCelValue(Value value) {
        switch (value.getKindCase()) {
            case BOOL_VALUE: {
                return this.fromJavaPrimitiveToCelValue(value.getBoolValue());
            }
            case NUMBER_VALUE: {
                return this.fromJavaPrimitiveToCelValue(value.getNumberValue());
            }
            case STRING_VALUE: {
                return this.fromJavaPrimitiveToCelValue(value.getStringValue());
            }
            case LIST_VALUE: {
                return this.adaptJsonListToCelValue(value.getListValue());
            }
            case STRUCT_VALUE: {
                return this.adaptJsonStructToCelValue(value.getStructValue());
            }
            case NULL_VALUE: 
            case KIND_NOT_SET: {
                return NullValue.NULL_VALUE;
            }
        }
        throw new UnsupportedOperationException("Unsupported Json to CelValue conversion: " + value.getKindCase());
    }

    private ListValue<CelValue> adaptJsonListToCelValue(com.google.protobuf.ListValue listValue) {
        return ImmutableListValue.create(listValue.getValuesList().stream().map(this::adaptJsonValueToCelValue).collect(ImmutableList.toImmutableList()));
    }

    private MapValue<StringValue, CelValue> adaptJsonStructToCelValue(Struct struct) {
        return ImmutableMapValue.create(struct.getFieldsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> {
            CelValue key = this.fromJavaObjectToCelValue(e.getKey());
            if (!(key instanceof StringValue)) {
                throw new IllegalStateException("Expected a string type for the key, but instead got: " + key);
            }
            return (StringValue)key;
        }, e -> this.adaptJsonValueToCelValue((Value)e.getValue()))));
    }

    protected BaseProtoCelValueConverter() {
    }
}

