/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.values.BoolValue;
import dev.cel.common.values.BytesValue;
import dev.cel.common.values.CelByteString;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.DoubleValue;
import dev.cel.common.values.ErrorValue;
import dev.cel.common.values.ImmutableListValue;
import dev.cel.common.values.ImmutableMapValue;
import dev.cel.common.values.IntValue;
import dev.cel.common.values.ListValue;
import dev.cel.common.values.MapValue;
import dev.cel.common.values.OpaqueValue;
import dev.cel.common.values.OptionalValue;
import dev.cel.common.values.StringValue;
import dev.cel.common.values.UintValue;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

@Immutable
@Internal
abstract class CelValueConverter {
    public Object fromCelValueToJavaObject(CelValue celValue) {
        Preconditions.checkNotNull(celValue);
        if (celValue instanceof MapValue) {
            MapValue mapValue = (MapValue)celValue;
            ImmutableMap.Builder<Object, Object> mapBuilder = ImmutableMap.builder();
            for (Map.Entry entry : mapValue.value().entrySet()) {
                Object key = this.fromCelValueToJavaObject((CelValue)entry.getKey());
                Object value = this.fromCelValueToJavaObject((CelValue)entry.getValue());
                mapBuilder.put(key, value);
            }
            return mapBuilder.buildOrThrow();
        }
        if (celValue instanceof ListValue) {
            ListValue listValue = (ListValue)celValue;
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            Iterator iterator2 = listValue.value().iterator();
            while (iterator2.hasNext()) {
                CelValue element = (CelValue)iterator2.next();
                listBuilder.add(this.fromCelValueToJavaObject(element));
            }
            return listBuilder.build();
        }
        if (celValue instanceof OptionalValue) {
            OptionalValue optionalValue = (OptionalValue)celValue;
            if (optionalValue.isZeroValue()) {
                return Optional.empty();
            }
            return Optional.of(this.fromCelValueToJavaObject((CelValue)optionalValue.value()));
        }
        return celValue.value();
    }

    public CelValue fromJavaObjectToCelValue(Object value) {
        Preconditions.checkNotNull(value);
        if (value instanceof CelValue) {
            return (CelValue)value;
        }
        if (value instanceof Iterable) {
            return this.toListValue((Iterable)value);
        }
        if (value instanceof Map) {
            return this.toMapValue((Map)value);
        }
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            return optionalValue.map(o -> OptionalValue.create(this.fromJavaObjectToCelValue(o))).orElse(OptionalValue.EMPTY);
        }
        if (value instanceof Exception) {
            return ErrorValue.create((Exception)value);
        }
        return this.fromJavaPrimitiveToCelValue(value);
    }

    protected CelValue fromJavaPrimitiveToCelValue(Object value) {
        Preconditions.checkNotNull(value);
        if (value instanceof Boolean) {
            return BoolValue.create((Boolean)value);
        }
        if (value instanceof Long) {
            return IntValue.create((Long)value);
        }
        if (value instanceof Integer) {
            return IntValue.create(((Integer)value).intValue());
        }
        if (value instanceof String) {
            return StringValue.create((String)value);
        }
        if (value instanceof byte[]) {
            return BytesValue.create(CelByteString.of((byte[])value));
        }
        if (value instanceof Double) {
            return DoubleValue.create((Double)value);
        }
        if (value instanceof Float) {
            return DoubleValue.create(((Float)value).floatValue());
        }
        if (value instanceof UnsignedLong) {
            return UintValue.create((UnsignedLong)value);
        }
        return OpaqueValue.create(value.toString(), value);
    }

    private ListValue<CelValue> toListValue(Iterable<Object> iterable) {
        Preconditions.checkNotNull(iterable);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Object entry : iterable) {
            listBuilder.add(this.fromJavaObjectToCelValue(entry));
        }
        return ImmutableListValue.create(listBuilder.build());
    }

    private MapValue<CelValue, CelValue> toMapValue(Map<Object, Object> map) {
        Preconditions.checkNotNull(map);
        ImmutableMap.Builder<CelValue, CelValue> mapBuilder = ImmutableMap.builder();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            CelValue mapKey = this.fromJavaObjectToCelValue(entry.getKey());
            CelValue mapValue = this.fromJavaObjectToCelValue(entry.getValue());
            mapBuilder.put(mapKey, mapValue);
        }
        return ImmutableMapValue.create(mapBuilder.buildOrThrow());
    }

    protected CelValueConverter() {
    }
}

