/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.MapValue;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

@Immutable(containerOf={"K", "V"})
public final class ImmutableMapValue<K extends CelValue, V extends CelValue>
extends MapValue<K, V> {
    private final Map<K, V> originalMap;
    private volatile ImmutableMap<K, V> cachedImmutableMap = null;

    public static <K extends CelValue, V extends CelValue> ImmutableMapValue<K, V> create(Map<K, V> value) {
        return new ImmutableMapValue<K, V>(value);
    }

    private ImmutableMapValue(Map<K, V> originalMap) {
        Preconditions.checkNotNull(originalMap);
        this.originalMap = originalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMap<K, V> value() {
        if (this.cachedImmutableMap == null) {
            ImmutableMapValue immutableMapValue = this;
            synchronized (immutableMapValue) {
                if (this.cachedImmutableMap == null) {
                    this.cachedImmutableMap = ImmutableMap.copyOf(this.originalMap);
                }
            }
        }
        return this.cachedImmutableMap;
    }

    @Override
    public int size() {
        return this.originalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.originalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.originalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object val) {
        return this.originalMap.containsValue(val);
    }

    @Override
    public int hashCode() {
        return this.originalMap.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.originalMap.equals(obj);
    }

    @Override
    public Set<K> keySet() {
        return ((ImmutableMap)this.value()).keySet();
    }

    @Override
    public Collection<V> values() {
        return ((ImmutableMap)this.value()).values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ((ImmutableMap)this.value()).entrySet();
    }
}

