/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.CelType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.values.CelValue;

@Immutable
public final class IntValue
extends CelValue {
    private final long value;

    @Override
    public Long value() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    @Override
    public boolean isZeroValue() {
        return this.value() == 0L;
    }

    @Override
    public CelType celType() {
        return SimpleType.INT;
    }

    public static IntValue create(long value) {
        return new IntValue(value);
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        return h2 ^= Long.hashCode(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntValue)) {
            return false;
        }
        return ((IntValue)o).value == this.value;
    }

    private IntValue(long value) {
        this.value = value;
    }
}

