/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.optimizer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dev.cel.bundle.Cel;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelValidationException;
import dev.cel.optimizer.CelAstOptimizer;
import dev.cel.optimizer.CelOptimizationException;
import dev.cel.optimizer.CelOptimizer;
import dev.cel.optimizer.CelOptimizerBuilder;
import java.util.Arrays;

final class CelOptimizerImpl
implements CelOptimizer {
    private final Cel cel;
    private final ImmutableSet<CelAstOptimizer> astOptimizers;

    CelOptimizerImpl(Cel cel, ImmutableSet<CelAstOptimizer> astOptimizers) {
        this.cel = cel;
        this.astOptimizers = astOptimizers;
    }

    @Override
    public CelAbstractSyntaxTree optimize(CelAbstractSyntaxTree ast) throws CelOptimizationException {
        if (!ast.isChecked()) {
            throw new IllegalArgumentException("AST must be type-checked.");
        }
        Cel celOptimizerEnv = this.cel;
        CelAbstractSyntaxTree optimizedAst = ast;
        try {
            for (CelAstOptimizer optimizer : this.astOptimizers) {
                CelAstOptimizer.OptimizationResult result = optimizer.optimize(optimizedAst, celOptimizerEnv);
                if (!result.newFunctionDecls().isEmpty() || !result.newVarDecls().isEmpty()) {
                    celOptimizerEnv = celOptimizerEnv.toCelBuilder().addVarDeclarations(result.newVarDecls()).addFunctionDeclarations(result.newFunctionDecls()).build();
                }
                optimizedAst = celOptimizerEnv.check(result.optimizedAst()).getAst();
            }
        }
        catch (CelValidationException e) {
            throw new CelOptimizationException("Optimized AST failed to type-check: " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new CelOptimizationException("Optimization failure: " + e.getMessage(), e);
        }
        return optimizedAst;
    }

    static Builder newBuilder(Cel cel) {
        return new Builder(cel);
    }

    static final class Builder
    implements CelOptimizerBuilder {
        private final Cel cel;
        private final ImmutableSet.Builder<CelAstOptimizer> astOptimizers;

        private Builder(Cel cel) {
            this.cel = cel;
            this.astOptimizers = ImmutableSet.builder();
        }

        @Override
        public CelOptimizerBuilder addAstOptimizers(CelAstOptimizer ... astOptimizers) {
            Preconditions.checkNotNull(astOptimizers);
            return this.addAstOptimizers(Arrays.asList(astOptimizers));
        }

        @Override
        public CelOptimizerBuilder addAstOptimizers(Iterable<CelAstOptimizer> astOptimizers) {
            Preconditions.checkNotNull(astOptimizers);
            this.astOptimizers.addAll((Iterable)astOptimizers);
            return this;
        }

        @Override
        public CelOptimizer build() {
            return new CelOptimizerImpl(this.cel, (ImmutableSet<CelAstOptimizer>)this.astOptimizers.build());
        }
    }
}

