/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelIssue;
import dev.cel.common.ast.CelExpr;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelMacroExprFactory;
import dev.cel.parser.Operator;
import java.util.Optional;

public enum CelStandardMacro {
    HAS(CelMacro.newGlobalMacro(Operator.HAS.getFunction(), 1, CelStandardMacro::expandHasMacro)),
    ALL(CelMacro.newReceiverMacro(Operator.ALL.getFunction(), 2, CelStandardMacro::expandAllMacro)),
    EXISTS(CelMacro.newReceiverMacro(Operator.EXISTS.getFunction(), 2, CelStandardMacro::expandExistsMacro)),
    EXISTS_ONE(CelMacro.newReceiverMacro(Operator.EXISTS_ONE.getFunction(), 2, CelStandardMacro::expandExistsOneMacro)),
    MAP(CelMacro.newReceiverMacro(Operator.MAP.getFunction(), 2, CelStandardMacro::expandMapMacro)),
    MAP_FILTER(CelMacro.newReceiverMacro(Operator.MAP.getFunction(), 3, CelStandardMacro::expandMapMacro)),
    FILTER(CelMacro.newReceiverMacro(Operator.FILTER.getFunction(), 2, CelStandardMacro::expandFilterMacro));

    public static final ImmutableSet<CelStandardMacro> STANDARD_MACROS;
    private final CelMacro macro;

    private CelStandardMacro(CelMacro macro) {
        this.macro = macro;
    }

    public String getFunction() {
        return this.macro.getFunction();
    }

    public CelMacro getDefinition() {
        return this.macro;
    }

    private static Optional<CelExpr> expandHasMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(arguments.size() == 1);
        CelExpr arg = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (arg.exprKind().getKind() != CelExpr.ExprKind.Kind.SELECT) {
            return Optional.of(exprFactory.reportError("invalid argument to has() macro"));
        }
        return Optional.of(exprFactory.newSelect(arg.select().operand(), arg.select().field(), true));
    }

    private static Optional<CelExpr> expandAllMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(arguments.size() == 2);
        CelExpr arg0 = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelStandardMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = Preconditions.checkNotNull((CelExpr)arguments.get(1));
        CelExpr accuInit = exprFactory.newBoolLiteral(true);
        CelExpr condition = exprFactory.newGlobalCall(Operator.NOT_STRICTLY_FALSE.getFunction(), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()));
        CelExpr step = exprFactory.newGlobalCall(Operator.LOGICAL_AND.getFunction(), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()), arg1);
        CelExpr result = exprFactory.newIdentifier(exprFactory.getAccumulatorVarName());
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, exprFactory.getAccumulatorVarName(), accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandExistsMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(arguments.size() == 2);
        CelExpr arg0 = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelStandardMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = Preconditions.checkNotNull((CelExpr)arguments.get(1));
        CelExpr accuInit = exprFactory.newBoolLiteral(false);
        CelExpr condition = exprFactory.newGlobalCall(Operator.NOT_STRICTLY_FALSE.getFunction(), exprFactory.newGlobalCall(Operator.LOGICAL_NOT.getFunction(), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName())));
        CelExpr step = exprFactory.newGlobalCall(Operator.LOGICAL_OR.getFunction(), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()), arg1);
        CelExpr result = exprFactory.newIdentifier(exprFactory.getAccumulatorVarName());
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, exprFactory.getAccumulatorVarName(), accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandExistsOneMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(arguments.size() == 2);
        CelExpr arg0 = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelStandardMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = Preconditions.checkNotNull((CelExpr)arguments.get(1));
        CelExpr accuInit = exprFactory.newIntLiteral(0L);
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg1, exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()), exprFactory.newIntLiteral(1L)), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()));
        CelExpr result = exprFactory.newGlobalCall(Operator.EQUALS.getFunction(), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()), exprFactory.newIntLiteral(1L));
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, exprFactory.getAccumulatorVarName(), accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandMapMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        CelExpr arg1;
        CelExpr arg2;
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(arguments.size() == 2 || arguments.size() == 3);
        CelExpr arg0 = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(arg0), "argument is not an identifier")));
        }
        if (arguments.size() == 3) {
            arg2 = Preconditions.checkNotNull((CelExpr)arguments.get(1));
            arg1 = Preconditions.checkNotNull((CelExpr)arguments.get(2));
        } else {
            arg1 = Preconditions.checkNotNull((CelExpr)arguments.get(1));
            arg2 = null;
        }
        CelExpr accuInit = exprFactory.newList(new CelExpr[0]);
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()), exprFactory.newList(arg1));
        if (arg2 != null) {
            step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg2, step, exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()));
        }
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, exprFactory.getAccumulatorVarName(), accuInit, condition, step, exprFactory.newIdentifier(exprFactory.getAccumulatorVarName())));
    }

    private static Optional<CelExpr> expandFilterMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull(exprFactory);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(arguments.size() == 2);
        CelExpr arg0 = Preconditions.checkNotNull((CelExpr)arguments.get(0));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelStandardMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = Preconditions.checkNotNull((CelExpr)arguments.get(1));
        CelExpr accuInit = exprFactory.newList(new CelExpr[0]);
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()), exprFactory.newList(arg0));
        step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg1, step, exprFactory.newIdentifier(exprFactory.getAccumulatorVarName()));
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, exprFactory.getAccumulatorVarName(), accuInit, condition, step, exprFactory.newIdentifier(exprFactory.getAccumulatorVarName())));
    }

    private static CelExpr reportArgumentError(CelMacroExprFactory exprFactory, CelExpr argument) {
        return exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(argument), "The argument must be a simple name"));
    }

    static {
        STANDARD_MACROS = ImmutableSet.of(HAS, ALL, EXISTS, EXISTS_ONE, MAP, MAP_FILTER, new CelStandardMacro[]{FILTER});
    }
}

