/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.policy;

import com.google.common.collect.ImmutableMap;
import dev.cel.common.internal.CelCodePointArray;
import dev.cel.policy.CelPolicySource;
import java.util.Map;

final class AutoValue_CelPolicySource
extends CelPolicySource {
    private final CelCodePointArray content;
    private final String description;
    private final ImmutableMap<Long, Integer> positionsMap;

    private AutoValue_CelPolicySource(CelCodePointArray content, String description, ImmutableMap<Long, Integer> positionsMap) {
        this.content = content;
        this.description = description;
        this.positionsMap = positionsMap;
    }

    @Override
    public CelCodePointArray getContent() {
        return this.content;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ImmutableMap<Long, Integer> getPositionsMap() {
        return this.positionsMap;
    }

    public String toString() {
        return "CelPolicySource{content=" + this.content + ", description=" + this.description + ", positionsMap=" + this.positionsMap + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CelPolicySource) {
            CelPolicySource that = (CelPolicySource)o;
            return this.content.equals(that.getContent()) && this.description.equals(that.getDescription()) && this.positionsMap.equals(that.getPositionsMap());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.content.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        return h$ ^= this.positionsMap.hashCode();
    }

    @Override
    public CelPolicySource.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CelPolicySource.Builder {
        private CelCodePointArray content;
        private String description;
        private ImmutableMap<Long, Integer> positionsMap;

        Builder() {
        }

        Builder(CelPolicySource source2) {
            this.content = source2.getContent();
            this.description = source2.getDescription();
            this.positionsMap = source2.getPositionsMap();
        }

        @Override
        public CelPolicySource.Builder setContent(CelCodePointArray content) {
            if (content == null) {
                throw new NullPointerException("Null content");
            }
            this.content = content;
            return this;
        }

        @Override
        public CelPolicySource.Builder setDescription(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public CelPolicySource.Builder setPositionsMap(Map<Long, Integer> positionsMap) {
            this.positionsMap = ImmutableMap.copyOf(positionsMap);
            return this;
        }

        @Override
        public CelPolicySource build() {
            if (this.content == null || this.description == null || this.positionsMap == null) {
                StringBuilder missing = new StringBuilder();
                if (this.content == null) {
                    missing.append(" content");
                }
                if (this.description == null) {
                    missing.append(" description");
                }
                if (this.positionsMap == null) {
                    missing.append(" positionsMap");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CelPolicySource(this.content, this.description, this.positionsMap);
        }
    }
}

