/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.policy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.bundle.Cel;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSource;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.CelValidationException;
import dev.cel.common.CelValidationResult;
import dev.cel.common.CelVarDecl;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.formats.ValueString;
import dev.cel.common.types.CelType;
import dev.cel.common.types.SimpleType;
import dev.cel.optimizer.CelOptimizationException;
import dev.cel.optimizer.CelOptimizer;
import dev.cel.optimizer.CelOptimizerFactory;
import dev.cel.policy.CelCompiledRule;
import dev.cel.policy.CelPolicy;
import dev.cel.policy.CelPolicyCompiler;
import dev.cel.policy.CelPolicyCompilerBuilder;
import dev.cel.policy.CelPolicySource;
import dev.cel.policy.CelPolicyValidationException;
import dev.cel.policy.RuleComposer;
import dev.cel.validator.CelAstValidator;
import dev.cel.validator.CelValidator;
import dev.cel.validator.CelValidatorFactory;
import dev.cel.validator.validators.AstDepthLimitValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

final class CelPolicyCompilerImpl
implements CelPolicyCompiler {
    private static final String DEFAULT_VARIABLE_PREFIX = "variables.";
    private static final int DEFAULT_ITERATION_LIMIT = 1000;
    private final Cel cel;
    private final String variablesPrefix;
    private final int iterationLimit;
    private final Optional<CelAstValidator> astDepthValidator;

    @Override
    public CelCompiledRule compileRule(CelPolicy policy) throws CelPolicyValidationException {
        CompilerContext compilerContext = new CompilerContext(policy.policySource());
        CelCompiledRule compiledRule = this.compileRuleImpl(policy.rule(), this.cel, compilerContext);
        if (compilerContext.hasError()) {
            throw new CelPolicyValidationException(compilerContext.getIssueString());
        }
        return compiledRule;
    }

    @Override
    public CelAbstractSyntaxTree compose(CelPolicy policy, CelCompiledRule compiledRule) throws CelPolicyValidationException {
        CelAbstractSyntaxTree ast;
        Cel cel = compiledRule.cel();
        CelOptimizer optimizer = CelOptimizerFactory.standardCelOptimizerBuilder(cel).addAstOptimizers(RuleComposer.newInstance(compiledRule, this.variablesPrefix, this.iterationLimit)).build();
        try {
            ast = cel.compile("true").getAst();
            ast = optimizer.optimize(ast);
        }
        catch (CelValidationException | CelOptimizationException e) {
            if (e.getCause() instanceof RuleComposer.RuleCompositionException) {
                RuleComposer.RuleCompositionException re = (RuleComposer.RuleCompositionException)e.getCause();
                CompilerContext compilerContext = new CompilerContext(policy.policySource());
                ImmutableList transformedIssues = re.compileException.getErrors().stream().map(x -> CelIssue.formatError(x.getSourceLocation(), re.failureReason)).collect(ImmutableList.toImmutableList());
                for (long id : re.errorIds) {
                    compilerContext.addIssue(id, transformedIssues);
                }
                throw new CelPolicyValidationException(compilerContext.getIssueString(), re.getCause());
            }
            throw new CelPolicyValidationException("Unexpected error while composing rules.", e);
        }
        this.assertAstDepthIsSafe(ast, cel);
        return ast;
    }

    private void assertAstDepthIsSafe(CelAbstractSyntaxTree ast, Cel cel) throws CelPolicyValidationException {
        if (!this.astDepthValidator.isPresent()) {
            return;
        }
        CelValidator celValidator = CelValidatorFactory.standardCelValidatorBuilder(cel).addAstValidators(this.astDepthValidator.get()).build();
        CelValidationResult result = celValidator.validate(ast);
        if (result.hasError()) {
            throw new CelPolicyValidationException(result.getErrorString());
        }
    }

    private CelCompiledRule compileRuleImpl(CelPolicy.Rule rule, Cel ruleCel, CompilerContext compilerContext) {
        ImmutableList.Builder variableBuilder = ImmutableList.builder();
        for (CelPolicy.Variable variable : rule.variables()) {
            CelAbstractSyntaxTree varAst;
            ValueString expression = variable.expression();
            CelType outputType = SimpleType.DYN;
            try {
                varAst = ruleCel.compile(expression.value()).getAst();
                outputType = varAst.getResultType();
            }
            catch (CelValidationException e) {
                compilerContext.addIssue(expression.id(), e.getErrors());
                varAst = CelPolicyCompilerImpl.newErrorAst();
            }
            String variableName = variable.name().value();
            CelVarDecl newVariable = CelVarDecl.newVarDeclaration(this.variablesPrefix + variableName, outputType);
            ruleCel = ruleCel.toCelBuilder().addVarDeclarations(newVariable).build();
            variableBuilder.add(CelCompiledRule.CelCompiledVariable.create(variableName, varAst, newVariable));
        }
        ImmutableList.Builder matchBuilder = ImmutableList.builder();
        block11: for (CelPolicy.Match match : rule.matches()) {
            CelCompiledRule.CelCompiledMatch.Result matchResult;
            CelAbstractSyntaxTree conditionAst;
            block12: {
                try {
                    conditionAst = ruleCel.compile(match.condition().value()).getAst();
                    if (conditionAst.getResultType().equals(SimpleType.BOOL)) break block12;
                    compilerContext.addIssue(match.condition().id(), new CelIssue[]{CelIssue.formatError(1, 0, "condition must produce a boolean output.")});
                }
                catch (CelValidationException e) {
                    compilerContext.addIssue(match.condition().id(), e.getErrors());
                    continue;
                }
            }
            switch (match.result().kind()) {
                case OUTPUT: {
                    CelAbstractSyntaxTree outputAst;
                    ValueString output = match.result().output();
                    try {
                        outputAst = ruleCel.compile(output.value()).getAst();
                    }
                    catch (CelValidationException e) {
                        compilerContext.addIssue(output.id(), e.getErrors());
                        continue block11;
                    }
                    matchResult = CelCompiledRule.CelCompiledMatch.Result.ofOutput(output.id(), outputAst);
                    break;
                }
                case RULE: {
                    CelCompiledRule nestedRule = this.compileRuleImpl(match.result().rule(), ruleCel, compilerContext);
                    matchResult = CelCompiledRule.CelCompiledMatch.Result.ofRule(nestedRule);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected kind: " + (Object)((Object)match.result().kind()));
                }
            }
            matchBuilder.add(CelCompiledRule.CelCompiledMatch.create(match.id(), conditionAst, matchResult));
        }
        CelCompiledRule celCompiledRule = CelCompiledRule.create(rule.id(), rule.ruleId(), (ImmutableList<CelCompiledRule.CelCompiledVariable>)variableBuilder.build(), (ImmutableList<CelCompiledRule.CelCompiledMatch>)matchBuilder.build(), this.cel);
        this.checkUnreachableCode(celCompiledRule, compilerContext);
        return celCompiledRule;
    }

    private void checkUnreachableCode(CelCompiledRule compiledRule, CompilerContext compilerContext) {
        boolean ruleHasOptional = compiledRule.hasOptionalOutput();
        ImmutableList<CelCompiledRule.CelCompiledMatch> compiledMatches = compiledRule.matches();
        int matchCount = compiledMatches.size();
        for (int i = matchCount - 1; i >= 0; --i) {
            CelCompiledRule.CelCompiledMatch compiledMatch = (CelCompiledRule.CelCompiledMatch)compiledMatches.get(i);
            boolean isTriviallyTrue = compiledMatch.isConditionTriviallyTrue();
            if (!isTriviallyTrue || ruleHasOptional || i == matchCount - 1) continue;
            if (compiledMatch.result().kind().equals((Object)CelCompiledRule.CelCompiledMatch.Result.Kind.OUTPUT)) {
                compilerContext.addIssue(compiledMatch.sourceId(), new CelIssue[]{CelIssue.formatError(1, 0, "Match creates unreachable outputs")});
                continue;
            }
            compilerContext.addIssue(compiledMatch.result().rule().sourceId(), new CelIssue[]{CelIssue.formatError(1, 0, "Rule creates unreachable outputs")});
        }
    }

    private static CelAbstractSyntaxTree newErrorAst() {
        return CelAbstractSyntaxTree.newParsedAst(CelExpr.ofConstant(0L, CelConstant.ofValue("*error*")), CelSource.newBuilder().build());
    }

    static Builder newBuilder(Cel cel) {
        return new Builder(cel).setVariablesPrefix(DEFAULT_VARIABLE_PREFIX).setIterationLimit(1000);
    }

    private CelPolicyCompilerImpl(Cel cel, String variablesPrefix, int iterationLimit, Optional<CelAstValidator> astDepthValidator) {
        this.cel = Preconditions.checkNotNull(cel);
        this.variablesPrefix = Preconditions.checkNotNull(variablesPrefix);
        this.iterationLimit = iterationLimit;
        this.astDepthValidator = astDepthValidator;
    }

    private static final class CompilerContext {
        private final ArrayList<CelIssue> issues = new ArrayList();
        private final CelPolicySource celPolicySource;

        private void addIssue(long id, CelIssue ... issues) {
            this.addIssue(id, Arrays.asList(issues));
        }

        private void addIssue(long id, List<CelIssue> issues) {
            for (CelIssue issue : issues) {
                CelSourceLocation absoluteLocation = this.computeAbsoluteLocation(id, issue);
                this.issues.add(CelIssue.formatError(absoluteLocation, issue.getMessage()));
            }
        }

        private CelSourceLocation computeAbsoluteLocation(long id, CelIssue issue) {
            int policySourceOffset = Optional.ofNullable(this.celPolicySource.getPositionsMap().get(id)).orElse(-1);
            if (policySourceOffset == -1) {
                return CelSourceLocation.NONE;
            }
            CelSourceLocation policySourceLocation = this.celPolicySource.getOffsetLocation(policySourceOffset).orElse(null);
            if (policySourceLocation == null) {
                return CelSourceLocation.NONE;
            }
            int absoluteLine = issue.getSourceLocation().getLine() + policySourceLocation.getLine() - 1;
            int absoluteColumn = issue.getSourceLocation().getColumn() + policySourceLocation.getColumn();
            int absoluteOffset = (Integer)this.celPolicySource.getContent().lineOffsets().get(absoluteLine - 2);
            return this.celPolicySource.getOffsetLocation(absoluteOffset + absoluteColumn).orElse(CelSourceLocation.NONE);
        }

        private boolean hasError() {
            return !this.issues.isEmpty();
        }

        private String getIssueString() {
            return CelIssue.toDisplayString(this.issues, this.celPolicySource);
        }

        private CompilerContext(CelPolicySource celPolicySource) {
            this.celPolicySource = celPolicySource;
        }
    }

    static final class Builder
    implements CelPolicyCompilerBuilder {
        private final Cel cel;
        private String variablesPrefix;
        private int iterationLimit;
        private Optional<CelAstValidator> astDepthLimitValidator;

        private Builder(Cel cel) {
            this.cel = cel;
            this.astDepthLimitValidator = Optional.of(AstDepthLimitValidator.DEFAULT);
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setVariablesPrefix(String prefix) {
            this.variablesPrefix = Preconditions.checkNotNull(prefix);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setIterationLimit(int iterationLimit) {
            this.iterationLimit = iterationLimit;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public CelPolicyCompilerBuilder setAstDepthLimit(int astDepthLimit) {
            this.astDepthLimitValidator = astDepthLimit < 0 ? Optional.empty() : Optional.of(AstDepthLimitValidator.newInstance(astDepthLimit));
            return this;
        }

        @Override
        public CelPolicyCompiler build() {
            return new CelPolicyCompilerImpl(this.cel, this.variablesPrefix, this.iterationLimit, this.astDepthLimitValidator);
        }
    }
}

