/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import dev.cel.common.annotations.Internal;
import dev.cel.runtime.GlobalResolver;
import dev.cel.runtime.RuntimeHelpers;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@Internal
public abstract class Activation
implements GlobalResolver {
    public static final Activation EMPTY = new Activation(){

        @Override
        public @Nullable Object resolve(String name) {
            return GlobalResolver.EMPTY.resolve(name);
        }

        public String toString() {
            return GlobalResolver.EMPTY.toString();
        }
    };

    @Override
    public abstract @Nullable Object resolve(String var1);

    public static Activation of(final String name, final Object value) {
        return new Activation(){

            @Override
            public @Nullable Object resolve(String theName) {
                if (theName.equals(name)) {
                    return RuntimeHelpers.maybeAdaptPrimitive(value);
                }
                return null;
            }

            public String toString() {
                if (value instanceof ByteString) {
                    ByteString bs = (ByteString)value;
                    StringBuilder val = new StringBuilder();
                    val.append("[");
                    ByteString.ByteIterator i = bs.iterator();
                    while (i.hasNext()) {
                        byte b = i.nextByte();
                        val.append(b);
                        if (!i.hasNext()) continue;
                        val.append(", ");
                    }
                    val.append("]");
                    return String.format("{%s=%s}", name, val);
                }
                return String.format("{%s=%s}", name, value);
            }
        };
    }

    public static Activation of(final String name, final Supplier<?> supplier) {
        return new Activation(){

            @Override
            public @Nullable Object resolve(String theName) {
                if (theName.equals(name)) {
                    return RuntimeHelpers.maybeAdaptPrimitive(supplier.get());
                }
                return null;
            }

            public String toString() {
                return String.format("{%s=%s}", name, supplier.get());
            }
        };
    }

    public static Activation copyOf(Map<String, ?> map) {
        final ImmutableMap<String, Object> copy = map instanceof ImmutableMap ? (ImmutableMap<String, Object>)map : map.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return new Activation(){

            @Override
            public @Nullable Object resolve(String name) {
                return RuntimeHelpers.maybeAdaptPrimitive(copy.get(name));
            }

            public String toString() {
                return copy.toString();
            }
        };
    }

    public Activation extend(final Activation activation) {
        final Activation outer = this;
        return new Activation(){

            @Override
            public @Nullable Object resolve(String name) {
                Object value = activation.resolve(name);
                return value != null ? value : outer.resolve(name);
            }

            public String toString() {
                return activation + " +> " + outer;
            }
        };
    }
}

