/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelDescriptorUtil;
import dev.cel.common.CelDescriptors;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.internal.CombinedDescriptorPool;
import dev.cel.common.internal.DefaultDescriptorPool;
import dev.cel.common.internal.DefaultMessageFactory;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoMessageFactory;
import dev.cel.common.types.CelTypes;
import dev.cel.common.values.CelValueProvider;
import dev.cel.common.values.ProtoMessageValueProvider;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.CelInternalRuntimeLibrary;
import dev.cel.runtime.CelRuntime;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.CelRuntimeLibrary;
import dev.cel.runtime.CelStandardFunctions;
import dev.cel.runtime.CelValueRuntimeTypeProvider;
import dev.cel.runtime.DefaultDispatcher;
import dev.cel.runtime.DefaultInterpreter;
import dev.cel.runtime.DescriptorMessageProvider;
import dev.cel.runtime.DescriptorTypeResolver;
import dev.cel.runtime.Interpreter;
import dev.cel.runtime.ProgramImpl;
import dev.cel.runtime.ProtoMessageRuntimeEquality;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeTypeProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.jspecify.annotations.Nullable;

@ThreadSafe
@Internal
public final class CelRuntimeLegacyImpl
implements CelRuntime {
    private final Interpreter interpreter;
    private final CelOptions options;
    private final boolean standardEnvironmentEnabled;
    private final ExtensionRegistry extensionRegistry;
    private final Function<String, Message.Builder> customTypeFactory;
    private final CelStandardFunctions overriddenStandardFunctions;
    private final CelValueProvider celValueProvider;
    private final ImmutableSet<Descriptors.FileDescriptor> fileDescriptors;
    private final ImmutableSet<CelRuntimeLibrary> celRuntimeLibraries;
    private final ImmutableList<CelFunctionBinding> celFunctionBindings;

    @Override
    public CelRuntime.Program createProgram(CelAbstractSyntaxTree ast) {
        Preconditions.checkState(ast.isChecked(), "programs must be created from checked expressions");
        return ProgramImpl.from(this.interpreter.createInterpretable(ast), this.options);
    }

    @Override
    public CelRuntimeBuilder toRuntimeBuilder() {
        CelRuntimeBuilder builder = new Builder().setOptions(this.options).setStandardEnvironmentEnabled(this.standardEnvironmentEnabled).setExtensionRegistry(this.extensionRegistry).addFileTypes(this.fileDescriptors).addLibraries(this.celRuntimeLibraries).addFunctionBindings(this.celFunctionBindings);
        if (this.customTypeFactory != null) {
            builder.setTypeFactory(this.customTypeFactory);
        }
        if (this.overriddenStandardFunctions != null) {
            builder.setStandardFunctions(this.overriddenStandardFunctions);
        }
        if (this.celValueProvider != null) {
            builder.setValueProvider(this.celValueProvider);
        }
        return builder;
    }

    public static CelRuntimeBuilder newBuilder() {
        return new Builder();
    }

    private CelRuntimeLegacyImpl(Interpreter interpreter, CelOptions options, boolean standardEnvironmentEnabled, ExtensionRegistry extensionRegistry, @Nullable Function<String, Message.Builder> customTypeFactory, @Nullable CelStandardFunctions overriddenStandardFunctions, @Nullable CelValueProvider celValueProvider, ImmutableSet<Descriptors.FileDescriptor> fileDescriptors, ImmutableSet<CelRuntimeLibrary> celRuntimeLibraries, ImmutableList<CelFunctionBinding> celFunctionBindings) {
        this.interpreter = interpreter;
        this.options = options;
        this.standardEnvironmentEnabled = standardEnvironmentEnabled;
        this.extensionRegistry = extensionRegistry;
        this.customTypeFactory = customTypeFactory;
        this.overriddenStandardFunctions = overriddenStandardFunctions;
        this.celValueProvider = celValueProvider;
        this.fileDescriptors = fileDescriptors;
        this.celRuntimeLibraries = celRuntimeLibraries;
        this.celFunctionBindings = celFunctionBindings;
    }

    public static final class Builder
    implements CelRuntimeBuilder {
        @VisibleForTesting
        final ImmutableSet.Builder<Descriptors.FileDescriptor> fileTypes;
        @VisibleForTesting
        final HashMap<String, CelFunctionBinding> customFunctionBindings;
        @VisibleForTesting
        final ImmutableSet.Builder<CelRuntimeLibrary> celRuntimeLibraries;
        @VisibleForTesting
        Function<String, Message.Builder> customTypeFactory = null;
        @VisibleForTesting
        CelValueProvider celValueProvider;
        @VisibleForTesting
        CelStandardFunctions overriddenStandardFunctions;
        private CelOptions options = CelOptions.newBuilder().build();
        private ExtensionRegistry extensionRegistry;
        private boolean standardEnvironmentEnabled;

        @Override
        public CelRuntimeBuilder setOptions(CelOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public CelRuntimeBuilder addFunctionBindings(CelFunctionBinding ... bindings) {
            return this.addFunctionBindings(Arrays.asList(bindings));
        }

        @Override
        public CelRuntimeBuilder addFunctionBindings(Iterable<CelFunctionBinding> bindings) {
            bindings.forEach(o -> this.customFunctionBindings.putIfAbsent(o.getOverloadId(), (CelFunctionBinding)o));
            return this;
        }

        @Override
        public CelRuntimeBuilder addMessageTypes(Descriptors.Descriptor ... descriptors) {
            return this.addMessageTypes(Arrays.asList(descriptors));
        }

        @Override
        public CelRuntimeBuilder addMessageTypes(Iterable<Descriptors.Descriptor> descriptors) {
            return this.addFileTypes(CelDescriptorUtil.getFileDescriptorsForDescriptors(descriptors));
        }

        @Override
        public CelRuntimeBuilder addFileTypes(Descriptors.FileDescriptor ... fileDescriptors) {
            return this.addFileTypes(Arrays.asList(fileDescriptors));
        }

        @Override
        public CelRuntimeBuilder addFileTypes(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
            this.fileTypes.addAll((Iterable)Preconditions.checkNotNull(fileDescriptors));
            return this;
        }

        @Override
        public CelRuntimeBuilder addFileTypes(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
            return this.addFileTypes(CelDescriptorUtil.getFileDescriptorsFromFileDescriptorSet(fileDescriptorSet));
        }

        @Override
        public CelRuntimeBuilder setTypeFactory(Function<String, Message.Builder> typeFactory) {
            this.customTypeFactory = typeFactory;
            return this;
        }

        @Override
        public CelRuntimeBuilder setValueProvider(CelValueProvider celValueProvider) {
            this.celValueProvider = celValueProvider;
            return this;
        }

        @Override
        public CelRuntimeBuilder setStandardEnvironmentEnabled(boolean value) {
            this.standardEnvironmentEnabled = value;
            return this;
        }

        @Override
        public CelRuntimeBuilder setStandardFunctions(CelStandardFunctions standardFunctions) {
            this.overriddenStandardFunctions = standardFunctions;
            return this;
        }

        @Override
        public CelRuntimeBuilder addLibraries(CelRuntimeLibrary ... libraries) {
            Preconditions.checkNotNull(libraries);
            return this.addLibraries(Arrays.asList(libraries));
        }

        @Override
        public CelRuntimeBuilder addLibraries(Iterable<? extends CelRuntimeLibrary> libraries) {
            Preconditions.checkNotNull(libraries);
            this.celRuntimeLibraries.addAll(libraries);
            return this;
        }

        @Override
        public CelRuntimeBuilder setExtensionRegistry(ExtensionRegistry extensionRegistry) {
            Preconditions.checkNotNull(extensionRegistry);
            this.extensionRegistry = extensionRegistry.getUnmodifiable();
            return this;
        }

        @Override
        public CelRuntimeLegacyImpl build() {
            RuntimeTypeProvider runtimeTypeProvider;
            if (this.standardEnvironmentEnabled && this.overriddenStandardFunctions != null) {
                throw new IllegalArgumentException("setStandardEnvironmentEnabled must be set to false to override standard function bindings.");
            }
            ImmutableCollection fileDescriptors = this.fileTypes.build();
            CelDescriptors celDescriptors = CelDescriptorUtil.getAllDescriptorsFromFileDescriptor(fileDescriptors, this.options.resolveTypeDependencies());
            CelDescriptorPool celDescriptorPool = Builder.newDescriptorPool(celDescriptors, this.extensionRegistry);
            ProtoMessageFactory runtimeTypeFactory = this.customTypeFactory != null ? messageName -> CelTypes.isWellKnownType(messageName) ? Optional.empty() : Optional.ofNullable(this.customTypeFactory.apply(messageName)) : null;
            runtimeTypeFactory = Builder.maybeCombineMessageFactory(runtimeTypeFactory, DefaultMessageFactory.create(celDescriptorPool));
            DynamicProto dynamicProto = DynamicProto.create(runtimeTypeFactory);
            ProtoMessageRuntimeEquality runtimeEquality = ProtoMessageRuntimeEquality.create(dynamicProto, this.options);
            ImmutableCollection runtimeLibraries = this.celRuntimeLibraries.build();
            for (Object celLibrary : runtimeLibraries) {
                if (celLibrary instanceof CelInternalRuntimeLibrary) {
                    ((CelInternalRuntimeLibrary)celLibrary).setRuntimeOptions(this, runtimeEquality, this.options);
                    continue;
                }
                celLibrary.setRuntimeOptions(this);
            }
            ImmutableMap.Builder<String, CelFunctionBinding> functionBindingsBuilder = ImmutableMap.builder();
            for (CelFunctionBinding standardFunctionBinding : this.newStandardFunctionBindings(runtimeEquality)) {
                functionBindingsBuilder.put(standardFunctionBinding.getOverloadId(), standardFunctionBinding);
            }
            functionBindingsBuilder.putAll(this.customFunctionBindings);
            DefaultDispatcher dispatcher = DefaultDispatcher.create();
            functionBindingsBuilder.buildOrThrow().forEach((overloadId, func) -> dispatcher.add((String)overloadId, (List<Class<?>>)func.getArgTypes(), args -> func.getDefinition().apply(args)));
            if (this.options.enableCelValue()) {
                CelValueProvider messageValueProvider = this.celValueProvider;
                if (messageValueProvider == null) {
                    messageValueProvider = ProtoMessageValueProvider.newInstance(dynamicProto);
                }
                runtimeTypeProvider = CelValueRuntimeTypeProvider.newInstance(messageValueProvider);
            } else {
                runtimeTypeProvider = new DescriptorMessageProvider(runtimeTypeFactory, this.options);
            }
            DefaultInterpreter interpreter = new DefaultInterpreter(DescriptorTypeResolver.create(), runtimeTypeProvider, dispatcher.immutableCopy(), this.options);
            return new CelRuntimeLegacyImpl(interpreter, this.options, this.standardEnvironmentEnabled, this.extensionRegistry, this.customTypeFactory, this.overriddenStandardFunctions, this.celValueProvider, (ImmutableSet)fileDescriptors, (ImmutableSet)runtimeLibraries, ImmutableList.copyOf(this.customFunctionBindings.values()));
        }

        private ImmutableSet<CelFunctionBinding> newStandardFunctionBindings(RuntimeEquality runtimeEquality) {
            CelStandardFunctions celStandardFunctions;
            if (this.standardEnvironmentEnabled) {
                celStandardFunctions = CelStandardFunctions.newBuilder().filterFunctions((standardFunction, standardOverload) -> {
                    switch (standardFunction) {
                        case INT: {
                            if (!standardOverload.equals(CelStandardFunctions.StandardFunction.Overload.Conversions.INT64_TO_INT64)) break;
                            return this.options.enableUnsignedLongs();
                        }
                        case TIMESTAMP: {
                            if (!standardOverload.equals(CelStandardFunctions.StandardFunction.Overload.Conversions.INT64_TO_TIMESTAMP)) break;
                            return this.options.enableTimestampEpoch();
                        }
                        case STRING: {
                            return this.options.enableStringConversion();
                        }
                        case ADD: {
                            CelStandardFunctions.StandardFunction.Overload.Arithmetic arithmetic = (CelStandardFunctions.StandardFunction.Overload.Arithmetic)standardOverload;
                            if (arithmetic.equals(CelStandardFunctions.StandardFunction.Overload.Arithmetic.ADD_STRING)) {
                                return this.options.enableStringConcatenation();
                            }
                            if (!arithmetic.equals(CelStandardFunctions.StandardFunction.Overload.Arithmetic.ADD_LIST)) break;
                            return this.options.enableListConcatenation();
                        }
                        default: {
                            if (!(standardOverload instanceof CelStandardFunctions.StandardFunction.Overload.Comparison) || this.options.enableHeterogeneousNumericComparisons()) break;
                            CelStandardFunctions.StandardFunction.Overload.Comparison comparison = (CelStandardFunctions.StandardFunction.Overload.Comparison)standardOverload;
                            return !comparison.isHeterogeneousComparison();
                        }
                    }
                    return true;
                }).build();
            } else if (this.overriddenStandardFunctions != null) {
                celStandardFunctions = this.overriddenStandardFunctions;
            } else {
                return ImmutableSet.of();
            }
            return celStandardFunctions.newFunctionBindings(runtimeEquality, this.options);
        }

        private static CelDescriptorPool newDescriptorPool(CelDescriptors celDescriptors, ExtensionRegistry extensionRegistry) {
            ImmutableList.Builder descriptorPools = new ImmutableList.Builder();
            descriptorPools.add(DefaultDescriptorPool.create(celDescriptors, extensionRegistry));
            return CombinedDescriptorPool.create((ImmutableList<CelDescriptorPool>)descriptorPools.build());
        }

        @CanIgnoreReturnValue
        private static ProtoMessageFactory maybeCombineMessageFactory(@Nullable ProtoMessageFactory parentFactory, ProtoMessageFactory childFactory) {
            if (parentFactory == null) {
                return childFactory;
            }
            return new ProtoMessageFactory.CombinedMessageFactory(ImmutableList.of(parentFactory, childFactory));
        }

        private Builder() {
            this.fileTypes = ImmutableSet.builder();
            this.customFunctionBindings = new HashMap();
            this.celRuntimeLibraries = ImmutableSet.builder();
            this.extensionRegistry = ExtensionRegistry.getEmptyRegistry();
        }
    }
}

