/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelReference;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.TypeType;
import dev.cel.runtime.AutoValue_DefaultInterpreter_IntermediateResult;
import dev.cel.runtime.CallArgumentChecker;
import dev.cel.runtime.CelAttribute;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelEvaluationExceptionBuilder;
import dev.cel.runtime.CelEvaluationListener;
import dev.cel.runtime.CelUnknownSet;
import dev.cel.runtime.DefaultMetadata;
import dev.cel.runtime.Dispatcher;
import dev.cel.runtime.FunctionResolver;
import dev.cel.runtime.GlobalResolver;
import dev.cel.runtime.Interpretable;
import dev.cel.runtime.Interpreter;
import dev.cel.runtime.InterpreterUtil;
import dev.cel.runtime.Metadata;
import dev.cel.runtime.ResolvedOverload;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.RuntimeTypeProvider;
import dev.cel.runtime.RuntimeUnknownResolver;
import dev.cel.runtime.TypeResolver;
import dev.cel.runtime.UnknownTrackingInterpretable;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultInterpreter
implements Interpreter {
    private final TypeResolver typeResolver;
    private final RuntimeTypeProvider typeProvider;
    private final Dispatcher dispatcher;
    private final CelOptions celOptions;

    public DefaultInterpreter(TypeResolver typeResolver, RuntimeTypeProvider typeProvider, Dispatcher dispatcher, CelOptions celOptions) {
        this.typeResolver = Preconditions.checkNotNull(typeResolver);
        this.typeProvider = Preconditions.checkNotNull(typeProvider);
        this.dispatcher = Preconditions.checkNotNull(dispatcher);
        this.celOptions = Preconditions.checkNotNull(celOptions);
    }

    @Override
    public Interpretable createInterpretable(CelAbstractSyntaxTree ast) {
        return new DefaultInterpretable(this.typeResolver, this.typeProvider, this.dispatcher, ast, this.celOptions);
    }

    @Immutable
    @VisibleForTesting
    static final class DefaultInterpretable
    implements Interpretable,
    UnknownTrackingInterpretable {
        private final TypeResolver typeResolver;
        private final RuntimeTypeProvider typeProvider;
        private final Dispatcher.ImmutableCopy dispatcher;
        private final Metadata metadata;
        private final CelAbstractSyntaxTree ast;
        private final CelOptions celOptions;

        DefaultInterpretable(TypeResolver typeResolver, RuntimeTypeProvider typeProvider, Dispatcher dispatcher, CelAbstractSyntaxTree ast, CelOptions celOptions) {
            this.typeResolver = Preconditions.checkNotNull(typeResolver);
            this.typeProvider = Preconditions.checkNotNull(typeProvider);
            this.dispatcher = Preconditions.checkNotNull(dispatcher).immutableCopy();
            this.ast = Preconditions.checkNotNull(ast);
            this.metadata = new DefaultMetadata(ast);
            this.celOptions = Preconditions.checkNotNull(celOptions);
        }

        @Override
        public Object eval(GlobalResolver resolver) throws CelEvaluationException {
            return this.eval(resolver, CelEvaluationListener.noOpListener());
        }

        @Override
        public Object eval(GlobalResolver resolver, CelEvaluationListener listener) throws CelEvaluationException {
            return this.evalTrackingUnknowns(RuntimeUnknownResolver.fromResolver(resolver), Optional.empty(), listener);
        }

        @Override
        public Object eval(GlobalResolver resolver, FunctionResolver lateBoundFunctionResolver) throws CelEvaluationException {
            return this.eval(resolver, lateBoundFunctionResolver, CelEvaluationListener.noOpListener());
        }

        @Override
        public Object eval(GlobalResolver resolver, FunctionResolver lateBoundFunctionResolver, CelEvaluationListener listener) throws CelEvaluationException {
            return this.evalTrackingUnknowns(RuntimeUnknownResolver.fromResolver(resolver), Optional.of(lateBoundFunctionResolver), listener);
        }

        @Override
        public Object evalTrackingUnknowns(RuntimeUnknownResolver resolver, Optional<? extends FunctionResolver> functionResolver, CelEvaluationListener listener) throws CelEvaluationException {
            ExecutionFrame frame = this.newExecutionFrame(resolver, functionResolver, listener);
            IntermediateResult internalResult = this.evalInternal(frame, this.ast.getExpr());
            return internalResult.value();
        }

        @VisibleForTesting
        @CanIgnoreReturnValue
        ExecutionFrame populateExecutionFrame(ExecutionFrame frame) throws CelEvaluationException {
            this.evalInternal(frame, this.ast.getExpr());
            return frame;
        }

        @VisibleForTesting
        ExecutionFrame newTestExecutionFrame(GlobalResolver resolver) {
            return this.newExecutionFrame(RuntimeUnknownResolver.fromResolver(resolver), Optional.empty(), CelEvaluationListener.noOpListener());
        }

        private ExecutionFrame newExecutionFrame(RuntimeUnknownResolver resolver, Optional<? extends FunctionResolver> functionResolver, CelEvaluationListener listener) {
            int comprehensionMaxIterations = this.celOptions.enableComprehension() ? this.celOptions.comprehensionMaxIterations() : 0;
            return new ExecutionFrame(listener, resolver, functionResolver, comprehensionMaxIterations);
        }

        private IntermediateResult evalInternal(ExecutionFrame frame, CelExpr expr) throws CelEvaluationException {
            try {
                IntermediateResult result;
                CelExpr.ExprKind.Kind exprKind = expr.exprKind().getKind();
                switch (exprKind) {
                    case CONSTANT: {
                        result = IntermediateResult.create(this.evalConstant(frame, expr, expr.constant()));
                        break;
                    }
                    case IDENT: {
                        result = this.evalIdent(frame, expr);
                        break;
                    }
                    case SELECT: {
                        result = this.evalSelect(frame, expr, expr.select());
                        break;
                    }
                    case CALL: {
                        result = this.evalCall(frame, expr, expr.call());
                        break;
                    }
                    case LIST: {
                        result = this.evalList(frame, expr, expr.list());
                        break;
                    }
                    case STRUCT: {
                        result = this.evalStruct(frame, expr, expr.struct());
                        break;
                    }
                    case MAP: {
                        result = this.evalMap(frame, expr.map());
                        break;
                    }
                    case COMPREHENSION: {
                        result = this.evalComprehension(frame, expr, expr.comprehension());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unexpected expression kind: " + (Object)((Object)expr.exprKind().getKind()));
                    }
                }
                frame.getEvaluationListener().callback(expr, result.value());
                return result;
            }
            catch (CelRuntimeException e) {
                throw CelEvaluationExceptionBuilder.newBuilder(e).setMetadata(this.metadata, expr.id()).build();
            }
            catch (RuntimeException e) {
                throw CelEvaluationExceptionBuilder.newBuilder(e.getMessage(), new Object[0]).setCause(e).setMetadata(this.metadata, expr.id()).build();
            }
        }

        private static boolean isUnknownValue(Object value) {
            return value instanceof CelUnknownSet || InterpreterUtil.isUnknown(value);
        }

        private static boolean isUnknownOrError(Object value) {
            return DefaultInterpretable.isUnknownValue(value) || value instanceof Exception;
        }

        private Object evalConstant(ExecutionFrame unusedFrame, CelExpr unusedExpr, CelConstant constExpr) {
            switch (constExpr.getKind()) {
                case NULL_VALUE: {
                    return constExpr.nullValue();
                }
                case BOOLEAN_VALUE: {
                    return constExpr.booleanValue();
                }
                case INT64_VALUE: {
                    return constExpr.int64Value();
                }
                case UINT64_VALUE: {
                    if (this.celOptions.enableUnsignedLongs()) {
                        return constExpr.uint64Value();
                    }
                    return constExpr.uint64Value().longValue();
                }
                case DOUBLE_VALUE: {
                    return constExpr.doubleValue();
                }
                case STRING_VALUE: {
                    return constExpr.stringValue();
                }
                case BYTES_VALUE: {
                    return constExpr.bytesValue();
                }
            }
            throw new IllegalStateException("unsupported constant case: " + (Object)((Object)constExpr.getKind()));
        }

        private IntermediateResult evalIdent(ExecutionFrame frame, CelExpr expr) throws CelEvaluationException {
            CelReference reference = this.ast.getReferenceOrThrow(expr.id());
            if (reference.value().isPresent()) {
                return IntermediateResult.create(this.evalConstant(frame, expr, reference.value().get()));
            }
            return this.resolveIdent(frame, expr, reference.name());
        }

        private IntermediateResult resolveIdent(ExecutionFrame frame, CelExpr expr, String name) throws CelEvaluationException {
            CelType checkedType = this.getCheckedTypeOrThrow(expr);
            if (checkedType.kind() == CelKind.TYPE) {
                TypeType typeValue = this.typeResolver.adaptType(checkedType);
                return IntermediateResult.create(typeValue);
            }
            IntermediateResult rawResult = frame.resolveSimpleName(name, expr.id());
            Object value = rawResult.value();
            boolean isLazyExpression = value instanceof LazyExpression;
            if (isLazyExpression) {
                value = this.evalInternal(frame, ((LazyExpression)value).celExpr).value();
            }
            value = InterpreterUtil.strict(this.typeProvider.adapt(checkedType.name(), value));
            IntermediateResult result = IntermediateResult.create(rawResult.attribute(), value);
            if (isLazyExpression) {
                frame.cacheLazilyEvaluatedResult(name, result);
            }
            return result;
        }

        private IntermediateResult evalSelect(ExecutionFrame frame, CelExpr expr, CelExpr.CelSelect selectExpr) throws CelEvaluationException {
            Optional<CelReference> referenceOptional = this.ast.getReference(expr.id());
            if (referenceOptional.isPresent()) {
                CelReference reference = referenceOptional.get();
                if (reference.value().isPresent()) {
                    return IntermediateResult.create(this.evalConstant(frame, expr, reference.value().get()));
                }
                return this.resolveIdent(frame, expr, reference.name());
            }
            return this.evalFieldSelect(frame, expr, selectExpr.operand(), selectExpr.field(), selectExpr.testOnly());
        }

        private IntermediateResult evalFieldSelect(ExecutionFrame frame, CelExpr expr, CelExpr operandExpr, String field, boolean isTestOnly) throws CelEvaluationException {
            IntermediateResult operandResult = this.evalInternal(frame, operandExpr);
            Object operand = operandResult.value();
            CelAttribute attribute = operandResult.attribute().qualify(CelAttribute.Qualifier.ofString(field));
            Optional attrValue = frame.resolveAttribute(attribute);
            if (attrValue.isPresent()) {
                return IntermediateResult.create(attribute, attrValue.get());
            }
            if (DefaultInterpretable.isUnknownValue(operand)) {
                return IntermediateResult.create(attribute, operand);
            }
            if (isTestOnly) {
                return IntermediateResult.create(attribute, this.typeProvider.hasField(operand, field));
            }
            Object fieldValue = this.typeProvider.selectField(operand, field);
            return IntermediateResult.create(attribute, InterpreterUtil.valueOrUnknown(fieldValue, expr.id()));
        }

        private IntermediateResult evalCall(ExecutionFrame frame, CelExpr expr, CelExpr.CelCall callExpr) throws CelEvaluationException {
            CelReference reference = this.ast.getReferenceOrThrow(expr.id());
            Preconditions.checkState(!reference.overloadIds().isEmpty());
            switch ((String)reference.overloadIds().get(0)) {
                case "identity": {
                    return this.evalInternal(frame, (CelExpr)callExpr.args().get(0));
                }
                case "conditional": {
                    return this.evalConditional(frame, callExpr);
                }
                case "logical_and": {
                    return this.evalLogicalAnd(frame, callExpr);
                }
                case "logical_or": {
                    return this.evalLogicalOr(frame, callExpr);
                }
                case "not_strictly_false": {
                    return this.evalNotStrictlyFalse(frame, callExpr);
                }
                case "type": {
                    return this.evalType(frame, callExpr);
                }
                case "optional_or_optional": {
                    return this.evalOptionalOr(frame, callExpr);
                }
                case "optional_orValue_value": {
                    return this.evalOptionalOrValue(frame, callExpr);
                }
                case "select_optional_field": {
                    Optional<IntermediateResult> result = this.maybeEvalOptionalSelectField(frame, expr, callExpr);
                    if (!result.isPresent()) break;
                    return result.get();
                }
                case "cel_block_list": {
                    return this.evalCelBlock(frame, expr, callExpr);
                }
            }
            ArrayList callArgs = new ArrayList();
            callExpr.target().ifPresent(callArgs::add);
            callArgs.addAll(callExpr.args());
            IntermediateResult[] argResults = new IntermediateResult[callArgs.size()];
            for (int i = 0; i < argResults.length; ++i) {
                argResults[i] = this.evalInternal(frame, (CelExpr)callArgs.get(i));
            }
            Optional<CelAttribute> indexAttr = this.maybeContainerIndexAttribute((String)reference.overloadIds().get(0), argResults);
            CelAttribute attr = indexAttr.orElse(CelAttribute.EMPTY);
            Optional resolved = frame.resolveAttribute(attr);
            if (resolved.isPresent()) {
                return IntermediateResult.create(attr, resolved.get());
            }
            CallArgumentChecker argChecker = indexAttr.isPresent() ? CallArgumentChecker.createAcceptingPartial(frame.getResolver()) : CallArgumentChecker.create(frame.getResolver());
            for (IntermediateResult element : argResults) {
                argChecker.checkArg(element);
            }
            Optional<Object> unknowns = argChecker.maybeUnknowns();
            if (unknowns.isPresent()) {
                return IntermediateResult.create(attr, unknowns.get());
            }
            Object[] argArray = Arrays.stream(argResults).map(IntermediateResult::value).toArray();
            ImmutableList<String> overloadIds = reference.overloadIds();
            ResolvedOverload overload = this.findOverloadOrThrow(frame, expr, callExpr.function(), overloadIds, argArray);
            try {
                Object dispatchResult = overload.getDefinition().apply(argArray);
                if (this.celOptions.unwrapWellKnownTypesOnFunctionDispatch()) {
                    CelType checkedType = this.getCheckedTypeOrThrow(expr);
                    dispatchResult = this.typeProvider.adapt(checkedType.name(), dispatchResult);
                }
                return IntermediateResult.create(attr, dispatchResult);
            }
            catch (CelRuntimeException ce) {
                throw CelEvaluationExceptionBuilder.newBuilder(ce).setMetadata(this.metadata, expr.id()).build();
            }
            catch (RuntimeException e) {
                throw CelEvaluationExceptionBuilder.newBuilder("Function '%s' failed with arg(s) '%s'", overload.getOverloadId(), Joiner.on(", ").join(argArray)).setMetadata(this.metadata, expr.id()).setCause(e).build();
            }
        }

        private ResolvedOverload findOverloadOrThrow(ExecutionFrame frame, CelExpr expr, String functionName, List<String> overloadIds, Object[] args) throws CelEvaluationException {
            try {
                Optional<ResolvedOverload> funcImpl = this.dispatcher.findOverload(functionName, overloadIds, args);
                if (funcImpl.isPresent()) {
                    return funcImpl.get();
                }
                return (ResolvedOverload)frame.findOverload(functionName, overloadIds, args).orElseThrow(() -> CelEvaluationExceptionBuilder.newBuilder("No matching overload for function '%s'. Overload candidates: %s", functionName, Joiner.on(",").join(overloadIds)).setErrorCode(CelErrorCode.OVERLOAD_NOT_FOUND).setMetadata(this.metadata, expr.id()).build());
            }
            catch (CelRuntimeException e) {
                throw CelEvaluationExceptionBuilder.newBuilder(e).setMetadata(this.metadata, expr.id()).build();
            }
        }

        private Optional<CelAttribute> maybeContainerIndexAttribute(String overloadId, IntermediateResult[] args) {
            switch (overloadId) {
                case "index_list": {
                    if (args.length != 2 || !(args[1].value() instanceof Long)) break;
                    return Optional.of(args[0].attribute().qualify(CelAttribute.Qualifier.ofInt((Long)args[1].value())));
                }
                case "index_map": {
                    if (args.length != 2) break;
                    try {
                        CelAttribute.Qualifier qualifier = CelAttribute.Qualifier.fromGeneric(args[1].value());
                        return Optional.of(args[0].attribute().qualify(qualifier));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break;
                    }
                }
            }
            return Optional.empty();
        }

        private IntermediateResult evalConditional(ExecutionFrame frame, CelExpr.CelCall callExpr) throws CelEvaluationException {
            IntermediateResult condition = this.evalBooleanStrict(frame, (CelExpr)callExpr.args().get(0));
            if (this.celOptions.enableShortCircuiting()) {
                if (DefaultInterpretable.isUnknownValue(condition.value())) {
                    return condition;
                }
                if (((Boolean)condition.value()).booleanValue()) {
                    return this.evalInternal(frame, (CelExpr)callExpr.args().get(1));
                }
                return this.evalInternal(frame, (CelExpr)callExpr.args().get(2));
            }
            IntermediateResult lhs = this.evalNonstrictly(frame, (CelExpr)callExpr.args().get(1));
            IntermediateResult rhs = this.evalNonstrictly(frame, (CelExpr)callExpr.args().get(2));
            if (DefaultInterpretable.isUnknownValue(condition.value())) {
                return condition;
            }
            Object result = InterpreterUtil.strict((Boolean)condition.value() != false ? lhs.value() : rhs.value());
            return IntermediateResult.create(result);
        }

        private IntermediateResult mergeBooleanUnknowns(IntermediateResult lhs, IntermediateResult rhs) throws CelEvaluationException {
            if (lhs.value() instanceof CelUnknownSet && rhs.value() instanceof CelUnknownSet) {
                return IntermediateResult.create(((CelUnknownSet)lhs.value()).merge((CelUnknownSet)rhs.value()));
            }
            if (lhs.value() instanceof CelUnknownSet) {
                return lhs;
            }
            if (rhs.value() instanceof CelUnknownSet) {
                return rhs;
            }
            return IntermediateResult.create(InterpreterUtil.shortcircuitUnknownOrThrowable(lhs.value(), rhs.value()));
        }

        private boolean canShortCircuit(IntermediateResult result, ShortCircuitableOperators operator) {
            if (!(result.value() instanceof Boolean)) {
                return false;
            }
            Boolean value = (Boolean)result.value();
            if (value.booleanValue() && operator.equals((Object)ShortCircuitableOperators.LOGICAL_OR)) {
                return true;
            }
            return value == false && operator.equals((Object)ShortCircuitableOperators.LOGICAL_AND);
        }

        private IntermediateResult evalLogicalOr(ExecutionFrame frame, CelExpr.CelCall callExpr) throws CelEvaluationException {
            IntermediateResult right;
            IntermediateResult left;
            if (this.celOptions.enableShortCircuiting()) {
                left = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(0));
                if (this.canShortCircuit(left, ShortCircuitableOperators.LOGICAL_OR)) {
                    return left;
                }
                right = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(1));
                if (this.canShortCircuit(right, ShortCircuitableOperators.LOGICAL_OR)) {
                    return right;
                }
            } else {
                left = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(0));
                right = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(1));
                if (this.canShortCircuit(left, ShortCircuitableOperators.LOGICAL_OR)) {
                    return left;
                }
                if (this.canShortCircuit(right, ShortCircuitableOperators.LOGICAL_OR)) {
                    return right;
                }
            }
            if (right.value() instanceof Boolean && left.value() instanceof Boolean) {
                return IntermediateResult.create((Boolean)right.value() != false || (Boolean)left.value() != false);
            }
            return this.mergeBooleanUnknowns(left, right);
        }

        private IntermediateResult evalLogicalAnd(ExecutionFrame frame, CelExpr.CelCall callExpr) throws CelEvaluationException {
            IntermediateResult right;
            IntermediateResult left;
            if (this.celOptions.enableShortCircuiting()) {
                left = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(0));
                if (this.canShortCircuit(left, ShortCircuitableOperators.LOGICAL_AND)) {
                    return left;
                }
                right = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(1));
                if (this.canShortCircuit(right, ShortCircuitableOperators.LOGICAL_AND)) {
                    return right;
                }
            } else {
                left = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(0));
                right = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(1));
                if (this.canShortCircuit(left, ShortCircuitableOperators.LOGICAL_AND)) {
                    return left;
                }
                if (this.canShortCircuit(right, ShortCircuitableOperators.LOGICAL_AND)) {
                    return right;
                }
            }
            if (right.value() instanceof Boolean && left.value() instanceof Boolean) {
                return IntermediateResult.create((Boolean)right.value() != false && (Boolean)left.value() != false);
            }
            return this.mergeBooleanUnknowns(left, right);
        }

        private IntermediateResult evalNotStrictlyFalse(ExecutionFrame frame, CelExpr.CelCall callExpr) {
            try {
                IntermediateResult value = this.evalBooleanStrict(frame, (CelExpr)callExpr.args().get(0));
                if (value.value() instanceof Boolean) {
                    return value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return IntermediateResult.create(true);
        }

        private IntermediateResult evalType(ExecutionFrame frame, CelExpr.CelCall callExpr) throws CelEvaluationException {
            CelExpr typeExprArg = (CelExpr)callExpr.args().get(0);
            IntermediateResult argResult = this.evalInternal(frame, typeExprArg);
            if (DefaultInterpretable.isUnknownOrError(argResult.value())) {
                return argResult;
            }
            CelType checkedType = this.getCheckedTypeOrThrow(typeExprArg);
            TypeType checkedTypeValue = this.typeResolver.adaptType(checkedType);
            return IntermediateResult.create(this.typeResolver.resolveObjectType(argResult.value(), checkedTypeValue));
        }

        private IntermediateResult evalOptionalOr(ExecutionFrame frame, CelExpr.CelCall callExpr) throws CelEvaluationException {
            return this.evalOptionalOrInternal(frame, callExpr, false);
        }

        private IntermediateResult evalOptionalOrValue(ExecutionFrame frame, CelExpr.CelCall callExpr) throws CelEvaluationException {
            return this.evalOptionalOrInternal(frame, callExpr, true);
        }

        private IntermediateResult evalOptionalOrInternal(ExecutionFrame frame, CelExpr.CelCall callExpr, boolean unwrapOptional) throws CelEvaluationException {
            CelExpr lhsExpr = callExpr.target().orElseThrow(() -> new IllegalStateException("Missing target for chained optional function"));
            IntermediateResult lhsResult = this.evalInternal(frame, lhsExpr);
            if (DefaultInterpretable.isUnknownValue(lhsResult.value())) {
                return lhsResult;
            }
            if (!(lhsResult.value() instanceof Optional)) {
                throw CelEvaluationExceptionBuilder.newBuilder("expected optional value, found: %s", lhsResult.value()).setErrorCode(CelErrorCode.INVALID_ARGUMENT).setMetadata(this.metadata, lhsExpr.id()).build();
            }
            Optional lhsOptionalValue = (Optional)lhsResult.value();
            if (lhsOptionalValue.isPresent()) {
                return unwrapOptional ? IntermediateResult.create(lhsOptionalValue.get()) : lhsResult;
            }
            return this.evalInternal(frame, (CelExpr)callExpr.args().get(0));
        }

        private Optional<IntermediateResult> maybeEvalOptionalSelectField(ExecutionFrame frame, CelExpr expr, CelExpr.CelCall callExpr) throws CelEvaluationException {
            CelExpr operand = (CelExpr)callExpr.args().get(0);
            IntermediateResult lhsResult = this.evalInternal(frame, operand);
            if (lhsResult.value() instanceof Map) {
                return Optional.empty();
            }
            String field = ((CelExpr)callExpr.args().get(1)).constant().stringValue();
            boolean hasField = (Boolean)this.typeProvider.hasField(lhsResult.value(), field);
            if (!hasField) {
                return Optional.of(IntermediateResult.create(Optional.empty()));
            }
            IntermediateResult result = this.evalFieldSelect(frame, expr, operand, field, false);
            return Optional.of(IntermediateResult.create(result.attribute(), Optional.of(result.value())));
        }

        private IntermediateResult evalBoolean(ExecutionFrame frame, CelExpr expr, boolean strict) throws CelEvaluationException {
            IntermediateResult value;
            IntermediateResult intermediateResult = value = strict ? this.evalInternal(frame, expr) : this.evalNonstrictly(frame, expr);
            if (!(value.value() instanceof Boolean) && !DefaultInterpretable.isUnknownOrError(value.value())) {
                throw CelEvaluationExceptionBuilder.newBuilder("expected boolean value, found: %s", value.value()).setErrorCode(CelErrorCode.INVALID_ARGUMENT).setMetadata(this.metadata, expr.id()).build();
            }
            return value;
        }

        private IntermediateResult evalBooleanStrict(ExecutionFrame frame, CelExpr expr) throws CelEvaluationException {
            return this.evalBoolean(frame, expr, true);
        }

        private IntermediateResult evalBooleanNonstrict(ExecutionFrame frame, CelExpr expr) throws CelEvaluationException {
            return this.evalBoolean(frame, expr, false);
        }

        private IntermediateResult evalList(ExecutionFrame frame, CelExpr unusedExpr, CelExpr.CelList listExpr) throws CelEvaluationException {
            CallArgumentChecker argChecker = CallArgumentChecker.create(frame.getResolver());
            ArrayList<Object> result = new ArrayList<Object>(((AbstractCollection)((Object)listExpr.elements())).size());
            HashSet optionalIndicesSet = new HashSet(listExpr.optionalIndices());
            List elements = listExpr.elements();
            for (int i = 0; i < ((AbstractCollection)((Object)elements)).size(); ++i) {
                CelExpr element = (CelExpr)elements.get(i);
                IntermediateResult evaluatedElement = this.evalInternal(frame, element);
                argChecker.checkArg(evaluatedElement);
                Object value = evaluatedElement.value();
                if (!optionalIndicesSet.isEmpty() && optionalIndicesSet.contains(i) && !DefaultInterpretable.isUnknownValue(value)) {
                    Optional optionalVal = (Optional)value;
                    if (!optionalVal.isPresent()) continue;
                    value = optionalVal.get();
                }
                result.add(value);
            }
            return IntermediateResult.create(argChecker.maybeUnknowns().orElse(result));
        }

        private IntermediateResult evalMap(ExecutionFrame frame, CelExpr.CelMap mapExpr) throws CelEvaluationException {
            CallArgumentChecker argChecker = CallArgumentChecker.create(frame.getResolver());
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (CelExpr.CelMap.Entry entry : mapExpr.entries()) {
                IntermediateResult keyResult = this.evalInternal(frame, entry.key());
                argChecker.checkArg(keyResult);
                IntermediateResult valueResult = this.evalInternal(frame, entry.value());
                argChecker.checkArg(valueResult);
                if (this.celOptions.errorOnDuplicateMapKeys() && result.containsKey(keyResult.value())) {
                    throw CelEvaluationExceptionBuilder.newBuilder("duplicate map key [%s]", keyResult.value()).setErrorCode(CelErrorCode.DUPLICATE_ATTRIBUTE).setMetadata(this.metadata, entry.id()).build();
                }
                Object value = valueResult.value();
                if (entry.optionalEntry() && !DefaultInterpretable.isUnknownValue(value)) {
                    Optional optionalVal = (Optional)value;
                    if (!optionalVal.isPresent()) {
                        result.remove(keyResult.value());
                        continue;
                    }
                    value = optionalVal.get();
                }
                result.put(keyResult.value(), value);
            }
            return IntermediateResult.create(argChecker.maybeUnknowns().orElse(result));
        }

        private IntermediateResult evalStruct(ExecutionFrame frame, CelExpr expr, CelExpr.CelStruct structExpr) throws CelEvaluationException {
            CelReference reference = this.ast.getReference(expr.id()).orElseThrow(() -> new IllegalStateException("Could not find a reference for CelStruct expression at ID: " + expr.id()));
            CallArgumentChecker argChecker = CallArgumentChecker.create(frame.getResolver());
            HashMap<String, Object> fields = new HashMap<String, Object>();
            for (CelExpr.CelStruct.Entry entry : structExpr.entries()) {
                IntermediateResult fieldResult = this.evalInternal(frame, entry.value());
                argChecker.checkArg(fieldResult);
                Object value = fieldResult.value();
                if (entry.optionalEntry()) {
                    Optional optionalVal = (Optional)value;
                    if (!optionalVal.isPresent()) {
                        fields.remove(entry.fieldKey());
                        continue;
                    }
                    value = optionalVal.get();
                }
                fields.put(entry.fieldKey(), value);
            }
            return argChecker.maybeUnknowns().map(IntermediateResult::create).orElseGet(() -> IntermediateResult.create(this.typeProvider.createMessage(reference.name(), fields)));
        }

        private IntermediateResult evalNonstrictly(ExecutionFrame frame, CelExpr expr) {
            try {
                return this.evalInternal(frame, expr);
            }
            catch (Exception e) {
                return IntermediateResult.create(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IntermediateResult evalComprehension(ExecutionFrame frame, CelExpr unusedExpr, CelExpr.CelComprehension compre) throws CelEvaluationException {
            IntermediateResult result;
            Collection<Object> iterRange;
            String accuVar = compre.accuVar();
            String iterVar = compre.iterVar();
            IntermediateResult iterRangeRaw = this.evalInternal(frame, compre.iterRange());
            if (DefaultInterpretable.isUnknownValue(iterRangeRaw.value())) {
                return iterRangeRaw;
            }
            if (iterRangeRaw.value() instanceof List) {
                iterRange = (List)iterRangeRaw.value();
            } else if (iterRangeRaw.value() instanceof Map) {
                iterRange = ((Map)iterRangeRaw.value()).keySet();
            } else {
                throw CelEvaluationExceptionBuilder.newBuilder("expected a list or a map for iteration range but got '%s'", iterRangeRaw.value().getClass().getSimpleName()).setErrorCode(CelErrorCode.INVALID_ARGUMENT).setMetadata(this.metadata, compre.iterRange().id()).build();
            }
            IntermediateResult accuValue = LazyExpression.isLazilyEvaluable(compre) ? IntermediateResult.create(new LazyExpression(compre.accuInit())) : this.evalNonstrictly(frame, compre.accuInit());
            int i = 0;
            for (Object elem : iterRange) {
                frame.incrementIterations();
                CelAttribute iterAttr = CelAttribute.EMPTY;
                if (iterRange instanceof List) {
                    iterAttr = iterRangeRaw.attribute().qualify(CelAttribute.Qualifier.ofInt(i));
                }
                ++i;
                HashMap<String, IntermediateResult> loopVars = new HashMap<String, IntermediateResult>();
                loopVars.put(iterVar, IntermediateResult.create(iterAttr, RuntimeHelpers.maybeAdaptPrimitive(elem)));
                loopVars.put(accuVar, accuValue);
                frame.pushScope(Collections.unmodifiableMap(loopVars));
                IntermediateResult evalObject = this.evalBooleanStrict(frame, compre.loopCondition());
                if (!DefaultInterpretable.isUnknownValue(evalObject.value()) && !((Boolean)evalObject.value()).booleanValue()) {
                    frame.popScope();
                    break;
                }
                accuValue = this.evalNonstrictly(frame, compre.loopStep());
                frame.popScope();
            }
            frame.pushScope(Collections.singletonMap(accuVar, accuValue));
            try {
                result = this.evalInternal(frame, compre.result());
            }
            finally {
                frame.popScope();
            }
            return result;
        }

        private IntermediateResult evalCelBlock(ExecutionFrame frame, CelExpr unusedExpr, CelExpr.CelCall blockCall) throws CelEvaluationException {
            CelExpr.CelList exprList = ((CelExpr)blockCall.args().get(0)).list();
            HashMap<String, IntermediateResult> blockList = new HashMap<String, IntermediateResult>();
            for (int index = 0; index < ((AbstractCollection)((Object)exprList.elements())).size(); ++index) {
                blockList.put("@index" + index, IntermediateResult.create(new LazyExpression((CelExpr)exprList.elements().get(index))));
            }
            frame.pushScope(Collections.unmodifiableMap(blockList));
            return this.evalInternal(frame, (CelExpr)blockCall.args().get(1));
        }

        private CelType getCheckedTypeOrThrow(CelExpr expr) throws CelEvaluationException {
            return this.ast.getType(expr.id()).orElseThrow(() -> CelEvaluationExceptionBuilder.newBuilder("expected a runtime type for expression ID '%d' from checked expression, but found none.", expr.id()).setErrorCode(CelErrorCode.TYPE_NOT_FOUND).setMetadata(this.metadata, expr.id()).build());
        }

        private static enum ShortCircuitableOperators {
            LOGICAL_OR,
            LOGICAL_AND;

        }
    }

    static class ExecutionFrame {
        private final CelEvaluationListener evaluationListener;
        private final int maxIterations;
        private final ArrayDeque<RuntimeUnknownResolver> resolvers;
        private final Optional<? extends FunctionResolver> lateBoundFunctionResolver;
        private RuntimeUnknownResolver currentResolver;
        private int iterations;
        @VisibleForTesting
        int scopeLevel;

        private ExecutionFrame(CelEvaluationListener evaluationListener, RuntimeUnknownResolver resolver, Optional<? extends FunctionResolver> lateBoundFunctionResolver, int maxIterations) {
            this.evaluationListener = evaluationListener;
            this.resolvers = new ArrayDeque();
            this.resolvers.add(resolver);
            this.lateBoundFunctionResolver = lateBoundFunctionResolver;
            this.currentResolver = resolver;
            this.maxIterations = maxIterations;
        }

        private CelEvaluationListener getEvaluationListener() {
            return this.evaluationListener;
        }

        private RuntimeUnknownResolver getResolver() {
            return this.currentResolver;
        }

        private Optional<ResolvedOverload> findOverload(String function, List<String> overloadIds, Object[] args) throws CelEvaluationException {
            if (this.lateBoundFunctionResolver.isPresent()) {
                return this.lateBoundFunctionResolver.get().findOverload(function, overloadIds, args);
            }
            return Optional.empty();
        }

        private void incrementIterations() throws CelEvaluationException {
            if (this.maxIterations < 0) {
                return;
            }
            if (++this.iterations > this.maxIterations) {
                throw CelEvaluationExceptionBuilder.newBuilder(String.format("Iteration budget exceeded: %d", this.maxIterations), new Object[0]).setErrorCode(CelErrorCode.ITERATION_BUDGET_EXCEEDED).build();
            }
        }

        private IntermediateResult resolveSimpleName(String name, Long exprId) {
            return this.currentResolver.resolveSimpleName(name, exprId);
        }

        private Optional<Object> resolveAttribute(CelAttribute attr) {
            return this.currentResolver.resolveAttribute(attr);
        }

        private void cacheLazilyEvaluatedResult(String name, IntermediateResult result) {
            this.currentResolver.cacheLazilyEvaluatedResult(name, result);
        }

        private void pushScope(Map<String, IntermediateResult> scope) {
            ++this.scopeLevel;
            RuntimeUnknownResolver.ScopedResolver scopedResolver = this.currentResolver.withScope(scope);
            this.currentResolver = scopedResolver;
            this.resolvers.addLast(scopedResolver);
        }

        private void popScope() {
            --this.scopeLevel;
            if (this.resolvers.isEmpty()) {
                throw new IllegalStateException("Execution frame error: more scopes popped than pushed");
            }
            this.resolvers.removeLast();
            this.currentResolver = this.resolvers.getLast();
        }
    }

    private static class LazyExpression {
        private final CelExpr celExpr;

        private static boolean isLazilyEvaluable(CelExpr.CelComprehension comprehension) {
            return comprehension.loopCondition().constantOrDefault().getKind().equals((Object)CelConstant.Kind.BOOLEAN_VALUE) && !comprehension.loopCondition().constant().booleanValue() && comprehension.iterVar().equals("#unused") && comprehension.iterRange().exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.LIST) && ((AbstractCollection)((Object)comprehension.iterRange().list().elements())).isEmpty();
        }

        private LazyExpression(CelExpr celExpr) {
            this.celExpr = celExpr;
        }
    }

    @AutoValue
    static abstract class IntermediateResult {
        IntermediateResult() {
        }

        abstract CelAttribute attribute();

        abstract Object value();

        static IntermediateResult create(CelAttribute attr, Object value) {
            Preconditions.checkArgument(!(value instanceof IntermediateResult), "Recursive intermediate results are not supported.");
            return new AutoValue_DefaultInterpreter_IntermediateResult(attr, value);
        }

        static IntermediateResult create(Object value) {
            return IntermediateResult.create(CelAttribute.EMPTY, value);
        }
    }
}

