/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class BytesFunction
extends CelStandardFunction {
    private static final BytesFunction ALL_OVERLOADS = BytesFunction.create(BytesOverload.values());

    public static BytesFunction create() {
        return ALL_OVERLOADS;
    }

    public static BytesFunction create(BytesOverload ... overloads) {
        return BytesFunction.create(Arrays.asList(overloads));
    }

    public static BytesFunction create(Iterable<BytesOverload> overloads) {
        return new BytesFunction(ImmutableSet.copyOf(overloads));
    }

    private BytesFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum BytesOverload implements CelStandardOverload
    {
        BYTES_TO_BYTES((celOptions, runtimeEquality) -> CelFunctionBinding.from("bytes_to_bytes", ByteString.class, x -> x)),
        STRING_TO_BYTES((celOptions, runtimeEquality) -> CelFunctionBinding.from("string_to_bytes", String.class, ByteString::copyFromUtf8));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private BytesOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

