/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardOverload;

@Immutable
public abstract class CelStandardFunction {
    private final ImmutableSet<CelStandardOverload> overloads;

    public ImmutableSet<CelFunctionBinding> newFunctionBindings(CelOptions celOptions, RuntimeEquality runtimeEquality) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (CelStandardOverload overload : this.overloads) {
            builder.add(overload.newFunctionBinding(celOptions, runtimeEquality));
        }
        return builder.build();
    }

    CelStandardFunction(ImmutableSet<CelStandardOverload> overloads) {
        Preconditions.checkState(!overloads.isEmpty(), "At least 1 overload must be provided.");
        this.overloads = overloads;
    }
}

