/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class ContainsFunction
extends CelStandardFunction {
    private static final ContainsFunction ALL_OVERLOADS = ContainsFunction.create(ContainsOverload.values());

    public static ContainsFunction create() {
        return ALL_OVERLOADS;
    }

    public static ContainsFunction create(ContainsOverload ... overloads) {
        return ContainsFunction.create(Arrays.asList(overloads));
    }

    public static ContainsFunction create(Iterable<ContainsOverload> overloads) {
        return new ContainsFunction(ImmutableSet.copyOf(overloads));
    }

    private ContainsFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum ContainsOverload implements CelStandardOverload
    {
        CONTAINS_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("contains_string", String.class, String.class, String::contains));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private ContainsOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

