/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class DoubleFunction
extends CelStandardFunction {
    private static final DoubleFunction ALL_OVERLOADS = DoubleFunction.create(DoubleOverload.values());

    public static DoubleFunction create() {
        return ALL_OVERLOADS;
    }

    public static DoubleFunction create(DoubleOverload ... overloads) {
        return DoubleFunction.create(Arrays.asList(overloads));
    }

    public static DoubleFunction create(Iterable<DoubleOverload> overloads) {
        return new DoubleFunction(ImmutableSet.copyOf(overloads));
    }

    private DoubleFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum DoubleOverload implements CelStandardOverload
    {
        DOUBLE_TO_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("double_to_double", Double.class, x -> x)),
        INT64_TO_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("int64_to_double", Long.class, Long::doubleValue)),
        STRING_TO_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("string_to_double", String.class, arg -> {
            try {
                return Double.parseDouble(arg);
            }
            catch (NumberFormatException e) {
                throw new CelRuntimeException(e, CelErrorCode.BAD_FORMAT);
            }
        })),
        UINT64_TO_DOUBLE((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("uint64_to_double", UnsignedLong.class, UnsignedLong::doubleValue);
            }
            return CelFunctionBinding.from("uint64_to_double", Long.class, arg -> UnsignedLong.fromLongBits(arg).doubleValue());
        });

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private DoubleOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

