/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class EqualsOperator
extends CelStandardFunction {
    private static final EqualsOperator ALL_OVERLOADS = EqualsOperator.create(EqualsOverload.values());

    public static EqualsOperator create() {
        return ALL_OVERLOADS;
    }

    public static EqualsOperator create(EqualsOverload ... overloads) {
        return EqualsOperator.create(Arrays.asList(overloads));
    }

    public static EqualsOperator create(Iterable<EqualsOverload> overloads) {
        return new EqualsOperator(ImmutableSet.copyOf(overloads));
    }

    private EqualsOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum EqualsOverload implements CelStandardOverload
    {
        EQUALS((celOptions, runtimeEquality) -> CelFunctionBinding.from("equals", Object.class, Object.class, runtimeEquality::objectEquals));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private EqualsOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

