/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetFullYearFunction
extends CelStandardFunction {
    private static final GetFullYearFunction ALL_OVERLOADS = GetFullYearFunction.create(GetFullYearOverload.values());

    public static GetFullYearFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetFullYearFunction create(GetFullYearOverload ... overloads) {
        return GetFullYearFunction.create(Arrays.asList(overloads));
    }

    public static GetFullYearFunction create(Iterable<GetFullYearOverload> overloads) {
        return new GetFullYearFunction(ImmutableSet.copyOf(overloads));
    }

    private GetFullYearFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetFullYearOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_YEAR((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_year", Timestamp.class, ts -> (long)DateTimeHelpers.newLocalDateTime(ts, "UTC").getYear())),
        TIMESTAMP_TO_YEAR_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_year_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)DateTimeHelpers.newLocalDateTime(ts, tz).getYear()));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetFullYearOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

