/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetMinutesFunction
extends CelStandardFunction {
    private static final GetMinutesFunction ALL_OVERLOADS = GetMinutesFunction.create(GetMinutesOverload.values());

    public static GetMinutesFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetMinutesFunction create(GetMinutesOverload ... overloads) {
        return GetMinutesFunction.create(Arrays.asList(overloads));
    }

    public static GetMinutesFunction create(Iterable<GetMinutesOverload> overloads) {
        return new GetMinutesFunction(ImmutableSet.copyOf(overloads));
    }

    private GetMinutesFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetMinutesOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_MINUTES((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_minutes", Timestamp.class, ts -> (long)DateTimeHelpers.newLocalDateTime(ts, "UTC").getMinute())),
        TIMESTAMP_TO_MINUTES_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_minutes_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)DateTimeHelpers.newLocalDateTime(ts, tz).getMinute())),
        DURATION_TO_MINUTES((celOptions, runtimeEquality) -> CelFunctionBinding.from("duration_to_minutes", Duration.class, ProtoTimeUtils::toMinutes));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetMinutesOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

