/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import dev.cel.runtime.standard.DateTimeHelpers;
import java.util.Arrays;

public final class GetSecondsFunction
extends CelStandardFunction {
    private static final GetSecondsFunction ALL_OVERLOADS = GetSecondsFunction.create(GetSecondsOverload.values());

    public static GetSecondsFunction create() {
        return ALL_OVERLOADS;
    }

    public static GetSecondsFunction create(GetSecondsOverload ... overloads) {
        return GetSecondsFunction.create(Arrays.asList(overloads));
    }

    public static GetSecondsFunction create(Iterable<GetSecondsOverload> overloads) {
        return new GetSecondsFunction(ImmutableSet.copyOf(overloads));
    }

    private GetSecondsFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum GetSecondsOverload implements CelStandardOverload
    {
        TIMESTAMP_TO_SECONDS((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_seconds", Timestamp.class, ts -> (long)DateTimeHelpers.newLocalDateTime(ts, "UTC").getSecond())),
        TIMESTAMP_TO_SECONDS_WITH_TZ((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_seconds_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)DateTimeHelpers.newLocalDateTime(ts, tz).getSecond())),
        DURATION_TO_SECONDS((celOptions, runtimeEquality) -> CelFunctionBinding.from("duration_to_seconds", Duration.class, ProtoTimeUtils::toSeconds));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private GetSecondsOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

