/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class IntFunction
extends CelStandardFunction {
    private static final IntFunction ALL_OVERLOADS = IntFunction.create(IntOverload.values());

    public static IntFunction create() {
        return ALL_OVERLOADS;
    }

    public static IntFunction create(IntOverload ... overloads) {
        return IntFunction.create(Arrays.asList(overloads));
    }

    public static IntFunction create(Iterable<IntOverload> overloads) {
        return new IntFunction(ImmutableSet.copyOf(overloads));
    }

    private IntFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum IntOverload implements CelStandardOverload
    {
        INT64_TO_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("int64_to_int64", Long.class, x -> x)),
        UINT64_TO_INT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("uint64_to_int64", UnsignedLong.class, arg -> {
                    if (arg.compareTo(UnsignedLong.valueOf(Long.MAX_VALUE)) > 0) {
                        throw new CelRuntimeException(new IllegalArgumentException("unsigned out of int range"), CelErrorCode.NUMERIC_OVERFLOW);
                    }
                    return arg.longValue();
                });
            }
            return CelFunctionBinding.from("uint64_to_int64", Long.class, arg -> {
                if (celOptions.errorOnIntWrap() && arg < 0L) {
                    throw new CelRuntimeException(new IllegalArgumentException("unsigned out of int range"), CelErrorCode.NUMERIC_OVERFLOW);
                }
                return arg;
            });
        }),
        DOUBLE_TO_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("double_to_int64", Double.class, arg -> {
            if (celOptions.errorOnIntWrap()) {
                return RuntimeHelpers.doubleToLongChecked(arg).orElseThrow(() -> new CelRuntimeException(new IllegalArgumentException("double is out of range for int"), CelErrorCode.NUMERIC_OVERFLOW));
            }
            return arg.longValue();
        })),
        STRING_TO_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("string_to_int64", String.class, arg -> {
            try {
                return Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                throw new CelRuntimeException(e, CelErrorCode.BAD_FORMAT);
            }
        })),
        TIMESTAMP_TO_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("timestamp_to_int64", Timestamp.class, ProtoTimeUtils::toSeconds));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private IntOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

