/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.ArithmeticHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class ModuloOperator
extends CelStandardFunction {
    private static final ModuloOperator ALL_OVERLOADS = ModuloOperator.create(ModuloOverload.values());

    public static ModuloOperator create() {
        return ALL_OVERLOADS;
    }

    public static ModuloOperator create(ModuloOverload ... overloads) {
        return ModuloOperator.create(Arrays.asList(overloads));
    }

    public static ModuloOperator create(Iterable<ModuloOverload> overloads) {
        return new ModuloOperator(ImmutableSet.copyOf(overloads));
    }

    private ModuloOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum ModuloOverload implements CelStandardOverload
    {
        MODULO_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("modulo_int64", Long.class, Long.class, (x, y) -> {
            try {
                return x % y;
            }
            catch (ArithmeticException e) {
                throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
            }
        })),
        MODULO_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("modulo_uint64", UnsignedLong.class, UnsignedLong.class, RuntimeHelpers::uint64Mod);
            }
            return CelFunctionBinding.from("modulo_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64Mod(x, y, celOptions));
        });

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private ModuloOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

