/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.ArithmeticHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class MultiplyOperator
extends CelStandardFunction {
    private static final MultiplyOperator ALL_OVERLOADS = MultiplyOperator.create(MultiplyOverload.values());

    public static MultiplyOperator create() {
        return ALL_OVERLOADS;
    }

    public static MultiplyOperator create(MultiplyOverload ... overloads) {
        return MultiplyOperator.create(Arrays.asList(overloads));
    }

    public static MultiplyOperator create(Iterable<MultiplyOverload> overloads) {
        return new MultiplyOperator(ImmutableSet.copyOf(overloads));
    }

    private MultiplyOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum MultiplyOverload implements CelStandardOverload
    {
        MULTIPLY_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("multiply_int64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.int64Multiply(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
            }
        })),
        MULTIPLY_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("multiply_double", Double.class, Double.class, (x, y) -> x * y)),
        MULTIPLY_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("multiply_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> {
                    try {
                        return RuntimeHelpers.uint64Multiply(x, y);
                    }
                    catch (ArithmeticException e) {
                        throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
                    }
                });
            }
            return CelFunctionBinding.from("multiply_uint64", Long.class, Long.class, (x, y) -> {
                try {
                    return RuntimeHelpers.uint64Multiply(x, y, celOptions);
                }
                catch (ArithmeticException e) {
                    throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
                }
            });
        });

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private MultiplyOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

