/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import dev.cel.common.CelOptions;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class SizeFunction
extends CelStandardFunction {
    private static final SizeFunction ALL_OVERLOADS = SizeFunction.create(SizeOverload.values());

    public static SizeFunction create() {
        return ALL_OVERLOADS;
    }

    public static SizeFunction create(SizeOverload ... overloads) {
        return SizeFunction.create(Arrays.asList(overloads));
    }

    public static SizeFunction create(Iterable<SizeOverload> overloads) {
        return new SizeFunction(ImmutableSet.copyOf(overloads));
    }

    private SizeFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum SizeOverload implements CelStandardOverload
    {
        SIZE_BYTES((celOptions, runtimeEquality) -> CelFunctionBinding.from("size_bytes", ByteString.class, bytes -> (long)bytes.size())),
        BYTES_SIZE((celOptions, runtimeEquality) -> CelFunctionBinding.from("bytes_size", ByteString.class, bytes -> (long)bytes.size())),
        SIZE_LIST((celOptions, runtimeEquality) -> CelFunctionBinding.from("size_list", List.class, list1 -> (long)list1.size())),
        LIST_SIZE((celOptions, runtimeEquality) -> CelFunctionBinding.from("list_size", List.class, list1 -> (long)list1.size())),
        SIZE_STRING((celOptions, runtimeEquality) -> CelFunctionBinding.from("size_string", String.class, s2 -> (long)s2.codePointCount(0, s2.length()))),
        STRING_SIZE((celOptions, runtimeEquality) -> CelFunctionBinding.from("string_size", String.class, s2 -> (long)s2.codePointCount(0, s2.length()))),
        SIZE_MAP((celOptions, runtimeEquality) -> CelFunctionBinding.from("size_map", Map.class, map1 -> (long)map1.size())),
        MAP_SIZE((celOptions, runtimeEquality) -> CelFunctionBinding.from("map_size", Map.class, map1 -> (long)map1.size()));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private SizeOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

