/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.internal.ProtoTimeUtils;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.ArithmeticHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.util.Arrays;

public final class SubtractOperator
extends CelStandardFunction {
    private static final SubtractOperator ALL_OVERLOADS = SubtractOperator.create(SubtractOverload.values());

    public static SubtractOperator create() {
        return ALL_OVERLOADS;
    }

    public static SubtractOperator create(SubtractOverload ... overloads) {
        return SubtractOperator.create(Arrays.asList(overloads));
    }

    public static SubtractOperator create(Iterable<SubtractOverload> overloads) {
        return new SubtractOperator(ImmutableSet.copyOf(overloads));
    }

    private SubtractOperator(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum SubtractOverload implements CelStandardOverload
    {
        SUBTRACT_INT64((celOptions, runtimeEquality) -> CelFunctionBinding.from("subtract_int64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.int64Subtract(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
            }
        })),
        SUBTRACT_TIMESTAMP_TIMESTAMP((celOptions, runtimeEquality) -> CelFunctionBinding.from("subtract_timestamp_timestamp", Timestamp.class, Timestamp.class, (x, y) -> ProtoTimeUtils.between(y, x))),
        SUBTRACT_TIMESTAMP_DURATION((celOptions, runtimeEquality) -> CelFunctionBinding.from("subtract_timestamp_duration", Timestamp.class, Duration.class, ProtoTimeUtils::subtract)),
        SUBTRACT_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("subtract_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> {
                    try {
                        return RuntimeHelpers.uint64Subtract(x, y);
                    }
                    catch (ArithmeticException e) {
                        throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
                    }
                });
            }
            return CelFunctionBinding.from("subtract_uint64", Long.class, Long.class, (x, y) -> {
                try {
                    return RuntimeHelpers.uint64Subtract(x, y, celOptions);
                }
                catch (ArithmeticException e) {
                    throw new CelRuntimeException(e, ArithmeticHelpers.getArithmeticErrorCode(e));
                }
            });
        }),
        SUBTRACT_DOUBLE((celOptions, runtimeEquality) -> CelFunctionBinding.from("subtract_double", Double.class, Double.class, (x, y) -> x - y)),
        SUBTRACT_DURATION_DURATION((celOptions, runtimeEquality) -> CelFunctionBinding.from("subtract_duration_duration", Duration.class, Duration.class, ProtoTimeUtils::subtract));

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private SubtractOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

