/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime.standard;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.common.primitives.UnsignedLongs;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.runtime.CelFunctionBinding;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.standard.CelStandardFunction;
import dev.cel.runtime.standard.CelStandardOverload;
import java.math.BigDecimal;
import java.util.Arrays;

public final class UintFunction
extends CelStandardFunction {
    private static final UintFunction ALL_OVERLOADS = UintFunction.create(UintOverload.values());

    public static UintFunction create() {
        return ALL_OVERLOADS;
    }

    public static UintFunction create(UintOverload ... overloads) {
        return UintFunction.create(Arrays.asList(overloads));
    }

    public static UintFunction create(Iterable<UintOverload> overloads) {
        return new UintFunction(ImmutableSet.copyOf(overloads));
    }

    private UintFunction(ImmutableSet<CelStandardOverload> overloads) {
        super(overloads);
    }

    public static enum UintOverload implements CelStandardOverload
    {
        UINT64_TO_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("uint64_to_uint64", UnsignedLong.class, x -> x);
            }
            return CelFunctionBinding.from("uint64_to_uint64", Long.class, x -> x);
        }),
        INT64_TO_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("int64_to_uint64", Long.class, arg -> {
                    if (celOptions.errorOnIntWrap() && arg < 0L) {
                        throw new CelRuntimeException(new IllegalArgumentException("int out of uint range"), CelErrorCode.NUMERIC_OVERFLOW);
                    }
                    return UnsignedLong.valueOf(arg);
                });
            }
            return CelFunctionBinding.from("int64_to_uint64", Long.class, arg -> {
                if (celOptions.errorOnIntWrap() && arg < 0L) {
                    throw new CelRuntimeException(new IllegalArgumentException("int out of uint range"), CelErrorCode.NUMERIC_OVERFLOW);
                }
                return arg;
            });
        }),
        DOUBLE_TO_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("double_to_uint64", Double.class, arg -> {
                    if (celOptions.errorOnIntWrap()) {
                        return RuntimeHelpers.doubleToUnsignedChecked(arg).orElseThrow(() -> new CelRuntimeException(new IllegalArgumentException("double out of uint range"), CelErrorCode.NUMERIC_OVERFLOW));
                    }
                    return UnsignedLong.valueOf(BigDecimal.valueOf(arg).toBigInteger());
                });
            }
            return CelFunctionBinding.from("double_to_uint64", Double.class, arg -> {
                if (celOptions.errorOnIntWrap()) {
                    return RuntimeHelpers.doubleToUnsignedChecked(arg).map(UnsignedLong::longValue).orElseThrow(() -> new CelRuntimeException(new IllegalArgumentException("double out of uint range"), CelErrorCode.NUMERIC_OVERFLOW));
                }
                return arg.longValue();
            });
        }),
        STRING_TO_UINT64((celOptions, runtimeEquality) -> {
            if (celOptions.enableUnsignedLongs()) {
                return CelFunctionBinding.from("string_to_uint64", String.class, arg -> {
                    try {
                        return UnsignedLong.valueOf(arg);
                    }
                    catch (NumberFormatException e) {
                        throw new CelRuntimeException(e, CelErrorCode.BAD_FORMAT);
                    }
                });
            }
            return CelFunctionBinding.from("string_to_uint64", String.class, arg -> {
                try {
                    return UnsignedLongs.parseUnsignedLong(arg);
                }
                catch (NumberFormatException e) {
                    throw new CelRuntimeException(e, CelErrorCode.BAD_FORMAT);
                }
            });
        });

        private final CelStandardOverload.FunctionBindingCreator bindingCreator;

        @Override
        public CelFunctionBinding newFunctionBinding(CelOptions celOptions, RuntimeEquality runtimeEquality) {
            return this.bindingCreator.create(celOptions, runtimeEquality);
        }

        private UintOverload(CelStandardOverload.FunctionBindingCreator bindingCreator) {
            this.bindingCreator = bindingCreator;
        }
    }
}

