/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.validator.validators;

import com.google.common.collect.ImmutableSet;
import dev.cel.bundle.Cel;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.navigation.CelNavigableAst;
import dev.cel.common.navigation.CelNavigableExpr;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.validator.CelAstValidator;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public final class HomogeneousLiteralValidator
implements CelAstValidator {
    private final ImmutableSet<String> exemptFunctions;

    public static HomogeneousLiteralValidator newInstance(Iterable<String> exemptFunctions) {
        return new HomogeneousLiteralValidator(exemptFunctions);
    }

    public static HomogeneousLiteralValidator newInstance(String ... exemptFunctions) {
        return HomogeneousLiteralValidator.newInstance(Arrays.asList(exemptFunctions));
    }

    @Override
    public void validate(CelNavigableAst navigableAst, Cel cel, CelAstValidator.IssuesFactory issuesFactory) {
        navigableAst.getRoot().allNodes().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.LIST) || node.getKind().equals((Object)CelExpr.ExprKind.Kind.MAP)).filter(node -> !this.isExemptFunction((CelNavigableExpr)node)).map(rec$ -> (CelExpr)((CelNavigableExpr)rec$).expr()).forEach(expr -> {
            if (expr.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.LIST)) {
                this.validateList(navigableAst.getAst(), issuesFactory, (CelExpr)expr);
            } else if (expr.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.MAP)) {
                this.validateMap(navigableAst.getAst(), issuesFactory, (CelExpr)expr);
            }
        });
    }

    private void validateList(CelAbstractSyntaxTree ast, CelAstValidator.IssuesFactory issuesFactory, CelExpr expr) {
        CelType previousType = null;
        HashSet optionalIndices = new HashSet(expr.list().optionalIndices());
        List elements = expr.list().elements();
        for (int i = 0; i < ((AbstractCollection)((Object)elements)).size(); ++i) {
            CelExpr element = (CelExpr)elements.get(i);
            CelType currentType = ast.getType(element.id()).get();
            if (optionalIndices.contains(i)) {
                currentType = (CelType)currentType.parameters().get(0);
            }
            if (previousType == null) {
                previousType = currentType;
                continue;
            }
            this.reportErrorIfUnassignable(issuesFactory, element.id(), previousType, currentType);
        }
    }

    private void validateMap(CelAbstractSyntaxTree ast, CelAstValidator.IssuesFactory issuesFactory, CelExpr expr) {
        CelType previousKeyType = null;
        CelType previousValueType = null;
        for (CelExpr.CelMap.Entry entry : expr.map().entries()) {
            CelType currentKeyType = ast.getType(entry.key().id()).get();
            CelType currentValueType = ast.getType(entry.value().id()).get();
            if (entry.optionalEntry()) {
                currentValueType = (CelType)currentValueType.parameters().get(0);
            }
            if (previousKeyType == null) {
                previousKeyType = currentKeyType;
                previousValueType = currentValueType;
                continue;
            }
            this.reportErrorIfUnassignable(issuesFactory, entry.id(), previousKeyType, currentKeyType);
            this.reportErrorIfUnassignable(issuesFactory, entry.id(), previousValueType, currentValueType);
        }
    }

    private void reportErrorIfUnassignable(CelAstValidator.IssuesFactory issuesFactory, long elementId, CelType previousType, CelType currentType) {
        if (!previousType.isAssignableFrom(currentType)) {
            issuesFactory.addError(elementId, String.format("expected type '%s' but found '%s'", CelTypes.format(previousType), CelTypes.format(currentType)));
        }
    }

    private boolean isExemptFunction(CelNavigableExpr listExpr) {
        Optional<CelNavigableExpr> parent = listExpr.parent();
        while (parent.isPresent()) {
            CelNavigableExpr node = parent.get();
            if (node.getKind().equals((Object)CelExpr.ExprKind.Kind.CALL) && this.exemptFunctions.contains(((CelExpr)node.expr()).callOrDefault().function())) {
                return true;
            }
            parent = node.parent();
        }
        return false;
    }

    private HomogeneousLiteralValidator(Iterable<String> exemptFunctions) {
        this.exemptFunctions = ImmutableSet.copyOf(exemptFunctions);
    }
}

