/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.validator.validators;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.bundle.Cel;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelSource;
import dev.cel.common.CelValidationException;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelExprFactory;
import dev.cel.common.navigation.CelNavigableAst;
import dev.cel.common.navigation.CelNavigableExpr;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.validator.CelAstValidator;

abstract class LiteralValidator
implements CelAstValidator {
    private final String functionName;
    private final Class<?> expectedResultType;

    protected LiteralValidator(String functionName, Class<?> expectedResultType) {
        this.functionName = functionName;
        this.expectedResultType = expectedResultType;
    }

    @Override
    public void validate(CelNavigableAst navigableAst, Cel cel, CelAstValidator.IssuesFactory issuesFactory) {
        CelExprFactory exprFactory = CelExprFactory.newInstance();
        navigableAst.getRoot().descendants().filter(node -> node.getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT) && node.parent().map(parent -> ((CelExpr)parent.expr()).callOrDefault().function().equals(this.functionName)).orElse(false) != false).map(rec$ -> (CelExpr)((CelNavigableExpr)rec$).expr()).forEach(expr -> {
            CelExpr callExpr = exprFactory.newGlobalCall(this.functionName, exprFactory.newConstant(expr.constant()));
            try {
                LiteralValidator.evaluateExpr(cel, callExpr, this.expectedResultType);
            }
            catch (Exception e) {
                issuesFactory.addError(expr.id(), String.format("%s validation failed. Reason: %s", this.functionName, e.getMessage()));
            }
        });
    }

    @CanIgnoreReturnValue
    private static Object evaluateExpr(Cel cel, CelExpr expr, Class<?> expectedResultType) throws CelValidationException, CelEvaluationException {
        CelAbstractSyntaxTree ast = CelAbstractSyntaxTree.newParsedAst(expr, CelSource.newBuilder().build());
        Object result = cel.createProgram(ast = cel.check(ast).getAst()).eval();
        if (!expectedResultType.isInstance(result)) {
            throw new IllegalStateException(String.format("Expected %s type but got %s instead", expectedResultType.getName(), result.getClass().getName()));
        }
        return result;
    }
}

