/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import java.util.ArrayList;
import java.util.List;

final class Ipv4 {
    private final String str;
    private int index;
    private final List<Short> octets;
    private int prefixLen;

    Ipv4(String str) {
        this.str = str;
        this.octets = new ArrayList<Short>();
    }

    int getBits() {
        if (this.octets.size() != 4) {
            return -1;
        }
        return this.octets.get(0) << 24 | this.octets.get(1) << 16 | this.octets.get(2) << 8 | this.octets.get(3);
    }

    boolean isPrefixOnly() {
        int bits = this.getBits();
        int mask = 0;
        mask = this.prefixLen == 32 ? -1 : ~(-1 >>> this.prefixLen);
        int masked = bits & mask;
        return bits == masked;
    }

    boolean address() {
        return this.addressPart() && this.index == this.str.length();
    }

    boolean addressPrefix() {
        return this.addressPart() && this.take('/') && this.prefixLength() && this.index == this.str.length();
    }

    private boolean prefixLength() {
        int start = this.index;
        while (this.index < this.str.length() && this.digit()) {
            if (this.index - start <= 2) continue;
            return false;
        }
        String str = this.str.substring(start, this.index);
        if (str.isEmpty()) {
            return false;
        }
        if (str.length() > 1 && str.charAt(0) == '0') {
            return false;
        }
        try {
            int val = Integer.parseInt(str);
            if (val > 32) {
                return false;
            }
            this.prefixLen = val;
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean addressPart() {
        int start = this.index;
        if (this.decOctet() && this.take('.') && this.decOctet() && this.take('.') && this.decOctet() && this.take('.') && this.decOctet()) {
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean decOctet() {
        int start = this.index;
        while (this.index < this.str.length() && this.digit()) {
            if (this.index - start <= 3) continue;
            return false;
        }
        String str = this.str.substring(start, this.index);
        if (str.isEmpty()) {
            return false;
        }
        if (str.length() > 1 && str.charAt(0) == '0') {
            return false;
        }
        try {
            int val = Integer.parseInt(str);
            if (val > 255) {
                return false;
            }
            this.octets.add((short)val);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean digit() {
        char c = this.str.charAt(this.index);
        if ('0' <= c && c <= '9') {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean take(char c) {
        if (this.index >= this.str.length()) {
            return false;
        }
        if (this.str.charAt(this.index) == c) {
            ++this.index;
            return true;
        }
        return false;
    }
}

