/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Ipv4;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class Ipv6 {
    private final String str;
    private int index;
    private final List<Integer> pieces;
    private int doubleColonAt;
    private boolean doubleColonSeen;
    private String dottedRaw;
    private @Nullable Ipv4 dottedAddr;
    private boolean zoneIDFound;
    private int prefixLen;

    Ipv6(String str) {
        this.str = str;
        this.pieces = new ArrayList<Integer>();
        this.doubleColonAt = -1;
        this.dottedRaw = "";
    }

    private long[] getBits() {
        List<Integer> p16 = this.pieces;
        if (this.dottedAddr != null) {
            long dotted32 = this.dottedAddr.getBits();
            p16.add((int)(dotted32 >> 16));
            p16.add((int)dotted32);
        }
        if (this.doubleColonSeen) {
            while (p16.size() < 8) {
                p16.add(this.doubleColonAt, 0);
            }
        }
        if (p16.size() != 8) {
            return new long[]{0L, 0L};
        }
        return new long[]{Long.valueOf(p16.get(0).intValue()) << 48 | Long.valueOf(p16.get(1).intValue()) << 32 | Long.valueOf(p16.get(2).intValue()) << 16 | Long.valueOf(p16.get(3).intValue()), Long.valueOf(p16.get(4).intValue()) << 48 | Long.valueOf(p16.get(5).intValue()) << 32 | Long.valueOf(p16.get(6).intValue()) << 16 | Long.valueOf(p16.get(7).intValue())};
    }

    boolean isPrefixOnly() {
        long[] bits = this.getBits();
        for (int i = 0; i < bits.length; ++i) {
            long p64 = bits[i];
            long size = (long)this.prefixLen - 64L * (long)i;
            long mask = 0L;
            mask = size >= 64L ? -1L : (size < 0L ? 0L : -1L >>> (int)size ^ 0xFFFFFFFFFFFFFFFFL);
            long masked = p64 & mask;
            if (p64 == masked) continue;
            return false;
        }
        return true;
    }

    boolean address() {
        return this.addressPart() && this.index == this.str.length();
    }

    boolean addressPrefix() {
        return this.addressPart() && !this.zoneIDFound && this.take('/') && this.prefixLength() && this.index == this.str.length();
    }

    private boolean prefixLength() {
        int start = this.index;
        while (this.index < this.str.length() && this.digit()) {
            if (this.index - start <= 3) continue;
            return false;
        }
        String str = this.str.substring(start, this.index);
        if (str.isEmpty()) {
            return false;
        }
        if (str.length() > 1 && str.charAt(0) == '0') {
            return false;
        }
        try {
            int val = Integer.parseInt(str);
            if (val > 128) {
                return false;
            }
            this.prefixLen = val;
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean addressPart() {
        while (this.index < this.str.length()) {
            if ((this.doubleColonSeen || this.pieces.size() == 6) && this.dotted()) {
                Ipv4 dotted = new Ipv4(this.dottedRaw);
                if (dotted.address()) {
                    this.dottedAddr = dotted;
                    return true;
                }
                return false;
            }
            try {
                if (this.h16()) {
                    continue;
                }
            }
            catch (IllegalStateException | NumberFormatException e) {
                return false;
            }
            if (this.take(':')) {
                if (this.take(':')) {
                    if (this.doubleColonSeen) {
                        return false;
                    }
                    this.doubleColonSeen = true;
                    this.doubleColonAt = this.pieces.size();
                    if (!this.take(':')) continue;
                    return false;
                }
                if (this.index != 1 && this.index != this.str.length()) continue;
                return false;
            }
            if (this.str.charAt(this.index) != '%' || this.zoneID()) break;
            return false;
        }
        int totalPieces = this.pieces.size();
        if (this.doubleColonSeen) {
            return totalPieces < 8;
        }
        return totalPieces == 8;
    }

    private boolean zoneID() {
        int start = this.index;
        if (this.take('%') && this.str.length() - this.index > 0) {
            this.index = this.str.length();
            this.zoneIDFound = true;
            return true;
        }
        this.index = start;
        this.zoneIDFound = false;
        return false;
    }

    private boolean dotted() {
        int start = this.index;
        this.dottedRaw = "";
        while (this.index < this.str.length() && (this.digit() || this.take('.'))) {
        }
        if (this.index - start >= 7) {
            this.dottedRaw = this.str.substring(start, this.index);
            return true;
        }
        this.index = start;
        return false;
    }

    private boolean h16() throws IllegalStateException, NumberFormatException {
        int start = this.index;
        while (this.index < this.str.length() && this.hexDig()) {
        }
        String str = this.str.substring(start, this.index);
        if (str.isEmpty()) {
            return false;
        }
        if (str.length() > 4) {
            throw new IllegalStateException("invalid hex");
        }
        int val = Integer.parseInt(str, 16);
        this.pieces.add(val);
        return true;
    }

    private boolean hexDig() {
        char c = this.str.charAt(this.index);
        if ('0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F') {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean digit() {
        char c = this.str.charAt(this.index);
        if ('0' <= c && c <= '9') {
            ++this.index;
            return true;
        }
        return false;
    }

    private boolean take(char c) {
        if (this.index >= this.str.length()) {
            return false;
        }
        if (this.str.charAt(this.index) == c) {
            ++this.index;
            return true;
        }
        return false;
    }
}

