/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.FieldPathUtils;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.RuleViolationHelper;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.ValueEvaluator;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldPathElement;
import build.buf.validate.FieldRules;
import build.buf.validate.MapRules;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class MapEvaluator
implements Evaluator {
    private static final FieldPath MAP_KEYS_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(FieldRules.getDescriptor().findFieldByNumber(19))).addElements(FieldPathUtils.fieldPathElement(MapRules.getDescriptor().findFieldByNumber(4))).build();
    private static final FieldPath MAP_VALUES_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(FieldRules.getDescriptor().findFieldByNumber(19))).addElements(FieldPathUtils.fieldPathElement(MapRules.getDescriptor().findFieldByNumber(5))).build();
    private final RuleViolationHelper helper;
    private final ValueEvaluator keyEvaluator;
    private final ValueEvaluator valueEvaluator;
    final Descriptors.FieldDescriptor fieldDescriptor;
    final Descriptors.FieldDescriptor keyFieldDescriptor;
    final Descriptors.FieldDescriptor valueFieldDescriptor;

    MapEvaluator(ValueEvaluator valueEvaluator, Descriptors.FieldDescriptor fieldDescriptor) {
        this.helper = new RuleViolationHelper(valueEvaluator);
        this.keyEvaluator = new ValueEvaluator(null, MAP_KEYS_RULE_PATH);
        this.valueEvaluator = new ValueEvaluator(null, MAP_VALUES_RULE_PATH);
        this.fieldDescriptor = fieldDescriptor;
        this.keyFieldDescriptor = fieldDescriptor.getMessageType().findFieldByNumber(1);
        this.valueFieldDescriptor = fieldDescriptor.getMessageType().findFieldByNumber(2);
    }

    ValueEvaluator getKeyEvaluator() {
        return this.keyEvaluator;
    }

    ValueEvaluator getValueEvaluator() {
        return this.valueEvaluator;
    }

    @Override
    public boolean tautology() {
        return this.keyEvaluator.tautology() && this.valueEvaluator.tautology();
    }

    @Override
    public List<RuleViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        ArrayList<RuleViolation.Builder> violations = new ArrayList<RuleViolation.Builder>();
        Map<Value, Value> mapValue = val.mapValue();
        for (Map.Entry<Value, Value> entry : mapValue.entrySet()) {
            violations.addAll(this.evalPairs(entry.getKey(), entry.getValue(), failFast));
            if (!failFast || violations.isEmpty()) continue;
            return violations;
        }
        if (violations.isEmpty()) {
            return RuleViolation.NO_VIOLATIONS;
        }
        return violations;
    }

    private List<RuleViolation.Builder> evalPairs(Value key, Value value, boolean failFast) throws ExecutionException {
        List keyViolations = this.keyEvaluator.evaluate(key, failFast).stream().map(violation -> violation.setForKey(true)).collect(Collectors.toList());
        List<RuleViolation.Builder> valueViolations = failFast && !keyViolations.isEmpty() ? RuleViolation.NO_VIOLATIONS : this.valueEvaluator.evaluate(value, failFast);
        if (keyViolations.isEmpty() && valueViolations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RuleViolation.Builder> violations = new ArrayList<RuleViolation.Builder>(keyViolations.size() + valueViolations.size());
        violations.addAll(keyViolations);
        violations.addAll(valueViolations);
        FieldPathElement.Builder fieldPathElementBuilder = Objects.requireNonNull(this.helper.getFieldPathElement()).toBuilder();
        fieldPathElementBuilder.setKeyType(this.keyFieldDescriptor.getType().toProto());
        fieldPathElementBuilder.setValueType(this.valueFieldDescriptor.getType().toProto());
        switch (this.keyFieldDescriptor.getType().toProto()) {
            case TYPE_INT64: 
            case TYPE_INT32: 
            case TYPE_SINT32: 
            case TYPE_SINT64: 
            case TYPE_SFIXED32: 
            case TYPE_SFIXED64: {
                fieldPathElementBuilder.setIntKey(key.value(Number.class).longValue());
                break;
            }
            case TYPE_UINT32: 
            case TYPE_UINT64: 
            case TYPE_FIXED32: 
            case TYPE_FIXED64: {
                fieldPathElementBuilder.setUintKey(key.value(Number.class).longValue());
                break;
            }
            case TYPE_BOOL: {
                fieldPathElementBuilder.setBoolKey(key.value(Boolean.class));
                break;
            }
            case TYPE_STRING: {
                fieldPathElementBuilder.setStringKey(key.value(String.class));
                break;
            }
            default: {
                throw new ExecutionException("Unexpected map key type");
            }
        }
        FieldPathElement fieldPathElement = fieldPathElementBuilder.build();
        return FieldPathUtils.updatePaths(violations, fieldPathElement, this.helper.getRulePrefixElements());
    }
}

